/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.ui.server.util;

import com.ericsson.cms.sites.core.entities.Contact;
import com.ericsson.cms.sites.core.entities.Property;
import com.ericsson.cms.sites.core.entities.SitePartner;
import com.ericsson.cms.sites.ui.client.entities.UIContact;
import com.ericsson.cms.sites.ui.client.entities.UIProperty;
import com.ericsson.cms.sites.ui.client.entities.UISitePartner;

public class SitePartnerUtils {
    public static SitePartner convert(UISitePartner uisp) {
        SitePartner sp = new SitePartner();
        sp.setContextId(uisp.getContextId());
        sp.setLookupKey(uisp.getLookupKey());
        sp.setProviderId(uisp.getProviderId());
        for (UIProperty p : uisp.getProperties()) {
            sp.addProperty(p.getName(), p.getValue());
        }
        UIContact uic = uisp.getContact();
        if (uic != null) {
            sp.setContact(new Contact(uic.getFirstName(), uic.getLastName(), uic.getEmail()));
        }
        return sp;
    }

    public static UISitePartner convert(SitePartner sp) {
        UISitePartner uisp = new UISitePartner();
        uisp.setContextId(sp.getContextId());
        uisp.setLookupKey(sp.getLookupKey());
        uisp.setProviderId(sp.getProviderId());
        for (Property p : sp.getProperties()) {
            uisp.addProperty(p.getName(), p.getValue());
        }
        Contact c = sp.getContact();
        if (c != null) {
            uisp.setContact(new UIContact(c.getFirstName(), c.getLastName(), c.getEmail()));
        }
        return uisp;
    }
}

