/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.client.criteria;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.TitleConstants;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaPanelType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UIDataType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.PredicateList;
import com.tandbergtv.cms.portal.ui.title.client.criteria.PredicateRow;
import com.tandbergtv.cms.portal.ui.title.client.criteria.PredicateRowBase;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.criteria.Validatable;
import com.tandbergtv.cms.portal.ui.title.client.model.search.BaseOperator;
import com.tandbergtv.cms.portal.ui.title.client.model.search.IUITitleFilterNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.RhsType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.RulesOperatorLimited;
import com.tandbergtv.cms.portal.ui.title.client.model.search.TitleFilterOperator;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIParamType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterComplexValue;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterConditionNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterListNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterRHSFieldNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterValueNode;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class CriteriaListingPanel
extends SimplePanel
implements Validatable {
    public static final String CRITERIA_PANEL_CONTAINER_STYLE = "criteria-panel-container";
    public static final String CRITERIA_PANEL_STYLE = "criteria-panel";
    private VerticalPanel container = new VerticalPanel();
    protected BaseOperator operatorProvider;
    protected int maxLevels = 2;
    private PredicateList uiRoot;
    private VerticalPanel warningMessages = new VerticalPanel();
    protected Set<String> currentErrorCodes = new HashSet<String>();
    private TitleConstants myConstants = (TitleConstants)GWT.create(TitleConstants.class);
    private UiCriteriaMode criteriaMode;

    protected CriteriaListingPanel(UiCriteriaMode critMode) {
        this.criteriaMode = critMode;
        this.setWidget((Widget)this.container);
    }

    public CriteriaListingPanel(UiCriteriaMode critMode, IUITitleFilterNode rule, BaseOperator searchOperatorType) {
        this(critMode);
        this.operatorProvider = searchOperatorType;
        this.getContainer().add((Widget)this.warningMessages);
        this.initializeTree(rule);
    }

    public void setFilter(IUITitleFilterNode rule) {
        if (rule != null) {
            this.clearCriteria();
            this.populateUiObjects(this.uiRoot, (UITitleFilterListNode)rule);
        }
    }

    public void clearCriteria() {
        this.clearWarningMessages();
        this.uiRoot.clearChildPanel(false);
    }

    public void resetCriteria() {
        this.uiRoot.clearChildPanel(true);
        this.uiRoot.setOperator(TitleFilterOperator.AND);
    }

    private void populateUiObjects(PredicateList root, UITitleFilterListNode tree) {
        root.setOperator(tree.getUiRetOperator());
        for (int i = 0; i < tree.getList().size(); ++i) {
            IUITitleFilterNode node = tree.getList().get(i);
            if (node instanceof UITitleFilterComplexValue) {
                PredicateRow child = this.convertUiNode(node);
                root.addChildRow(child);
                child.setAddRowButtonVisible(true);
                UITitleFilterComplexValue compValue = (UITitleFilterComplexValue)node;
                for (UITitleFilterConditionNode evalNode : compValue.getChildren()) {
                    this.addEvalChildNodes(child, evalNode);
                }
                continue;
            }
            if (node instanceof UITitleFilterConditionNode) {
                root.addChildRow(this.convertUiNode(node));
                continue;
            }
            if (!(node instanceof UITitleFilterListNode)) continue;
            PredicateList list = new PredicateList(root);
            root.addChildRow(list);
            this.populateUiObjects(list, (UITitleFilterListNode)node);
        }
    }

    private void addEvalChildNodes(PredicateRow child, UITitleFilterConditionNode evalNode) {
        IFieldTreeObject xmlObj = child.getLhsTreeObject();
        PredicateRow childEvalNode = this.convertEvalChildNode(evalNode, xmlObj);
        child.addChildRow(childEvalNode);
    }

    private PredicateRow convertUiNode(IUITitleFilterNode node) {
        UITitleFilterConditionNode predicateNode = (UITitleFilterConditionNode)node;
        PredicateRow row = new PredicateRow(this, predicateNode);
        return row;
    }

    private PredicateRow convertEvalChildNode(IUITitleFilterNode node, IFieldTreeObject obj) {
        UITitleFilterConditionNode predicateNode = (UITitleFilterConditionNode)node;
        PredicateRow row = new PredicateRow(this, obj, predicateNode);
        return row;
    }

    protected void initializeTree(IUITitleFilterNode rule) {
        this.uiRoot = new PredicateList(this, this.maxLevels);
        if (rule == null || rule instanceof UITitleFilterListNode && ((UITitleFilterListNode)rule).getList().isEmpty()) {
            PredicateRow defaultRow = new PredicateRow(this);
            this.uiRoot.addChildRow(defaultRow);
        } else {
            this.clearCriteria();
            this.populateUiObjects(this.uiRoot, (UITitleFilterListNode)rule);
        }
        this.getContainer().add((Widget)this.uiRoot);
    }

    public PredicateList getRoot() {
        return this.uiRoot;
    }

    @Override
    public boolean validate() {
        this.clearWarningMessages();
        boolean passes = this.uiRoot.validate();
        if (!passes) {
            this.addWarningMessage(this.myConstants.ruleValidationBadCriteria());
        }
        return passes;
    }

    public boolean canChangePredicateRow(PredicateRow row) {
        return true;
    }

    public void notifyChange(IFieldTreeObject newObject) {
    }

    public void notifyRemoval(IFieldTreeObject xmlTreeObject) {
    }

    public void addWarningMessage(String messageTxt) {
        if (this.currentErrorCodes.add(messageTxt)) {
            LabelWidget message = new LabelWidget(messageTxt);
            message.addStyleName("red-txt");
            this.warningMessages.add((Widget)message);
        }
    }

    public void removeWarningMessage(String msg) {
        if (this.currentErrorCodes.remove(this.currentErrorCodes)) {
            Iterator iterator = this.warningMessages.iterator();
            while (iterator.hasNext()) {
                LabelWidget label;
                Widget w = (Widget)iterator.next();
                if (!(w instanceof LabelWidget) || !(label = (LabelWidget)w).getText().equals(msg)) continue;
                iterator.remove();
                return;
            }
        }
    }

    public void clearWarningMessages() {
        this.warningMessages.clear();
        this.currentErrorCodes.clear();
    }

    public VerticalPanel getWarningMessageBox() {
        return this.warningMessages;
    }

    public boolean containsTreeObject(IFieldTreeObject treeObject) {
        return this.uiRoot.contains(treeObject);
    }

    public BaseOperator getOperatorProvider() {
        return this.operatorProvider;
    }

    public boolean isEmpty() {
        return this.getRoot().isEmpty();
    }

    public VerticalPanel getContainer() {
        return this.container;
    }

    public UITitleFilterListNode getCriteria() {
        PredicateList row = this.getRoot();
        UITitleFilterListNode tree = new UITitleFilterListNode();
        this.populateTree(tree, row);
        return tree;
    }

    public void populateTree(UITitleFilterListNode list, PredicateList row) {
        TitleFilterOperator op = row.getOperator();
        list.setUiRetOperator(op);
        for (PredicateRowBase predNode : row.getChildRowNodes()) {
            if (predNode instanceof PredicateRow) {
                PredicateRow validationRow = (PredicateRow)predNode;
                if (!validationRow.hasContents()) continue;
                UITitleFilterConditionNode valueNode = this.createUiPredicate(validationRow);
                list.addItem(valueNode);
                continue;
            }
            if (!(predNode instanceof PredicateList)) continue;
            PredicateList cl = (PredicateList)predNode;
            UITitleFilterListNode childList = new UITitleFilterListNode();
            this.populateTree(childList, cl);
            if (childList.isEmpty()) continue;
            list.addItem(childList);
        }
    }

    private UITitleFilterConditionNode createUiPredicate(PredicateRow row) {
        String fieldLhs = row.getLhsTreeObject().getField();
        String fieldLhsDisplayName = row.getLhsTreeObject().getFullDisplayName();
        UIDataType dataType = row.getLhsTreeObject().getDataType();
        String sectionTypeLhs = row.getLhsTreeObject().getAssetType();
        BaseOperator op = (BaseOperator)row.getOperatorList().getSelectedItem();
        UIFieldType fieldTypeLhs = row.getLhsTreeObject().getFieldType();
        UIParamType paramType = row.getParamType();
        boolean not = row.isNot();
        UITitleFilterConditionNode condition = null;
        if (row.getRhsType().equals((Object)RhsType.COMPLEX)) {
            ArrayList<UITitleFilterConditionNode> children = new ArrayList<UITitleFilterConditionNode>();
            for (PredicateRowBase r : row.getChildRowNodes()) {
                if (!(r instanceof PredicateRow)) continue;
                PredicateRow evalRow = (PredicateRow)r;
                children.add(this.createUiPredicate(evalRow));
            }
            condition = new UITitleFilterComplexValue(fieldLhs, sectionTypeLhs, op, paramType, children, row.isNot(), fieldTypeLhs, fieldLhsDisplayName, null, null);
        } else if (row.getRhsType().equals((Object)RhsType.FIELD)) {
            IFieldTreeObject rhs = row.getRhsTreeObject();
            String fieldRhs = rhs.getField();
            String fieldRhsDisplayName = rhs.getFullDisplayName();
            String sectionTypeRhs = rhs.getAssetType();
            UIFieldType fieldTypeRhs = rhs.getFieldType();
            condition = new UITitleFilterRHSFieldNode(fieldLhs, sectionTypeLhs, fieldTypeLhs, fieldLhsDisplayName, op, paramType, true, not, dataType, fieldRhs, sectionTypeRhs, fieldTypeRhs, fieldRhsDisplayName, null, null, null);
        } else {
            List<String> value = row.getValue();
            condition = new UITitleFilterValueNode(fieldLhs, sectionTypeLhs, fieldTypeLhs, op, value, paramType, true, not, dataType, fieldLhsDisplayName, null, null);
        }
        return condition;
    }

    public CriteriaPanelType getCriteriaPanelType() {
        return CriteriaPanelType.SEARCH;
    }

    public UiCriteriaMode getCriteriaMode() {
        return this.criteriaMode;
    }

    public void setCriteriaMode(UiCriteriaMode critMode) {
        this.criteriaMode = critMode;
    }

    public CriteriaType getLhsCriteriaType() {
        CriteriaType critType = CriteriaType.SEARCH_CONDITION_LHS;
        if (this.operatorProvider instanceof RulesOperatorLimited) {
            critType = CriteriaType.RULE_CONDITION_LHS;
        }
        return critType;
    }

    public CriteriaType getRhsCriteriaType() {
        return CriteriaType.CONDITION_RHS;
    }
}

