/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.client.criteria;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.TitleConstants;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;

public class CriteriaModeSelector
extends HorizontalPanel
implements HasSelectionHandlers<UiCriteriaMode> {
    private TitleConstants myConstants = (TitleConstants)GWT.create(TitleConstants.class);
    private ListBoxWidget<UiCriteriaMode> listBox;
    private Label label = new Label(this.myConstants.TitleTypeLabel());
    private TextBox lockedDisplay;
    private SimplePanel widgetContainer = new SimplePanel();

    public CriteriaModeSelector() {
        this(UiCriteriaMode.EPISODE, false);
    }

    public CriteriaModeSelector(UiCriteriaMode critMode, boolean locked) {
        if (!locked) {
            this.initializeListBox();
        } else {
            this.initializeLockedDisplay(critMode);
            this.setValue(critMode);
        }
        this.setVerticalAlignment(ALIGN_MIDDLE);
        this.add((Widget)this.label);
        this.add((Widget)this.widgetContainer);
    }

    private void initializeLockedDisplay(UiCriteriaMode critMode) {
        this.lockedDisplay = new TextBox();
        this.lockedDisplay.setValue((Object)this.getLabelValue(critMode));
        this.lockedDisplay.setVisibleLength(8);
        this.lockedDisplay.setReadOnly(true);
    }

    private void initializeListBox() {
        this.listBox = new ListBoxWidget();
        this.listBox.addItem(this.myConstants.episode(), (Object)UiCriteriaMode.EPISODE);
        this.listBox.addItem(this.myConstants.series(), (Object)UiCriteriaMode.SERIES);
        this.listBox.setSelectedItem((Object)UiCriteriaMode.EPISODE);
        this.listBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                SelectionEvent.fire((HasSelectionHandlers)CriteriaModeSelector.this, (Object)CriteriaModeSelector.this.listBox.getSelectedItem());
            }
        });
        this.widgetContainer.setWidget(this.listBox);
    }

    public UiCriteriaMode getValue() {
        if (this.listBox != null) {
            return (UiCriteriaMode)((Object)this.listBox.getSelectedItem());
        }
        if (this.lockedDisplay.getText().equals(this.myConstants.episode())) {
            return UiCriteriaMode.EPISODE;
        }
        return UiCriteriaMode.SERIES;
    }

    public void setValue(UiCriteriaMode critMode) {
        if (this.listBox != null) {
            this.listBox.setSelectedItem((Object)critMode);
        } else {
            this.lockedDisplay.setText(this.getLabelValue(critMode));
        }
    }

    private String getLabelValue(UiCriteriaMode critMode) {
        if (critMode.equals((Object)UiCriteriaMode.EPISODE)) {
            return this.myConstants.episode();
        }
        return this.myConstants.series();
    }

    public void setLocked(boolean lock) {
        if (lock) {
            this.initializeLockedDisplay((UiCriteriaMode)((Object)this.listBox.getSelectedItem()));
            this.widgetContainer.setWidget((Widget)this.lockedDisplay);
        } else if (this.listBox == null) {
            this.initializeListBox();
            this.widgetContainer.setWidget(this.listBox);
        } else {
            this.widgetContainer.setWidget(this.listBox);
        }
    }

    public HandlerRegistration addSelectionHandler(SelectionHandler<UiCriteriaMode> handler) {
        return this.addHandler((EventHandler)handler, SelectionEvent.getType());
    }
}

