/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UIDataType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class AssetFieldTreeObject
implements IsSerializable,
IFieldTreeObject {
    private static final long serialVersionUID = 1L;
    protected static Map<String, Map<String, String>> fieldOptions;
    private String field;
    private UIDataType dataType;
    private String assetPath;
    private String extendedDisplayName;
    private String displayName = "";
    private String simpleDisplayName;
    private String complexType;
    private List<IFieldTreeObject> children;

    public static void setFieldOptions(Map<String, Map<String, String>> contentClassOptions) {
        fieldOptions = contentClassOptions;
    }

    public static Map<String, Map<String, String>> getFieldOptions() {
        return fieldOptions;
    }

    public AssetFieldTreeObject(String field, UIDataType dataType, String assetPath, String displayName, String complexType, String extendedDisplayName) {
        int beginIndex;
        this.field = field;
        this.dataType = dataType;
        this.assetPath = assetPath;
        this.displayName = displayName;
        this.extendedDisplayName = extendedDisplayName;
        if (displayName != null && (beginIndex = displayName.lastIndexOf(".") + 1) > 0) {
            this.simpleDisplayName = displayName.substring(beginIndex);
        }
        this.complexType = complexType;
    }

    public AssetFieldTreeObject() {
    }

    @Override
    public UIDataType getDataType() {
        return this.dataType;
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public String getAssetType() {
        return this.assetPath;
    }

    @Override
    public String getFullDisplayName() {
        return this.displayName;
    }

    @Override
    public String getSimpleDisplayName() {
        return this.simpleDisplayName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AssetFieldTreeObject) {
            AssetFieldTreeObject otherVal = (AssetFieldTreeObject)obj;
            boolean assetTypeEqual = otherVal.getAssetType().equals(this.getAssetType());
            boolean xpathEqual = otherVal.getField().equals(this.getField());
            return assetTypeEqual && xpathEqual;
        }
        return false;
    }

    public String toString() {
        return this.getAssetType() + "|" + this.getField();
    }

    @Override
    public UIFieldType getFieldType() {
        return UIFieldType.ASSET;
    }

    @Override
    public Collection<UIValueOption> getSuggestedValues() {
        if (fieldOptions == null) {
            Window.alert((String)"AssetFieldOptionProvider isn't being loaded");
            return new ArrayList<UIValueOption>();
        }
        if (!fieldOptions.containsKey(this.getField())) {
            return null;
        }
        ArrayList<UIValueOption> uiOptions = new ArrayList<UIValueOption>();
        for (Map.Entry<String, String> option : fieldOptions.get(this.getField()).entrySet()) {
            uiOptions.add(new UIValueOption(option.getValue(), option.getKey()));
        }
        return uiOptions;
    }

    @Override
    public boolean supportsActions() {
        return true;
    }

    @Override
    public boolean childSupportsActions() {
        return !this.getAssetType().startsWith("SERIES");
    }

    @Override
    public boolean supportsOther() {
        return true;
    }

    public boolean supportsRHSField() {
        return !this.getDataType().equals((Object)UIDataType.COMPLEX);
    }

    @Override
    public boolean hasSuggestedValues() {
        return fieldOptions != null && fieldOptions.get(this.getField()) != null;
    }

    @Override
    public boolean supportsCriteriaType(CriteriaType critType, UiCriteriaMode critMode) {
        if (this.getField().equals("/Fields/CustomFields")) {
            return false;
        }
        return this.commonSupportLogic(critType, critMode);
    }

    private boolean commonSupportLogic(CriteriaType critType, UiCriteriaMode critMode) {
        if (critType.equals((Object)CriteriaType.BASIC_METADATA)) {
            return this.getAssetType().startsWith("PACKAGE") && critMode.equals((Object)UiCriteriaMode.EPISODE) || this.getAssetType().startsWith("SERIES") && critMode.equals((Object)UiCriteriaMode.SERIES);
        }
        if (critMode.equals((Object)UiCriteriaMode.SERIES) && this.getAssetType().startsWith("PACKAGE")) {
            return false;
        }
        if (this.getAssetType().startsWith("SERIES") && critMode.equals((Object)UiCriteriaMode.EPISODE) && (critType.equals((Object)CriteriaType.SEARCH_CONDITION_LHS) || critType.equals((Object)CriteriaType.ACTION_RHS))) {
            return false;
        }
        if (critType.equals((Object)CriteriaType.CONDITION_RHS) || critType.equals((Object)CriteriaType.CONDITION_RHS_LICRULE)) {
            return this.supportsRHSField();
        }
        if (critType.equals((Object)CriteriaType.NORM_ACTION_LHS) || critType.equals((Object)CriteriaType.MSO_ACTION_LHS)) {
            return this.supportsActions();
        }
        if (critType.equals((Object)CriteriaType.ACTION_RHS)) {
            return !critMode.equals((Object)UiCriteriaMode.SERIES) && this.supportsActions() && !this.getAssetType().startsWith("SERIES");
        }
        return true;
    }

    @Override
    public boolean supportsSuggestValues() {
        boolean supportedDataType = this.getDataType().equals((Object)UIDataType.INTEGER) || this.getDataType().equals((Object)UIDataType.FLOAT) || this.getDataType().equals((Object)UIDataType.STRING);
        return supportedDataType && this.hasSuggestedValues();
    }

    @Override
    public boolean supportsMatched() {
        return true;
    }

    @Override
    public boolean childSupportsCriteriaType(CriteriaType critType, UiCriteriaMode critMode) {
        return this.commonSupportLogic(critType, critMode);
    }

    @Override
    public String getComplexType() {
        return this.complexType;
    }

    @Override
    public List<IFieldTreeObject> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<IFieldTreeObject>();
        }
        return this.children;
    }

    public void addChild(IFieldTreeObject child) {
        if (this.children == null) {
            this.children = new ArrayList<IFieldTreeObject>();
        }
        this.children.add(child);
    }

    @Override
    public void setChildren(List<IFieldTreeObject> children) {
        this.children = children;
    }

    @Override
    public String getExtendedDisplayName() {
        return this.extendedDisplayName;
    }

    public int hashCode() {
        return (this.assetPath + this.field).hashCode();
    }
}

