/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.AssetFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.AssetFileTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UIDataType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.IAssetTypeWFileProvider;
import com.tandbergtv.cms.portal.ui.title.client.criteria.IAssetTypeWFileProviderAsync;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class AssetTreeObject
implements IsSerializable,
IFieldTreeObject {
    private static final long serialVersionUID = 1L;
    private static Set<String> AssetTypesWithFile;
    private String displayName;
    private String assetPath;
    private List<IFieldTreeObject> children;
    private String complexType;
    private String extendedDisplayName;

    public AssetTreeObject() {
    }

    public AssetTreeObject(String displayName, String assetPath, String complexType, String extendedDisplayName) {
        this.displayName = displayName;
        this.assetPath = assetPath;
        this.complexType = complexType;
        this.extendedDisplayName = extendedDisplayName;
    }

    public static void initialize(final AsyncCallback<Void> callback) {
        if (AssetTypesWithFile != null) {
            callback.onSuccess(null);
        }
        IAssetTypeWFileProviderAsync service = (IAssetTypeWFileProviderAsync)GWT.create(IAssetTypeWFileProvider.class);
        service.getAssetTypeWFile(new AsyncCallback<Set<String>>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(Set<String> result) {
                AssetTypesWithFile = result;
                callback.onSuccess(null);
            }
        });
    }

    public static boolean isInitialized() {
        return AssetTypesWithFile != null;
    }

    @Override
    public UIDataType getDataType() {
        return UIDataType.COMPLEX;
    }

    @Override
    public UIFieldType getFieldType() {
        return UIFieldType.ASSET;
    }

    @Override
    public String getFullDisplayName() {
        return this.displayName;
    }

    @Override
    public String getSimpleDisplayName() {
        return this.displayName;
    }

    public List<UIValueOption> getSuggestedValues() {
        return new ArrayList<UIValueOption>();
    }

    @Override
    public boolean hasSuggestedValues() {
        return false;
    }

    @Override
    public boolean supportsActions() {
        return this.assetPath.contains("/");
    }

    @Override
    public boolean childSupportsActions() {
        return true;
    }

    @Override
    public boolean supportsOther() {
        return true;
    }

    public boolean supportsRHSField() {
        return true;
    }

    @Override
    public String getAssetType() {
        return this.assetPath;
    }

    @Override
    public String getField() {
        return "";
    }

    public boolean equals(Object obj) {
        if (obj instanceof AssetTreeObject) {
            return ((AssetTreeObject)obj).getAssetType().equals(this.getAssetType());
        }
        return false;
    }

    @Override
    public boolean supportsCriteriaType(CriteriaType critType, UiCriteriaMode critMode) {
        if (critType.equals((Object)CriteriaType.BASIC_METADATA)) {
            return this.getAssetType().startsWith("PACKAGE") && critMode.equals((Object)UiCriteriaMode.EPISODE) || this.getAssetType().startsWith("SERIES") && critMode.equals((Object)UiCriteriaMode.SERIES);
        }
        if (critMode.equals((Object)UiCriteriaMode.SERIES) && this.getAssetType().startsWith("PACKAGE")) {
            return false;
        }
        if (this.getAssetType().startsWith("SERIES") && critMode.equals((Object)UiCriteriaMode.EPISODE) && (critType.equals((Object)CriteriaType.SEARCH_CONDITION_LHS) || critType.equals((Object)CriteriaType.SEARCH_CONDITION_LHS))) {
            return false;
        }
        if (critType.equals((Object)CriteriaType.CONDITION_RHS) || critType.equals((Object)CriteriaType.CONDITION_RHS_LICRULE)) {
            return this.supportsRHSField();
        }
        if (critType.equals((Object)CriteriaType.NORM_ACTION_LHS) || critType.equals((Object)CriteriaType.MSO_ACTION_LHS)) {
            return this.supportsActions();
        }
        if (critType.equals((Object)CriteriaType.ACTION_RHS)) {
            return this.supportsActions();
        }
        return true;
    }

    @Override
    public boolean childSupportsCriteriaType(CriteriaType critType, UiCriteriaMode critMode) {
        if (critType.equals((Object)CriteriaType.NORM_ACTION_LHS) || critType.equals((Object)CriteriaType.MSO_ACTION_LHS) || critType.equals((Object)CriteriaType.ACTION_RHS)) {
            return this.childSupportsActions();
        }
        return this.supportsCriteriaType(critType, critMode);
    }

    @Override
    public boolean supportsSuggestValues() {
        return false;
    }

    public boolean supportsFiles() {
        int beginIndex = this.assetPath.lastIndexOf("/") + 1;
        return AssetTypesWithFile.contains(this.assetPath.substring(beginIndex));
    }

    @Override
    public boolean supportsMatched() {
        return true;
    }

    @Override
    public String getComplexType() {
        return this.complexType;
    }

    @Override
    public List<IFieldTreeObject> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<IFieldTreeObject>();
        }
        return this.children;
    }

    public void addChild(IFieldTreeObject child) {
        if (this.children == null) {
            this.children = new ArrayList<IFieldTreeObject>();
        }
        this.children.add(child);
    }

    @Override
    public void setChildren(List<IFieldTreeObject> children) {
        this.children = children;
    }

    public AssetTreeObject cloneWithoutChildAssetFields() {
        AssetTreeObject clone = new AssetTreeObject(this.getFullDisplayName(), this.assetPath, this.complexType, this.extendedDisplayName);
        ArrayList<IFieldTreeObject> children = new ArrayList<IFieldTreeObject>();
        for (IFieldTreeObject child : this.getChildren()) {
            if (child instanceof AssetFieldTreeObject || child instanceof AssetFileTreeObject) {
                children.add(child);
                continue;
            }
            if (!(child instanceof AssetTreeObject)) continue;
            children.add(new AssetTreeObject(child.getFullDisplayName(), child.getAssetType(), child.getComplexType(), child.getExtendedDisplayName()));
        }
        clone.setChildren(children);
        return clone;
    }

    public AssetTreeObject cloneWithoutChildAsset() {
        AssetTreeObject clone = new AssetTreeObject(this.getFullDisplayName(), this.assetPath, this.complexType, this.extendedDisplayName);
        ArrayList<IFieldTreeObject> children = new ArrayList<IFieldTreeObject>();
        for (IFieldTreeObject child : this.children) {
            if (!(child instanceof AssetFieldTreeObject)) continue;
            children.add(child);
        }
        clone.setChildren(children);
        return clone;
    }

    @Override
    public String getExtendedDisplayName() {
        return this.extendedDisplayName;
    }

    public int hashCode() {
        return this.assetPath.hashCode();
    }
}

