/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UIDataType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LicenseTreeObject
implements IsSerializable,
IFieldTreeObject {
    private static final long serialVersionUID = 1L;
    private Collection<UIValueOption> suggestedValues;
    private String field;
    private String displayName;
    private UIDataType dataType;
    private List<IFieldTreeObject> children;
    private String extendDisplayName;

    public LicenseTreeObject() {
    }

    public LicenseTreeObject(String field, String displayName, UIDataType dataType, String extendDisplayName) {
        this.field = field;
        this.displayName = displayName;
        this.dataType = dataType;
        this.extendDisplayName = extendDisplayName;
        this.suggestedValues = new ArrayList<UIValueOption>(0);
    }

    public LicenseTreeObject(String field, String displayName, UIDataType dataType, Collection<UIValueOption> suggestedValues, String extendDisplayName) {
        this(field, displayName, dataType, extendDisplayName);
        this.suggestedValues = suggestedValues;
    }

    @Override
    public String getSimpleDisplayName() {
        return this.displayName;
    }

    @Override
    public String getFullDisplayName() {
        return "Licensing." + this.displayName;
    }

    @Override
    public Collection<UIValueOption> getSuggestedValues() {
        return this.suggestedValues;
    }

    @Override
    public UIFieldType getFieldType() {
        return UIFieldType.LICENSE;
    }

    @Override
    public UIDataType getDataType() {
        return this.dataType;
    }

    @Override
    public boolean supportsActions() {
        return !this.dataType.equals((Object)UIDataType.COMPLEX);
    }

    @Override
    public boolean childSupportsActions() {
        return true;
    }

    @Override
    public boolean hasSuggestedValues() {
        return !this.suggestedValues.isEmpty();
    }

    @Override
    public boolean supportsOther() {
        return true;
    }

    @Override
    public boolean supportsSuggestValues() {
        boolean supportedDataType = this.getDataType().equals((Object)UIDataType.INTEGER) || this.getDataType().equals((Object)UIDataType.FLOAT) || this.getDataType().equals((Object)UIDataType.STRING);
        return supportedDataType && this.hasSuggestedValues();
    }

    public boolean supportsRHSField() {
        return true;
    }

    @Override
    public boolean supportsCriteriaType(CriteriaType critType, UiCriteriaMode critMode) {
        if (critMode.equals((Object)UiCriteriaMode.SERIES) || this.dataType.equals((Object)UIDataType.COMPLEX)) {
            return false;
        }
        return this.childSupportsCriteriaType(critType, critMode);
    }

    @Override
    public String getAssetType() {
        return "LICENSE";
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public boolean supportsMatched() {
        return false;
    }

    @Override
    public boolean childSupportsCriteriaType(CriteriaType critType, UiCriteriaMode critMode) {
        if (critMode.equals((Object)UiCriteriaMode.SERIES)) {
            return false;
        }
        switch (critType) {
            case CONDITION_RHS: {
                return true;
            }
            case RULE_CONDITION_LHS: {
                return true;
            }
            case SEARCH_CONDITION_LHS: {
                return false;
            }
            case NORM_ACTION_LHS: {
                return true;
            }
            case MSO_ACTION_LHS: {
                return true;
            }
            case ACTION_RHS: {
                return false;
            }
        }
        return false;
    }

    @Override
    public String getComplexType() {
        return null;
    }

    @Override
    public List<IFieldTreeObject> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<IFieldTreeObject>();
        }
        return this.children;
    }

    public void addChild(IFieldTreeObject child) {
        if (this.children == null) {
            this.children = new ArrayList<IFieldTreeObject>();
        }
        this.children.add(child);
    }

    @Override
    public void setChildren(List<IFieldTreeObject> children) {
        this.children = children;
    }

    @Override
    public String getExtendedDisplayName() {
        return "Licensing." + this.extendDisplayName;
    }
}

