/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.client.criteria;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaListingPanel;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.PredicateRow;
import com.tandbergtv.cms.portal.ui.title.client.criteria.PredicateRowBase;
import com.tandbergtv.cms.portal.ui.title.client.model.search.TitleFilterOperator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ToggleButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class PredicateList
extends PredicateRowBase {
    private static final String BRACKET_STYLE = "bracket";
    private static final String PAD_PREDICATE_LIST_STYLE = "pad-predicate-list";
    private TitleFilterOperator listOperator;
    private LabelWidget label;
    private FlexTable container;
    private SimplePanel panel = new SimplePanel();
    private int maxLevels = 2;
    private ToggleButtonWidget tg;

    public PredicateList(CriteriaListingPanel parentContainer, int maxLevels) {
        super(parentContainer);
        this.setMaxLevels(maxLevels);
        this.container = this.createContainer();
        this.panel.setWidget((Widget)this.container);
        this.add((Widget)this.panel);
    }

    public PredicateList(PredicateList parentList) {
        super(parentList.root);
        this.setMaxLevels(parentList.maxLevels);
        this.setParentList(parentList);
        this.container = this.createContainer();
        this.panel.setWidget((Widget)this.container);
        this.add((Widget)this.panel);
        this.panel.addStyleName(PAD_PREDICATE_LIST_STYLE);
    }

    private FlexTable createContainer() {
        this.label = new LabelWidget();
        this.tg = new ToggleButtonWidget("AND", "OR");
        this.setOperator(TitleFilterOperator.AND);
        this.label.setStyleName("bracket-label");
        VerticalContainer labelContainer = new VerticalContainer();
        this.tg.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (PredicateList.this.listOperator.equals((Object)TitleFilterOperator.AND)) {
                    PredicateList.this.setOperator(TitleFilterOperator.OR);
                } else {
                    PredicateList.this.setOperator(TitleFilterOperator.AND);
                }
            }
        });
        labelContainer.add((Widget)this.tg);
        FlexTable tableContainer = new FlexTable();
        tableContainer.setWidget(0, 0, (Widget)this.tg);
        tableContainer.getCellFormatter().setStyleName(0, 0, BRACKET_STYLE);
        VerticalPanel rightSide = new VerticalPanel();
        rightSide.add((Widget)this.getChildrenPanel());
        rightSide.add(this.buildButtonPanel());
        tableContainer.setWidget(0, 1, (Widget)rightSide);
        return tableContainer;
    }

    public TitleFilterOperator getOperator() {
        return this.listOperator;
    }

    public void setOperator(TitleFilterOperator op) {
        this.listOperator = op;
        if (this.listOperator.equals((Object)TitleFilterOperator.AND)) {
            this.label.setText(this.myConstants.and());
            this.label.setTitle(this.myConstants.andTitle());
            this.tg.setDown(false);
        } else {
            this.label.setText(this.myConstants.or());
            this.label.setTitle(this.myConstants.orTitle());
            this.tg.setDown(true);
        }
    }

    public boolean contains(IFieldTreeObject treeObject) {
        return this.predicateRowsWithTreeObject(treeObject) > 0;
    }

    public int predicateRowsWithTreeObject(IFieldTreeObject treeObject) {
        int count = 0;
        for (Widget w : this.getChildrenPanel()) {
            PredicateRowBase row = (PredicateRowBase)w;
            if (row instanceof PredicateList) {
                count += ((PredicateList)row).predicateRowsWithTreeObject(treeObject);
                continue;
            }
            PredicateRow predRow = (PredicateRow)row;
            if (treeObject == null || !treeObject.equals(predRow.getLhsTreeObject())) continue;
            ++count;
        }
        return count;
    }

    public void setOperatorVisible(boolean visible) {
        if (visible) {
            this.container.getCellFormatter().setStyleName(0, 0, BRACKET_STYLE);
        } else {
            this.container.getCellFormatter().removeStyleName(0, 0, BRACKET_STYLE);
        }
        this.label.setVisible(visible);
    }

    private Widget buildButtonPanel() {
        HorizontalPanel panel = new HorizontalPanel();
        panel.addStyleName("cms_button_container");
        panel.add((Widget)this.getAddCriterionButton());
        if (this.getLevel() < this.maxLevels) {
            panel.add((Widget)this.getAddComplexButton());
        }
        return panel;
    }

    private int getLevel() {
        int i = 1;
        for (PredicateRowBase node = this.parentList; node != null; node = node.getParentList()) {
            ++i;
        }
        return i;
    }

    private Button getAddComplexButton() {
        Button button = new Button("Add Group");
        button.setTitle(this.myConstants.addComplexCriterion());
        button.removeStyleName("gwt-Button");
        button.addStyleName("ebBtn");
        button.addStyleName("addgroup_button_icon");
        button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PredicateRow row1 = new PredicateRow(PredicateList.this.root);
                PredicateRow row2 = new PredicateRow(PredicateList.this.root);
                PredicateList list = new PredicateList(PredicateList.this);
                list.addChildRow(row1);
                list.addChildRow(row2);
                list.setOperator(PredicateList.this.getOperator().invert());
                PredicateList.this.addChildRow(list);
            }
        });
        return button;
    }

    private Button getAddCriterionButton() {
        Button button = new Button("Add Row");
        button.setTitle(this.myConstants.addCriterion());
        button.removeStyleName("gwt-Button");
        button.addStyleName("ebBtn");
        button.addStyleName("addrow_button_icon");
        button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PredicateList.this.addChildRow(new PredicateRow(PredicateList.this.root));
            }
        });
        return button;
    }

    public void reroot(PredicateList newRoot) {
        this.setOperator(newRoot.getOperator());
        this.setChildrenPanel(newRoot.getChildrenPanel());
        VerticalPanel rightSide = new VerticalPanel();
        rightSide.add((Widget)this.getChildrenPanel());
        rightSide.add(this.buildButtonPanel());
        this.container.setWidget(0, 1, (Widget)rightSide);
        for (Widget w : this.getChildrenPanel()) {
            ((PredicateRowBase)w).setParentList(this);
        }
    }

    @Override
    public void removeItem(PredicateRowBase item) {
        super.removeItem(item);
        if (this.parentList == null && this.getChildrenPanel().getWidgetCount() == 1 && this.getChildrenPanel().getWidget(0) instanceof PredicateList) {
            this.reroot((PredicateList)this.getChildrenPanel().getWidget(0));
        }
        if (this.getChildrenPanel().getWidgetCount() == 0 && this.parentList != null) {
            this.parentList.removeItem(this);
        } else if (this.getChildrenPanel().getWidgetCount() == 0) {
            PredicateRow pr = new PredicateRow(this.root);
            this.addChildRow(pr);
        }
    }

    public void setMaxLevels(int maxLevels) {
        this.maxLevels = maxLevels;
    }

    public int getMaxLevels() {
        return this.maxLevels;
    }
}

