/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.client.criteria;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.TitleConstants;
import com.tandbergtv.cms.portal.ui.title.client.TitleMessages;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaListingPanel;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldSelector;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldSelectorHandler;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.AssetTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.PMMTitleTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UIDataType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTreeCreator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.PredicateRowBase;
import com.tandbergtv.cms.portal.ui.title.client.criteria.RightFieldSelectionHandler;
import com.tandbergtv.cms.portal.ui.title.client.criteria.TreeCreator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.RHSValueWidget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.RHSWidgetFactory;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.SimpleRHSValueWidget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.ValueTextBox;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.StringValidator;
import com.tandbergtv.cms.portal.ui.title.client.model.search.BaseOperator;
import com.tandbergtv.cms.portal.ui.title.client.model.search.RhsType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.RulesOperatorFull;
import com.tandbergtv.cms.portal.ui.title.client.model.search.RulesOperatorLimited;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIParamType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterConditionNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterRHSFieldNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterValueNode;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ToggleButtonWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PredicateRow
extends PredicateRowBase {
    private TitleMessages myMessages = (TitleMessages)GWT.create(TitleMessages.class);
    private static final TitleConstants myConstants = (TitleConstants)GWT.create(TitleConstants.class);
    private static final String PREDICATE_LABEL_STYLE = "predicate-label";
    private static int switchRhsCounter = 0;
    private BaseOperator operatorProvider;
    private ListBoxWidget<BaseOperator> operatorList;
    private TextBox lhsFldTxtBox;
    private TextBox rhsFldTxtBox;
    private RHSValueWidget dataValue;
    private SimplePanel rhsValuePanel = new SimplePanel();
    private FieldSelector lhsFieldSelector;
    private FieldSelector rhsFieldSelector;
    private VerticalPanel switchRhs = new VerticalPanel();
    private RadioButton rhsField = new RadioButton("switchRhs" + switchRhsCounter, myConstants.field());
    private RadioButton rhsValue = new RadioButton("switchRhs" + switchRhsCounter, myConstants.value());
    private IFieldTreeObject treeObject;
    private IFieldTreeObject evalChild;
    private CheckBox notChkBox;
    private Button addRow;
    private IFieldTreeObject treeObjectRhs;
    private ToggleButtonWidget tg;
    private static String DELETE_GROUP_BUTTON_STYLE = "delete-group-button";

    public PredicateRow(CriteriaListingPanel parentContainer) {
        super(parentContainer);
        this.setOperatorProvider(parentContainer.getOperatorProvider());
        this.putUiTogther();
        ++switchRhsCounter;
        this.addHandlers();
    }

    public PredicateRow(CriteriaListingPanel parentContainer, UITitleFilterConditionNode predicateNode) {
        super(parentContainer);
        this.setOperatorProvider(parentContainer.getOperatorProvider());
        this.putUiTogther();
        ++switchRhsCounter;
        this.setPredicate(predicateNode);
        this.addHandlers();
    }

    public PredicateRow(CriteriaListingPanel parentContainer, IFieldTreeObject treeObj) {
        this(parentContainer);
        this.evalChild = treeObj instanceof AssetTreeObject && treeObj.getChildren().size() > 0 ? ((AssetTreeObject)treeObj).cloneWithoutChildAsset() : treeObj;
        this.setOperatorProvider(new RulesOperatorLimited());
        this.addHandlers();
    }

    public PredicateRow(CriteriaListingPanel parentContainer, IFieldTreeObject treeObj, UITitleFilterConditionNode predicateNode) {
        this(parentContainer);
        this.evalChild = treeObj instanceof AssetTreeObject && treeObj.getChildren().size() > 0 ? ((AssetTreeObject)treeObj).cloneWithoutChildAsset() : treeObj;
        this.setOperatorProvider(new RulesOperatorLimited());
        this.setPredicate(predicateNode);
        this.addHandlers();
    }

    private void addHandlers() {
        this.lhsFldTxtBox.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (PredicateRow.this.canChangePredicateRow()) {
                    PredicateRow.this.showLhsFieldSelector();
                }
            }
        });
        this.rhsFldTxtBox.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PredicateRow.this.showRhsFieldSelector();
            }
        });
        this.rhsField.addClickHandler((ClickHandler)new RhsSwitchHandler());
        this.rhsValue.addClickHandler((ClickHandler)new RhsSwitchHandler());
    }

    private void filterOperatorList(IFieldTreeObject obj) {
        BaseOperator selectedItem = (BaseOperator)this.operatorList.getSelectedItem();
        boolean newListContainsSI = false;
        this.operatorList.clear();
        BaseOperator sop = this.getOperatorProvider();
        List<BaseOperator> operators = sop.getOperators(obj);
        for (BaseOperator operator : operators) {
            String strItem = operator.toString();
            this.operatorList.addItem(myConstants.getString(strItem), (Object)operator);
            if (selectedItem == null || !operator.equals(selectedItem)) continue;
            newListContainsSI = true;
        }
        if (newListContainsSI) {
            this.operatorList.setSelectedItem((Object)selectedItem);
        }
        this.resetDataValue(this.dataValue.getValues());
    }

    public void putUiTogther() {
        this.lhsFldTxtBox = new TextBox();
        this.rhsFldTxtBox = new TextBox();
        this.dataValue = new SimpleRHSValueWidget(new ValueTextBox(new StringValidator()));
        this.rhsValuePanel.setWidget((Widget)this.dataValue);
        this.operatorList = PredicateRow.createOperatorList();
        this.operatorList.addChangeHandler((ChangeHandler)new OperatorListChangeHandler());
        this.notChkBox = new CheckBox();
        this.notChkBox.setText(myConstants.not());
        this.notChkBox.addStyleName("small-txt");
        this.tg = new ToggleButtonWidget("Is", "Not");
        this.tg.addStyleDependentName("SearchToggle");
        this.tg.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (PredicateRow.this.notChkBox.isChecked()) {
                    PredicateRow.this.notChkBox.setChecked(false);
                    PredicateRow.this.tg.setDown(false);
                } else {
                    PredicateRow.this.notChkBox.setChecked(true);
                    PredicateRow.this.tg.setDown(true);
                }
            }
        });
        Button btnDelete = this.createRemoveButton();
        this.lhsFldTxtBox.setReadOnly(true);
        this.lhsFldTxtBox.addStyleName("black-txt");
        this.lhsFldTxtBox.addStyleName("small-txt");
        this.lhsFldTxtBox.setVisibleLength(35);
        this.rhsFldTxtBox.setReadOnly(true);
        this.rhsFldTxtBox.addStyleName("black-txt");
        this.rhsFldTxtBox.addStyleName("small-txt");
        this.rhsFldTxtBox.setVisibleLength(35);
        HorizontalPanel horPanel = new HorizontalPanel();
        horPanel.setSpacing(3);
        SimplePanel chkBoxContainer = new SimplePanel();
        chkBoxContainer.setWidget((Widget)this.notChkBox);
        chkBoxContainer.setWidget((Widget)this.tg);
        chkBoxContainer.addStyleName(PREDICATE_LABEL_STYLE);
        horPanel.add((Widget)chkBoxContainer);
        horPanel.setCellVerticalAlignment((Widget)chkBoxContainer, ALIGN_TOP);
        horPanel.add((Widget)this.lhsFldTxtBox);
        horPanel.setCellVerticalAlignment((Widget)this.lhsFldTxtBox, ALIGN_TOP);
        horPanel.add(this.operatorList);
        horPanel.setCellVerticalAlignment(this.operatorList, ALIGN_TOP);
        horPanel.add((Widget)this.switchRhs);
        horPanel.add((Widget)this.rhsValuePanel);
        horPanel.setCellVerticalAlignment((Widget)this.rhsValuePanel, ALIGN_TOP);
        horPanel.add((Widget)btnDelete);
        horPanel.setCellVerticalAlignment((Widget)btnDelete, ALIGN_TOP);
        this.treeObject = null;
        this.add((Widget)horPanel);
        this.add((Widget)this.createContainer());
    }

    private void showLhsFieldSelector() {
        int x = this.lhsFldTxtBox.getAbsoluteLeft();
        int y = this.lhsFldTxtBox.getAbsoluteTop();
        if (this.lhsFieldSelector == null && this.evalChild != null) {
            TreeItem childTree = TreeCreator.convertToTreeItem(this.evalChild, this.root.getLhsCriteriaType(), this.root.getCriteriaMode());
            this.lhsFieldSelector = FieldSelector.getSubTree(childTree);
        } else if (this.lhsFieldSelector == null) {
            this.lhsFieldSelector = FieldSelector.getTree(this.root.getLhsCriteriaType(), this.root.getCriteriaMode());
        }
        this.lhsFieldSelector.show(x, y, this.treeObject, this.getLhsSelectHandler());
    }

    private void showRhsFieldSelector() {
        int x = this.rhsFldTxtBox.getAbsoluteLeft();
        int y = this.rhsFldTxtBox.getAbsoluteTop();
        if (this.rhsFieldSelector == null) {
            this.rhsFieldSelector = FieldSelector.getTypedTree(this.root.getRhsCriteriaType(), this.root.getCriteriaMode(), this.treeObject.getDataType());
        }
        this.rhsFieldSelector.show(x, y, this.treeObjectRhs, this.getRhsSelectHandler());
    }

    private void resetDataValue(List<String> values) {
        if (this.treeObject == null) {
            return;
        }
        BaseOperator operator = (BaseOperator)this.operatorList.getSelectedItem();
        if (operator.allowRhsField() && this.operatorProvider instanceof RulesOperatorLimited) {
            this.switchRhs.add((Widget)this.rhsField);
            this.switchRhs.add((Widget)this.rhsValue);
            this.rhsValue.setValue(Boolean.valueOf(true));
        } else {
            this.switchRhs.clear();
        }
        this.dataValue = RHSWidgetFactory.getRHSWidgets(this.treeObject, operator, values);
        this.rhsValuePanel.setWidget((Widget)this.dataValue);
    }

    protected void setAddRowButtonVisible(boolean visible) {
        this.addRow.setVisible(visible);
    }

    public FieldSelectorHandler getLhsSelectHandler() {
        return new FieldSelectorHandler(){

            @Override
            public void onSelection(TreeItem item) {
                PredicateRow.this.updateFieldLhs(item);
            }

            @Override
            public boolean isSelectable(TreeItem item) {
                return ((IFieldTreeObject)item.getUserObject()).supportsCriteriaType(PredicateRow.this.root.getLhsCriteriaType(), PredicateRow.this.root.getCriteriaMode());
            }
        };
    }

    public FieldSelectorHandler getRhsSelectHandler() {
        RightFieldSelectionHandler handler = new RightFieldSelectionHandler(this);
        return handler;
    }

    private void setPredicate(UITitleFilterConditionNode predicateNode) {
        String sectionType = predicateNode.getSectionType();
        String xpath = predicateNode.getField();
        UIFieldType fieldType = predicateNode.getFieldType();
        boolean isNot = predicateNode.isNot();
        if (predicateNode.getFieldLhsDisplayName() == null || predicateNode.getFieldLhsDisplayName().isEmpty()) {
            this.root.addWarningMessage(this.myMessages.invalidField(xpath + " " + xpath));
            return;
        }
        IFieldTreeObject obj = FieldTreeCreator.getFieldTreeObject(fieldType, sectionType, xpath, predicateNode.getFieldLhsDisplayName(), predicateNode.getDataType(), predicateNode.getComplexType(), predicateNode.getExtendedDisplayNameLhs());
        this.setLhsField(obj);
        this.filterOperatorList(obj);
        this.setOperatorList(predicateNode.getSearchOperator());
        this.treeObject = obj;
        if (predicateNode.getRhsType().equals((Object)RhsType.FIELD)) {
            UITitleFilterRHSFieldNode rhsPred = (UITitleFilterRHSFieldNode)predicateNode;
            this.rhsValuePanel.setWidget((Widget)this.rhsFldTxtBox);
            String xpathRhs = rhsPred.getFieldRhs();
            String sectionTypeRhs = rhsPred.getSectionTypeRhs();
            String displayNameRhs = rhsPred.getFieldRhsDisplayName();
            UIFieldType fieldTypeRhs = rhsPred.getFieldTypeRhs();
            if (displayNameRhs == null || displayNameRhs.isEmpty()) {
                this.root.addWarningMessage(this.myMessages.invalidField(sectionTypeRhs + " " + xpathRhs));
                return;
            }
            this.treeObjectRhs = FieldTreeCreator.getFieldTreeObject(fieldTypeRhs, sectionTypeRhs, xpathRhs, displayNameRhs, predicateNode.getDataType(), predicateNode.getComplexType(), rhsPred.getExtendedDisplayNameRhs());
            this.switchRhs.add((Widget)this.rhsField);
            this.switchRhs.add((Widget)this.rhsValue);
            this.rhsField.setValue(Boolean.valueOf(true));
            this.setRhsField(this.treeObjectRhs);
        } else if (predicateNode.getRhsType().equals((Object)RhsType.VALUE)) {
            List<String> origValue = ((UITitleFilterValueNode)predicateNode).getValues();
            this.resetDataValue(origValue);
            List<String> value = this.getValue();
            if (!(origValue == null || origValue.isEmpty() || origValue.get(0) == null || origValue.get(0).isEmpty() || value.size() != 0 && !value.get(0).isEmpty())) {
                this.root.addWarningMessage(this.myMessages.invalidValue(origValue.get(0), sectionType + " " + xpath));
            }
        } else {
            this.resetDataValue(new ArrayList<String>(0));
        }
        this.notChkBox.setValue(Boolean.valueOf(isNot));
        if (isNot) {
            this.tg.setDown(true);
        } else {
            this.tg.setDown(false);
        }
        if (!this.isEvalChild()) {
            this.root.notifyChange(obj);
        }
    }

    private static ListBoxWidget<BaseOperator> createOperatorList() {
        ListBoxWidget list = new ListBoxWidget();
        list.addStyleName("condition-list");
        Collection<BaseOperator> operators = BaseOperator.values();
        for (BaseOperator oper : operators) {
            String strItem = oper.toString();
            list.addItem(myConstants.getString(strItem), (Object)oper);
        }
        return list;
    }

    public boolean isEvalChild() {
        return this.evalChild != null;
    }

    private void setOperatorList(BaseOperator operator) {
        this.operatorList.setSelectedItem((Object)operator);
        if (this.operatorList.getSelectedIndex() == -1) {
            this.root.addWarningMessage(this.myMessages.invalidOperator(operator.toString()));
        }
    }

    private Button createRemoveButton() {
        Button button = new Button();
        button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (PredicateRow.this.canChangePredicateRow()) {
                    PredicateRow.this.parentList.removeItem(PredicateRow.this);
                    PredicateRow.this.root.notifyRemoval(PredicateRow.this.treeObject);
                }
            }
        });
        button.setTitle(myConstants.removeCriteria());
        button.removeStyleName("gwt-Button");
        button.addStyleName("deletegroup_button_icon");
        return button;
    }

    private void setOperatorProvider(BaseOperator operatorProvider) {
        this.operatorProvider = operatorProvider;
    }

    private BaseOperator getOperatorProvider() {
        return this.operatorProvider;
    }

    public boolean canChangePredicateRow() {
        if (this.parentList instanceof PredicateRow) {
            return true;
        }
        boolean result = true;
        if (!this.root.canChangePredicateRow(this)) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean validate() {
        boolean result = super.validate();
        if (this.lhsFldTxtBox.getValue().equals("")) {
            this.lhsFldTxtBox.addStyleName("pinkbox");
            result = false;
        }
        if (this.rhsField.getValue().booleanValue() && this.rhsFldTxtBox.getValue().equals("")) {
            this.rhsFldTxtBox.addStyleName("pinkbox");
            result = false;
        } else if (!(this.rhsValue.isAttached() && !this.rhsValue.getValue().booleanValue() || this.dataValue.validate())) {
            result = false;
        }
        return result;
    }

    public UIParamType getParamType() {
        BaseOperator operator = (BaseOperator)this.operatorList.getSelectedItem();
        return operator.multiValued() ? UIParamType.LIST : UIParamType.VALUE;
    }

    public int getLevel() {
        int i = 0;
        for (PredicateRowBase node = this; node != null; node = node.getParentList()) {
            ++i;
        }
        return i - 1;
    }

    public void updateFieldLhs(TreeItem item) {
        if (item != null) {
            IFieldTreeObject oldObj = this.treeObject;
            IFieldTreeObject itemObj = (IFieldTreeObject)item.getUserObject();
            if (oldObj != null) {
                UIDataType newDT;
                UIDataType oldDT = oldObj.getDataType();
                if (!oldDT.equals((Object)(newDT = itemObj.getDataType()))) {
                    this.rhsFldTxtBox.setValue((Object)"");
                    this.treeObjectRhs = null;
                    this.rhsFieldSelector = null;
                }
                if (itemObj instanceof PMMTitleTreeObject && !oldObj.equals(itemObj)) {
                    this.dataValue = new SimpleRHSValueWidget(new ValueTextBox(new StringValidator()));
                }
            }
            if (!(oldObj == null || this.getChildCount() <= 0 || oldObj.getAssetType().equals(itemObj.getAssetType()) && oldObj.getField().equals(itemObj.getField()))) {
                this.clearChildPanel(false);
                this.setAddRowButtonVisible(false);
                this.getOperatorList().setSelectedIndex(0);
            }
            this.lhsFldTxtBox.removeStyleName("pinkbox");
            this.setLhsField(itemObj);
            this.setLhsTreeObject(itemObj);
            this.filterOperatorList(itemObj);
            IFieldTreeObject userObj = (IFieldTreeObject)item.getUserObject();
            if (!(this.isEvalChild() || oldObj != null && oldObj.equals(userObj))) {
                this.root.notifyChange(userObj);
                this.root.notifyRemoval(oldObj);
            }
        } else {
            this.lhsFldTxtBox.setText(null);
            this.lhsFldTxtBox.setTitle(null);
            this.lhsFldTxtBox.setTitle(null);
            this.treeObject = null;
        }
    }

    public void updateFieldRhs(TreeItem item) {
        if (item != null) {
            IFieldTreeObject itemObj = (IFieldTreeObject)item.getUserObject();
            this.lhsFldTxtBox.removeStyleName("pinkbox");
            this.setRhsField(itemObj);
            this.setRhsTreeObject(itemObj);
        }
    }

    public boolean hasContents() {
        return !this.lhsFldTxtBox.getValue().equals("");
    }

    public RHSValueWidget getDataValue() {
        return this.dataValue;
    }

    public ListBoxWidget<BaseOperator> getOperatorList() {
        return this.operatorList;
    }

    public RhsType getRhsType() {
        if (((BaseOperator)this.getOperatorList().getSelectedItem()).equals(BaseOperator.EVALCHILDFIELDS)) {
            return RhsType.COMPLEX;
        }
        if (this.rhsValue.getValue().booleanValue() || !this.rhsValue.isAttached()) {
            return RhsType.VALUE;
        }
        if (this.rhsField.getValue().booleanValue()) {
            return RhsType.FIELD;
        }
        return RhsType.VALUE;
    }

    public List<String> getValue() {
        return this.dataValue.getValues();
    }

    public void setLhsField(IFieldTreeObject treeObj) {
        this.lhsFldTxtBox.setText(treeObj.getFullDisplayName());
        this.lhsFldTxtBox.setTitle(treeObj.getExtendedDisplayName());
    }

    public String getLhsField() {
        return this.lhsFldTxtBox.getText();
    }

    public void setRhsField(IFieldTreeObject treeObj) {
        this.rhsFldTxtBox.setText(treeObj.getFullDisplayName());
        this.rhsFldTxtBox.setTitle(treeObj.getExtendedDisplayName());
    }

    public String getRhsField() {
        return this.rhsFldTxtBox.getText();
    }

    public IFieldTreeObject getLhsTreeObject() {
        return this.treeObject;
    }

    public void setLhsTreeObject(IFieldTreeObject xmlTreeObject) {
        this.treeObject = xmlTreeObject;
    }

    public void setRhsTreeObject(IFieldTreeObject xmlTreeObject) {
        this.treeObjectRhs = xmlTreeObject;
    }

    public IFieldTreeObject getRhsTreeObject() {
        return this.treeObjectRhs;
    }

    public void setNot(boolean not) {
        this.notChkBox.setValue(Boolean.valueOf(not));
    }

    public boolean isNot() {
        return this.notChkBox.getValue();
    }

    public boolean isEmptyRow() {
        if (this.getLhsTreeObject() != null) {
            return false;
        }
        return this.dataValue.getValues() != null && this.dataValue.getValues().isEmpty() || this.dataValue.getValues().size() == 1 && this.dataValue.getValues().get(0).isEmpty();
    }

    protected Widget buildButtonPanel() {
        HorizontalPanel panel = new HorizontalPanel();
        this.addRow = this.getAddCriterionButton();
        this.setAddRowButtonVisible(false);
        panel.add((Widget)this.addRow);
        return panel;
    }

    private FlexTable createContainer() {
        FlexTable tableContainer = new FlexTable();
        tableContainer.setWidget(0, 0, (Widget)new Label(""));
        tableContainer.getCellFormatter().setStyleName(0, 0, "eval-child-spacing");
        VerticalPanel rightSide = new VerticalPanel();
        rightSide.add((Widget)this.getChildrenPanel());
        rightSide.add(this.buildButtonPanel());
        tableContainer.setWidget(0, 1, (Widget)rightSide);
        return tableContainer;
    }

    @Override
    public void removeItem(PredicateRowBase item) {
        super.removeItem(item);
        if (this.getChildrenPanel().getWidgetCount() == 0) {
            PredicateRow row = this;
            IFieldTreeObject obj = row.getLhsTreeObject();
            this.addChildRow(new PredicateRow(this.root, obj));
        }
    }

    private Button getAddCriterionButton() {
        Button button = new Button("Add Row");
        button.setTitle(myConstants.addCriterion());
        button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PredicateRow row = PredicateRow.this;
                IFieldTreeObject obj = row.getLhsTreeObject();
                PredicateRow.this.addChildRow(new PredicateRow(PredicateRow.this.root, obj));
            }
        });
        return button;
    }

    private class RhsSwitchHandler
    implements ClickHandler {
        private RhsSwitchHandler() {
        }

        public void onClick(ClickEvent event) {
            if (PredicateRow.this.rhsField.getValue().booleanValue()) {
                PredicateRow.this.rhsValuePanel.setWidget((Widget)PredicateRow.this.rhsFldTxtBox);
            } else {
                PredicateRow.this.rhsValuePanel.setWidget((Widget)PredicateRow.this.dataValue);
            }
        }
    }

    private class OperatorListChangeHandler
    implements ChangeHandler {
        private OperatorListChangeHandler() {
        }

        public void onChange(ChangeEvent event) {
            if (PredicateRow.this.operatorList.getSelectedItem() == RulesOperatorFull.EVALCHILDFIELDS) {
                if (PredicateRow.this.treeObject.getSimpleDisplayName() == null || PredicateRow.this.treeObject.getSimpleDisplayName().isEmpty()) {
                    String asset = PredicateRow.this.treeObject.getAssetType();
                    String xpath = PredicateRow.this.treeObject.getField();
                    PredicateRow.this.root.addWarningMessage(PredicateRow.this.myMessages.invalidField(asset + " " + xpath));
                    return;
                }
                PredicateRow pred = new PredicateRow(PredicateRow.this.root, PredicateRow.this.treeObject);
                PredicateRow.this.addChildRow(pred);
                PredicateRow.this.setAddRowButtonVisible(true);
            } else {
                PredicateRow.this.clearChildPanel(false);
                PredicateRow.this.setAddRowButtonVisible(false);
            }
            PredicateRow.this.resetDataValue(PredicateRow.this.dataValue.getValues());
        }
    }
}

