/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.client.criteria;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.ItemSelectableHandler;

public class TreeSearcher
extends HorizontalPanel
implements HasSelectionHandlers<TreeItem> {
    private TextBox txtBox = null;
    private Tree tree = null;
    private String lastSearch = "";
    private boolean lastSearchResultedInMatch = true;
    private Integer hitNumber = 0;
    private ItemSelectableHandler selectableChecker;

    public TreeSearcher(Tree tree, SelectionHandler<TreeItem> handler, ItemSelectableHandler selectableChecker) {
        this.selectableChecker = selectableChecker;
        this.tree = tree;
        this.txtBox = new TextBox();
        this.addSelectionHandler(handler);
        this.txtBox.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                String txt = TreeSearcher.this.txtBox.getText();
                if (!(txt.isEmpty() || TreeSearcher.this.lastSearch == txt && event.getNativeKeyCode() != 13 || event.getNativeKeyCode() == 8 || txt.startsWith(TreeSearcher.this.lastSearch) && !TreeSearcher.this.lastSearchResultedInMatch)) {
                    TreeSearcher.this.findItem(txt, event.getNativeKeyCode() == 13);
                }
                TreeSearcher.this.setFocus();
            }
        });
        this.txtBox.setWidth("95%");
        this.add((Widget)this.txtBox);
        this.setWidth("100%");
    }

    public void setFocus() {
        this.txtBox.setFocus(true);
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                TreeSearcher.this.txtBox.setFocus(true);
            }
        });
    }

    protected void collapseAll() {
        for (int i = 0; i < this.tree.getItemCount(); ++i) {
            TreeItem item = this.tree.getItem(i);
            if (!item.getState() || this.collapseHelper(item)) continue;
            item.setState(false, false);
        }
    }

    private boolean collapseHelper(TreeItem parent) {
        boolean result = false;
        for (int i = 0; i < parent.getChildCount(); ++i) {
            TreeItem item = parent.getChild(i);
            boolean childResult = this.collapseHelper(item);
            if (item.getState() && !childResult) {
                item.setState(false, false);
                continue;
            }
            if (!childResult && !item.isSelected()) continue;
            result = true;
        }
        return result;
    }

    public void reset() {
        this.txtBox.setText("");
        this.lastSearch = "";
        this.lastSearchResultedInMatch = true;
        this.hitNumber = 0;
    }

    public void findItem(String search, boolean next) {
        if (!next) {
            this.hitNumber = 0;
        }
        boolean foundItem = false;
        MutableInteger searchHit = new MutableInteger(0);
        for (int i = 0; i < this.tree.getItemCount(); ++i) {
            TreeItem item = this.tree.getItem(i);
            if (!this.searchHelper(item, searchHit, search)) continue;
            foundItem = true;
            break;
        }
        this.lastSearch = search;
        this.lastSearchResultedInMatch = foundItem;
    }

    private boolean findItemInTree(TreeItem parent, MutableInteger searchHit, String search) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            TreeItem item = parent.getChild(i);
            if (!this.searchHelper(item, searchHit, search)) continue;
            return true;
        }
        return false;
    }

    private boolean searchHelper(TreeItem item, MutableInteger searchHit, String search) {
        if (item.getText().toUpperCase().startsWith(search.toUpperCase()) && (this.selectableChecker == null || this.selectableChecker.isSelectable(item))) {
            if (this.hitNumber == searchHit.value) {
                SelectionEvent.fire((HasSelectionHandlers)this, (Object)item);
                Integer n = this.hitNumber;
                Integer n2 = this.hitNumber = Integer.valueOf(this.hitNumber + 1);
                return true;
            }
            ++searchHit.value;
        }
        return this.findItemInTree(item, searchHit, search);
    }

    public HandlerRegistration addSelectionHandler(SelectionHandler<TreeItem> handler) {
        return this.addHandler((EventHandler)handler, SelectionEvent.getType());
    }

    private class MutableInteger {
        public int value;

        public MutableInteger(int value) {
            this.value = value;
        }
    }
}

