/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.client.criteria;

import com.google.gwt.user.client.ui.TreeItem;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.MatchedItemTreeObj;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.PMMFieldProvider;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.PMMTitleTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UIDataType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.TreeCreator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UndefinedFieldException;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import java.util.ArrayList;
import java.util.List;

public class TypedTreeCreator {
    public static List<TreeItem> getTreeItems(CriteriaType critType, UiCriteriaMode critMode, UIDataType dataType, boolean includeString) {
        TreeItem item;
        List<TreeItem> items = TypedTreeCreator.getMdmTreeItems(critType, critMode, dataType, includeString);
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_View"}) && (item = TypedTreeCreator.convertToTreeItem(TreeCreator.getContractData(), critType, critMode, dataType, includeString)) != null) {
            items.add(item);
        }
        items.addAll(TypedTreeCreator.getPMMTitleItems(critType, dataType, critMode));
        return items;
    }

    public static List<TreeItem> getTreeItems(CriteriaType critType, UiCriteriaMode critMode, String complexType) {
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        for (IFieldTreeObject treeObj : TreeCreator.getSpec()) {
            TreeItem item;
            if (!treeObj.childSupportsCriteriaType(critType, critMode) || (item = TypedTreeCreator.convertToTreeItem(treeObj, critType, critMode, complexType)) == null) continue;
            items.add(item);
        }
        return items;
    }

    private static List<TreeItem> getMdmTreeItems(CriteriaType critType, UiCriteriaMode critMode, UIDataType dataType, boolean includeString) {
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        for (IFieldTreeObject treeObj : TreeCreator.getSpec()) {
            TreeItem childItem;
            if (!treeObj.childSupportsCriteriaType(critType, critMode) || (childItem = TypedTreeCreator.convertToTreeItem(treeObj, critType, critMode, dataType, includeString)) == null) continue;
            items.add(childItem);
        }
        return items;
    }

    public static TreeItem convertToTreeItem(IFieldTreeObject treeObj, CriteriaType critType, UiCriteriaMode critMode, UIDataType baseDataType, boolean includeString) {
        TreeItem result;
        IFieldTreeObject rootMatched = null;
        if (treeObj instanceof MatchedItemTreeObj) {
            rootMatched = ((MatchedItemTreeObj)treeObj).getParent();
            treeObj = ((MatchedItemTreeObj)treeObj).getUserObject();
        }
        if (treeObj.getChildren() != null && treeObj.getChildren().size() == 0 && treeObj.getDataType().equals((Object)UIDataType.COMPLEX)) {
            try {
                treeObj = TreeCreator.findMdmObject(treeObj.getAssetType(), treeObj.getField(), critType);
            }
            catch (UndefinedFieldException e) {
                e.printStackTrace();
            }
        }
        if ((result = TypedTreeCreator.convertToTreeItemRec(treeObj, critType, critMode, baseDataType, includeString, rootMatched)).getChildCount() > 0 || TypedTreeCreator.validDataType(baseDataType, treeObj.getDataType(), includeString) && treeObj.supportsCriteriaType(critType, critMode)) {
            return result;
        }
        return null;
    }

    public static TreeItem convertToTreeItemRec(IFieldTreeObject treeObj, CriteriaType critType, UiCriteriaMode critMode, UIDataType baseDataType, boolean includeString, IFieldTreeObject rootMatched) {
        List<IFieldTreeObject> children = treeObj.getChildren();
        IFieldTreeObject usrObj = TypedTreeCreator.getUserObject(treeObj, rootMatched);
        TreeItem item = new TreeItem(usrObj.getSimpleDisplayName());
        item.setUserObject((Object)usrObj);
        if (children != null) {
            for (IFieldTreeObject child : children) {
                UIDataType fieldDataType = child.getDataType();
                TreeItem childItem = TypedTreeCreator.convertToTreeItemRec(child, critType, critMode, baseDataType, includeString, rootMatched);
                if (childItem.getChildCount() <= 0 && (!TypedTreeCreator.validDataType(baseDataType, fieldDataType, includeString) || !child.supportsCriteriaType(critType, critMode))) continue;
                item.addItem(childItem);
            }
        }
        return item;
    }

    public static TreeItem convertToTreeItem(IFieldTreeObject treeObj, CriteriaType critType, UiCriteriaMode critMode, String complexType) {
        TreeItem result;
        IFieldTreeObject rootMatched = null;
        if (treeObj instanceof MatchedItemTreeObj) {
            rootMatched = ((MatchedItemTreeObj)treeObj).getParent();
            treeObj = ((MatchedItemTreeObj)treeObj).getUserObject();
        }
        if (treeObj.getChildren() != null && treeObj.getChildren().size() == 0 && treeObj.getDataType().equals((Object)UIDataType.COMPLEX)) {
            try {
                treeObj = TreeCreator.findMdmObject(treeObj.getAssetType(), treeObj.getField(), critType);
            }
            catch (UndefinedFieldException e) {
                e.printStackTrace();
            }
        }
        if ((result = TypedTreeCreator.convertToTreeItemRec(treeObj, critType, critMode, complexType, rootMatched)).getChildCount() > 0 || result != null && complexType.equals(treeObj.getComplexType()) && treeObj.supportsCriteriaType(critType, critMode)) {
            return result;
        }
        return null;
    }

    public static TreeItem convertToTreeItemRec(IFieldTreeObject treeObj, CriteriaType critType, UiCriteriaMode critMode, String complexType, IFieldTreeObject rootMatched) {
        List<IFieldTreeObject> children = treeObj.getChildren();
        IFieldTreeObject usrObj = TypedTreeCreator.getUserObject(treeObj, rootMatched);
        TreeItem item = new TreeItem(usrObj.getSimpleDisplayName());
        item.setUserObject((Object)usrObj);
        if (children != null) {
            for (IFieldTreeObject child : children) {
                String fieldType = child.getComplexType();
                TreeItem childItem = TypedTreeCreator.convertToTreeItemRec(child, critType, critMode, complexType, rootMatched);
                if (childItem.getChildCount() <= 0 && (fieldType == null || !complexType.equals(fieldType) || !child.supportsCriteriaType(critType, critMode))) continue;
                item.addItem(childItem);
            }
        }
        return item;
    }

    private static IFieldTreeObject getUserObject(IFieldTreeObject treeObject, IFieldTreeObject rootMatched) {
        if (rootMatched != null) {
            return new MatchedItemTreeObj(treeObject, rootMatched);
        }
        return treeObject;
    }

    private static List<TreeItem> getPMMTitleItems(CriteriaType critType, UIDataType dataType, UiCriteriaMode critMode) {
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        for (PMMTitleTreeObject treeObj : PMMFieldProvider.getPMMTreeObjects(critMode)) {
            if (!treeObj.supportsCriteriaType(critType, UiCriteriaMode.EPISODE) || !treeObj.getDataType().equals((Object)dataType)) continue;
            TreeItem item = new TreeItem(treeObj.getSimpleDisplayName());
            item.setUserObject((Object)treeObj);
            items.add(item);
        }
        return items;
    }

    public static boolean validDataType(UIDataType baseDataType, UIDataType fieldDataType, boolean includeString) {
        if (fieldDataType == null) {
            return false;
        }
        if (includeString && fieldDataType.equals((Object)UIDataType.STRING)) {
            return true;
        }
        switch (baseDataType) {
            case STRING: {
                return fieldDataType.equals((Object)UIDataType.STRING);
            }
            case INTEGER: {
                return fieldDataType.equals((Object)UIDataType.INTEGER);
            }
            case FLOAT: {
                return fieldDataType.equals((Object)UIDataType.FLOAT);
            }
            case BOOLEAN: {
                return fieldDataType.equals((Object)UIDataType.BOOLEAN);
            }
            case DATE: {
                return fieldDataType.equals((Object)UIDataType.DATE);
            }
            case TIME: {
                return fieldDataType.equals((Object)UIDataType.TIME);
            }
            case TIMECODE: {
                return fieldDataType.equals((Object)UIDataType.TIMECODE);
            }
        }
        return false;
    }
}

