/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.client.criteria.data;

import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UIDataType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.EmptyRHS;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.RHSValueWidget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.RegexValueWidget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.SimpleRHSValueWidget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.SingleValueWidget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.ValueBooleanBox;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.ValueDateBox;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.ValueList;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.ValueTextBox;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.FloatValidator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.IRulesValidator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.LongValidator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.StringValidator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.TimeCodeValidator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.TimeValidator;
import com.tandbergtv.cms.portal.ui.title.client.model.search.BaseOperator;
import com.tandbergtv.cms.portal.ui.title.client.model.search.RulesOperatorLimited;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIParamType;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;
import java.util.Collection;
import java.util.List;

public class RHSWidgetFactory {
    public static RHSValueWidget getRHSWidgets(IFieldTreeObject treeObject, BaseOperator operator, List<String> values) {
        boolean listableDataType;
        UIDataType dataType = treeObject.getDataType();
        boolean bl = listableDataType = dataType.equals((Object)UIDataType.INTEGER) || dataType.equals((Object)UIDataType.FLOAT) || dataType.equals((Object)UIDataType.STRING) || dataType.equals((Object)UIDataType.TIMECODE);
        if (operator == null) {
            return RHSWidgetFactory.handleNullOperator(values);
        }
        if (operator.multiValued() && listableDataType) {
            return new ValueList(treeObject, operator, values);
        }
        String value = null;
        if (values != null && values.size() > 0) {
            value = values.get(0);
        }
        return new SimpleRHSValueWidget(RHSWidgetFactory.getRHSWidget(treeObject, operator, value));
    }

    private static RHSValueWidget handleNullOperator(List<String> values) {
        if (values.size() == 0) {
            return new SimpleRHSValueWidget(new ValueTextBox(new StringValidator()));
        }
        return new SimpleRHSValueWidget(new ValueTextBox(new StringValidator(), values.get(0)));
    }

    public static SingleValueWidget getRHSWidget(IFieldTreeObject treeObject, BaseOperator operator, String value) {
        UIDataType dataType = treeObject.getDataType();
        if (treeObject == null || operator == null) {
            return new ValueTextBox(new StringValidator());
        }
        boolean useOther = treeObject.supportsOther();
        Collection<UIValueOption> suggestedValues = null;
        if (operator.useSuggestedValues() && treeObject.supportsSuggestValues()) {
            suggestedValues = treeObject.getSuggestedValues();
        }
        if (operator.equals(BaseOperator.NUMINSTANCESEQUAL) || operator.equals(BaseOperator.NUMINSTANCESGREATERTHAN) || operator.equals(BaseOperator.NUMINSTANCESLESSTHAN)) {
            return RHSWidgetFactory.buildValTextBox(new LongValidator(0L, Integer.MAX_VALUE), value, suggestedValues, useOther);
        }
        if (operator.equals(BaseOperator.LENGTHEQUALS) || operator.equals(BaseOperator.LENGTHGREATERTHAN) || operator.equals(BaseOperator.LENGTHLESSTHAN) || operator.equals(BaseOperator.TOTALLENGTHEQUALS) || operator.equals(BaseOperator.TOTALLENGTHGREATERTHAN) || operator.equals(BaseOperator.TOTALLENGTHLESSTHAN)) {
            return RHSWidgetFactory.buildValTextBox(new LongValidator(0L, Integer.MAX_VALUE), value, suggestedValues, useOther);
        }
        if (operator.equals(BaseOperator.TIMEEQUALS) || operator.equals(BaseOperator.TIMEGREATERTHAN) || operator.equals(BaseOperator.TIMELESSTHAN)) {
            return RHSWidgetFactory.buildValTextBox(new TimeValidator(), value, suggestedValues, useOther);
        }
        if (operator.equals(BaseOperator.GREATERTHANTODAY) || operator.equals(BaseOperator.LESSTHANTODAY)) {
            return RHSWidgetFactory.buildValTextBox(new LongValidator(Integer.MIN_VALUE, Integer.MAX_VALUE), value, suggestedValues, useOther);
        }
        if (operator.getParamType().equals((Object)UIParamType.NONE)) {
            return new EmptyRHS();
        }
        if (operator.equals(RulesOperatorLimited.REGEX)) {
            return new RegexValueWidget(value);
        }
        switch (dataType) {
            case COMPLEX: {
                return new EmptyRHS();
            }
            case INTEGER: {
                return RHSWidgetFactory.buildValTextBox(new LongValidator(), value, suggestedValues, useOther);
            }
            case STRING: {
                return RHSWidgetFactory.buildValTextBox(new StringValidator(), value, suggestedValues, useOther);
            }
            case BOOLEAN: {
                return RHSWidgetFactory.BuildBooleanBox(value);
            }
            case FLOAT: {
                return RHSWidgetFactory.buildValTextBox(new FloatValidator(), value, suggestedValues, useOther);
            }
            case DATE: {
                return RHSWidgetFactory.buildDateBox(value);
            }
            case TIME: {
                return RHSWidgetFactory.buildValTextBox(new TimeValidator(), value, suggestedValues, useOther);
            }
            case TIMECODE: {
                return RHSWidgetFactory.buildValTextBox(new TimeCodeValidator(), value, suggestedValues, useOther);
            }
        }
        return new ValueTextBox(new StringValidator());
    }

    private static SingleValueWidget buildValTextBox(IRulesValidator validator, String value, Collection<UIValueOption> suggestedValues, boolean useOther) {
        if ((value == null || value.isEmpty()) && suggestedValues == null) {
            return new ValueTextBox(validator);
        }
        if (value == null || value.isEmpty()) {
            return new ValueTextBox(validator, suggestedValues, useOther);
        }
        if (suggestedValues == null) {
            return new ValueTextBox(validator, value);
        }
        return new ValueTextBox(validator, suggestedValues, useOther, value);
    }

    private static SingleValueWidget buildDateBox(String value) {
        if (value == null || value.isEmpty()) {
            return new ValueDateBox();
        }
        return new ValueDateBox(value);
    }

    private static SingleValueWidget BuildBooleanBox(String value) {
        if (value == null || value.isEmpty()) {
            return new ValueBooleanBox();
        }
        return new ValueBooleanBox(value);
    }
}

