/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.client.criteria.data;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.SingleValueWidget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.regex.RegexDoneEvent;
import com.tandbergtv.cms.portal.ui.title.client.criteria.regex.RegexDoneHandler;
import com.tandbergtv.cms.portal.ui.title.client.criteria.regex.RegexEditor;
import com.tandbergtv.cms.portal.ui.title.client.criteria.regex.UiRegexValidator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.regex.UiRegexValidatorAsync;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;

public class RegexValueWidget
extends SingleValueWidget {
    protected final UiRegexValidatorAsync regexService = (UiRegexValidatorAsync)GWT.create(UiRegexValidator.class);
    private TextBox value = new TextBox();
    private boolean isValidRegex = false;
    private RegexEditor editor = new RegexEditor();

    public RegexValueWidget(String regex) {
        this.value = new TextBox();
        this.value.addStyleName("small-txt");
        this.value.setVisibleLength(60);
        this.setValue(regex);
        this.editor.addRegexDoneHandler(new RegexDoneHandler(){

            @Override
            public void doneEditing(RegexDoneEvent event) {
                RegexValueWidget.this.value.setText(event.getValue());
                RegexValueWidget.this.value.removeStyleName("pinkbox");
                RegexValueWidget.this.isValidRegex = true;
            }
        });
        this.value.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                RegexValueWidget.this.editor.setRegex(RegexValueWidget.this.value.getValue());
                RegexValueWidget.this.editor.center();
            }
        });
        this.setWidget((Widget)this.value);
    }

    public void onUnload() {
        super.onUnload();
        this.editor.hide();
    }

    @Override
    public String getValue() {
        return this.value.getValue();
    }

    @Override
    public boolean validate() {
        boolean valid;
        boolean bl = valid = this.isValidRegex && !this.value.getValue().isEmpty();
        if (!valid) {
            this.value.addStyleName("pinkbox");
        }
        return valid;
    }

    @Override
    public void setValue(String regex) {
        if (regex != null && !regex.isEmpty()) {
            this.value.setValue((Object)regex);
            this.regexService.validateRegex(regex, (AsyncCallback<Boolean>)new NeptuneAsyncCallback<Boolean>(){

                public void onNeptuneFailure(Throwable caught) {
                    Window.alert((String)"Unexpected error while validating regular expression");
                }

                public void onNeptuneSuccess(Boolean result) {
                    if (result.booleanValue()) {
                        RegexValueWidget.this.isValidRegex = true;
                        RegexValueWidget.this.value.removeStyleName("pinkbox");
                    } else {
                        RegexValueWidget.this.isValidRegex = false;
                        RegexValueWidget.this.value.addStyleName("pinkbox");
                    }
                }
            });
        }
    }
}

