/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.client.criteria.data;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.datepicker.client.DateBox;
import com.tandbergtv.cms.portal.ui.title.client.TitleConstants;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.NoClickDateBox;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.SingleValueWidget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.events.RHSValueChangeEvent;
import java.util.Date;

public class ValueDateBox1
extends SingleValueWidget {
    private static final int VISIBLE_LENGTH = 12;
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private TitleConstants myConstants = (TitleConstants)GWT.create(TitleConstants.class);
    private DateTimeFormat dateFormater = DateTimeFormat.getFormat((String)"yyyy-MM-dd");

    public ValueDateBox1() {
        NoClickDateBox dateBox = new NoClickDateBox();
        dateBox.setTitle(this.myConstants.validDateTitle() + " " + this.dateFormater.getPattern());
        DateBox.DefaultFormat fmt = new DateBox.DefaultFormat(this.dateFormater);
        dateBox.getTextBox().setVisibleLength(12);
        dateBox.setFormat((DateBox.Format)fmt);
        dateBox.setTitle(this.myConstants.validDateTitle() + " " + this.dateFormater.getPattern());
        dateBox.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Date>(){

            public void onValueChange(ValueChangeEvent<Date> event) {
                ValueDateBox1.this.validate();
                RHSValueChangeEvent chngEvent = new RHSValueChangeEvent();
                ValueDateBox1.this.fireEvent(chngEvent);
            }
        });
        this.setWidget((Widget)dateBox);
    }

    public ValueDateBox1(String date) {
        this();
        if (!date.isEmpty()) {
            this.setValue(date);
        }
    }

    @Override
    public String getValue() {
        Date value = this.getDateBox().getValue();
        if (value == null) {
            return this.getDateBox().getTextBox().getValue();
        }
        return this.addTime(this.dateFormater.format(value));
    }

    @Override
    public boolean validate() {
        boolean valid;
        this.getDateBox().getTextBox().removeStyleName("pinkbox");
        boolean bl = valid = this.getDateBox().getValue() != null;
        if (!valid) {
            this.getDateBox().getTextBox().addStyleName("pinkbox");
        }
        return valid;
    }

    public NoClickDateBox getDateBox() {
        return (NoClickDateBox)this.getWidget();
    }

    @Override
    public void setValue(String value) {
        try {
            if (value.isEmpty()) {
                this.getDateBox().setValue(null);
                this.getDateBox().getTextBox().removeStyleName("pinkbox");
            } else {
                this.getDateBox().setValue(this.dateFormater.parse(this.stripTime(value)));
            }
        }
        catch (IllegalArgumentException e) {
            return;
        }
    }

    private String addTime(String date) {
        String suffix = "T00:00:00.000";
        return date + suffix;
    }

    private String stripTime(String date) {
        if (date.length() > 10) {
            return date.substring(0, 10);
        }
        return date;
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<Date> handler) {
        return this.getDateBox().addValueChangeHandler(handler);
    }
}

