/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.client.criteria.data;

import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.RHSValueWidget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.RHSWidgetFactory;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.SingleValueWidget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.ValueListRow;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.events.RHSValueChangeEvent;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.events.RHSValueChangeHandler;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.events.RHSValueDeleteEvent;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.events.RHSValueDeleteHandler;
import com.tandbergtv.cms.portal.ui.title.client.model.search.BaseOperator;
import java.util.ArrayList;
import java.util.List;

public class ValueList
extends RHSValueWidget {
    private List<ValueListRow> rows = new ArrayList<ValueListRow>();
    private HandlerRegistration currentHandler;
    private BaseOperator operator;
    private IFieldTreeObject treeObject;

    public ValueList(IFieldTreeObject treeObject, BaseOperator operator) {
        this.treeObject = treeObject;
        this.operator = operator;
        this.createEmptyList();
    }

    public ValueList(IFieldTreeObject treeObject, BaseOperator operator, List<String> values) {
        this.treeObject = treeObject;
        this.operator = operator;
        if (values == null || values.isEmpty()) {
            this.createEmptyList();
        } else {
            for (int i = 0; i < values.size(); ++i) {
                SingleValueWidget val = RHSWidgetFactory.getRHSWidget(treeObject, operator, values.get(i));
                boolean showX = i != 0;
                this.addRow(val, showX);
            }
            this.addEmptyRow();
        }
    }

    private void createEmptyList() {
        this.addRow(RHSWidgetFactory.getRHSWidget(this.treeObject, this.operator, ""), false);
        this.addEmptyRow();
    }

    private void setListener() {
        if (this.currentHandler != null) {
            this.currentHandler.removeHandler();
        }
        this.currentHandler = this.rows.get(this.rows.size() - 1).addValueChangeHandler(new RHSValueChangeHandler(){

            @Override
            public void onChange(RHSValueChangeEvent event) {
                ValueList.this.addEmptyRow();
                ValueList.this.setListener();
            }
        });
    }

    private void addEmptyRow() {
        this.addRow(RHSWidgetFactory.getRHSWidget(this.treeObject, this.operator, ""), false);
        if (this.rows.size() > 2) {
            this.rows.get(this.rows.size() - 2).setXVisible(true);
        }
        this.setListener();
    }

    private void addRow(SingleValueWidget value, boolean showX) {
        ValueListRow row = new ValueListRow(value, showX);
        this.rows.add(row);
        row.addDeleteHandler(new RHSValueDeleteHandler(){

            @Override
            public void onDelete(RHSValueDeleteEvent event) {
                ValueList.this.rows.remove((Object)event.getRow());
                ValueList.this.remove((Widget)event.getRow());
            }
        });
        this.add((Widget)row);
    }

    @Override
    public List<String> getValues() {
        ArrayList<String> results = new ArrayList<String>();
        for (int i = 0; i < this.rows.size() - 1; ++i) {
            ValueListRow row = this.rows.get(i);
            results.add(row.getValue().trim());
        }
        return results;
    }

    @Override
    public boolean validate() {
        boolean result = true;
        for (int i = 0; i < this.rows.size() - 1; ++i) {
            if (this.rows.get(i).getValueWidget().validate()) continue;
            result = false;
        }
        return result;
    }

    @Override
    public void setValues(String value) {
    }
}

