/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.client.criteria.data;

import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.SingleValueWidget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.events.RHSValueChangeEvent;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.IRulesValidator;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ComboBoxWidget;
import java.util.Collection;

public class ValueTextBox
extends SingleValueWidget {
    private static final String OTHER = "PARANOID_OTHER";
    private HorizontalPanel panel = new HorizontalPanel();
    private ComboBoxWidget<String> suggestedValues;
    private TextBox valueBox;
    private IRulesValidator validator;

    public ValueTextBox(IRulesValidator validator, Collection<UIValueOption> suggestedValues, boolean supportsOther) {
        this.validator = validator;
        this.buildSuggestedValues(suggestedValues, supportsOther);
        this.buildUI(supportsOther);
    }

    public ValueTextBox(IRulesValidator validator) {
        this.validator = validator;
        this.suggestedValues = null;
        this.buildUI(false);
    }

    public ValueTextBox(IRulesValidator validator, String value) {
        this(validator);
        this.setValue(value);
    }

    public ValueTextBox(IRulesValidator validator, Collection<UIValueOption> suggestedValues, boolean supportsOther, String value) {
        this(validator, suggestedValues, supportsOther);
        this.setValue(value);
    }

    private void buildSuggestedValues(Collection<UIValueOption> options, boolean supportsOther) {
        this.suggestedValues = new ComboBoxWidget();
        for (UIValueOption sg : options) {
            this.suggestedValues.addItem(supportsOther ? sg.getValue() : sg.getName(), (Object)sg.getValue());
        }
    }

    public void buildUI(boolean supportsOther) {
        this.valueBox = new TextBox();
        this.valueBox.setTitle(this.validator.getToolTip());
        this.valueBox.addStyleName("small-txt");
        this.valueBox.addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                ValueTextBox.this.fireEvent(new RHSValueChangeEvent());
            }
        });
        this.valueBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ValueTextBox.this.valueBox.setValue((Object)ValueTextBox.this.validator.normalize(ValueTextBox.this.valueBox.getValue()), false);
                ValueTextBox.this.validate();
                ValueTextBox.this.fireEvent(new RHSValueChangeEvent());
            }
        });
        if (this.suggestedValues != null) {
            this.panel.add(this.suggestedValues);
            this.suggestedValues.setStyleName("rhs-value-combobox");
            this.valueBox.setVisible(false);
            this.suggestedValues.setEditable(supportsOther);
            this.suggestedValues.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    ValueTextBox.this.clearErrorState();
                    ValueTextBox.this.fireEvent(new RHSValueChangeEvent());
                }
            });
            this.suggestedValues.addSelectionHandler((SelectionHandler)new SelectionHandler<String>(){

                public void onSelection(SelectionEvent<String> event) {
                    ValueTextBox.this.clearErrorState();
                    ValueTextBox.this.fireEvent(new RHSValueChangeEvent());
                    ValueTextBox.this.suggestedValues.getParent().fireEvent((GwtEvent)new RHSValueChangeEvent());
                }
            });
        }
        this.panel.add((Widget)this.valueBox);
        this.setWidget((Widget)this.panel);
    }

    private String getSuggestedValue() {
        int index = this.suggestedValues.getSelectedIndex();
        if (index == -1) {
            if (this.suggestedValues.getText() != null) {
                return this.suggestedValues.getText();
            }
            return "";
        }
        return (String)this.suggestedValues.getItem(index);
    }

    @Override
    public boolean validate() {
        boolean valid;
        this.clearErrorState();
        if (this.suggestedValues != null && !this.getSuggestedValue().equals(OTHER)) {
            boolean bl = valid = !this.getSuggestedValue().equals("");
            if (!valid) {
                this.suggestedValues.addStyleName("pinkbox");
                this.suggestedValues.setSelectedIndex(0);
            }
        } else {
            boolean bl = valid = !this.getValue().isEmpty() && this.validator.validate(this.valueBox.getValue());
            if (!valid) {
                this.valueBox.addStyleName("pinkbox");
            }
        }
        return valid;
    }

    private void clearErrorState() {
        this.valueBox.removeStyleName("pinkbox");
        if (this.suggestedValues != null) {
            this.suggestedValues.removeStyleName("pinkbox");
        }
    }

    @Override
    public void setValue(String value) {
        if (this.suggestedValues != null) {
            boolean found = false;
            int length = this.suggestedValues.getItemCount();
            for (int i = 0; !found && i < length; ++i) {
                if (!((String)this.suggestedValues.getItem(i)).equals(value)) continue;
                found = true;
                this.suggestedValues.setSelectedIndex(i);
            }
            if (!found) {
                this.suggestedValues.setText(value);
            }
        } else {
            this.valueBox.setValue((Object)this.validator.normalize(value), false);
            this.validate();
            this.valueBox.setVisible(true);
        }
    }

    @Override
    public String getValue() {
        if (this.suggestedValues != null && !this.getSuggestedValue().equals(OTHER)) {
            return this.getSuggestedValue();
        }
        return this.valueBox.getText();
    }

    @Override
    public HandlerRegistration addBlurHandler(BlurHandler handler) {
        return this.valueBox.addBlurHandler(handler);
    }
}

