/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate;

import com.google.gwt.core.client.GWT;
import com.tandbergtv.cms.portal.ui.title.client.TitleMessages;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.IRulesValidator;

public class LongValidator
implements IRulesValidator {
    private TitleMessages myMessages = (TitleMessages)GWT.create(TitleMessages.class);
    private static final String maxLongString = "9223372036854775807";
    private static final String minLongString = "-9223372036854775808".substring(1);
    private long minValue = Long.MIN_VALUE;
    private long maxValue = Long.MAX_VALUE;

    public LongValidator() {
    }

    public LongValidator(long minValue, long maxValue) {
        this.setMinValue(minValue);
        this.setMaxValue(maxValue);
    }

    @Override
    public String normalize(String value) {
        return value;
    }

    @Override
    public boolean validate(String str) {
        try {
            Long value = Long.parseLong(str);
            return this.checkLongBoundaries(str) && value <= this.maxValue && value >= this.minValue;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public void setMinValue(long minValue) {
        this.minValue = minValue;
    }

    public Long getMinValue() {
        return this.minValue;
    }

    public void setMaxValue(long maxValue) {
        this.maxValue = maxValue;
    }

    public Long getMaxValue() {
        return this.maxValue;
    }

    @Override
    public String getToolTip() {
        return this.myMessages.validLong(this.minValue + "", this.maxValue + "");
    }

    private boolean checkLongBoundaries(String str) {
        try {
            Long.parseLong(str);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        if (str.isEmpty()) {
            return true;
        }
        boolean isNegative = str.startsWith("-");
        String digits = isNegative ? str.substring(1) : str;
        if (digits.length() > maxLongString.length()) {
            return false;
        }
        if (!this.allDigit(digits)) {
            return false;
        }
        if (digits.length() == maxLongString.length()) {
            if (isNegative) {
                return digits.compareTo(minLongString) <= 0;
            }
            return digits.compareTo(maxLongString) <= 0;
        }
        return true;
    }

    private boolean allDigit(String str) {
        char[] chars;
        for (char c : chars = str.toCharArray()) {
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }
}

