/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.regexp.shared.RegExp;
import com.tandbergtv.cms.portal.ui.title.client.TitleConstants;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.IRulesValidator;

public class TimeCodeValidator
implements IRulesValidator {
    private TitleConstants myConstants = (TitleConstants)GWT.create(TitleConstants.class);
    private static final String SMPTERegex = "^(([0-1][0-9]|2[0-3])(:[0-5][0-9]){3})$|^(([Ee]|[Bb])([Oo][Ss]))$";
    private static final String NPTRegex = "^(([0]|([1-9]([0-9]?){9}))(\\.?([0-9]([0-9]?){2})))$|^(([Ee]|[Bb])([Oo][Ss]))$";
    private RegExp SMPTEExp = RegExp.compile((String)"^(([0-1][0-9]|2[0-3])(:[0-5][0-9]){3})$|^(([Ee]|[Bb])([Oo][Ss]))$");
    private RegExp NPTExp = RegExp.compile((String)"^(([0]|([1-9]([0-9]?){9}))(\\.?([0-9]([0-9]?){2})))$|^(([Ee]|[Bb])([Oo][Ss]))$");
    private static TimeCodeValidator instance;

    public static synchronized TimeCodeValidator getInstance() {
        if (instance == null) {
            instance = new TimeCodeValidator();
        }
        return instance;
    }

    public TimeCodeValidator() {
        instance = this;
    }

    @Override
    public String normalize(String value) {
        value = value.trim();
        String[] strValues = value.split(":");
        int[] intValues = new int[4];
        if (strValues.length != 4) {
            try {
                float floatValue = Float.parseFloat(value);
                NumberFormat floatFormat = NumberFormat.getFormat((String)"#0.000");
                return String.valueOf(floatFormat.format((double)floatValue));
            }
            catch (NumberFormatException e) {
                return value;
            }
        }
        for (int i = 0; i < strValues.length; ++i) {
            String val = strValues[i];
            try {
                intValues[i] = Integer.parseInt(val);
                continue;
            }
            catch (NumberFormatException x) {
                return value;
            }
        }
        if (intValues[0] > 23 || intValues[1] > 59 || intValues[2] > 59 || intValues[3] > 59) {
            return value;
        }
        return this.padWitZero(intValues[0]) + ":" + this.padWitZero(intValues[1]) + ":" + this.padWitZero(intValues[2]) + ":" + this.padWitZero(intValues[3]);
    }

    private String padWitZero(int num) {
        if (num > 9) {
            return "" + num;
        }
        return "0" + num;
    }

    @Override
    public boolean validate(String str) {
        return this.isNPTFormat(str) || this.isSMPTEFormat(str);
    }

    @Override
    public String getToolTip() {
        return this.myConstants.validTimeCodeTitle();
    }

    public boolean isNPTFormat(String str) {
        return this.NPTExp.test(str);
    }

    public boolean isSMPTEFormat(String str) {
        return this.SMPTEExp.test(str);
    }
}

