/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate;

import com.google.gwt.core.client.GWT;
import com.tandbergtv.cms.portal.ui.title.client.TitleConstants;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.IRulesValidator;

public class TimeValidator
implements IRulesValidator {
    private TitleConstants myConstants = (TitleConstants)GWT.create(TitleConstants.class);

    @Override
    public String normalize(String value) {
        int i;
        String[] strValues = value.split(":");
        int[] intValues = new int[3];
        if (strValues.length > 3) {
            return value;
        }
        for (i = 0; i < strValues.length; ++i) {
            String val = strValues[i];
            try {
                intValues[i] = Integer.parseInt(val);
                continue;
            }
            catch (NumberFormatException x) {
                return value;
            }
        }
        for (i = 2; i > 0; --i) {
            int n = i - 1;
            intValues[n] = intValues[n] + intValues[i] / 60;
            intValues[i] = intValues[i] % 60;
        }
        if (intValues[0] > 23 || intValues[1] > 59 || intValues[2] > 59) {
            return value;
        }
        return this.padWitZero(intValues[0]) + ":" + this.padWitZero(intValues[1]) + ":" + this.padWitZero(intValues[2]);
    }

    private String padWitZero(int num) {
        if (num > 9) {
            return "" + num;
        }
        return "0" + num;
    }

    @Override
    public boolean validate(String str) {
        String[] strValues = str.split(":");
        int[] intValues = new int[3];
        if (strValues.length > 3) {
            return false;
        }
        for (int i = 0; i < strValues.length; ++i) {
            String val = strValues[i];
            try {
                intValues[i] = Integer.parseInt(val);
                continue;
            }
            catch (NumberFormatException x) {
                return false;
            }
        }
        return intValues[0] <= 23 && intValues[1] <= 59 && intValues[2] <= 59;
    }

    @Override
    public String getToolTip() {
        return this.myConstants.validTimeTitle();
    }
}

