/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.client.criteria.regex;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DecoratedPopupPanel;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.regex.RegexDoneEvent;
import com.tandbergtv.cms.portal.ui.title.client.criteria.regex.RegexDoneHandler;
import com.tandbergtv.cms.portal.ui.title.client.criteria.regex.UiRegexValidationException;
import com.tandbergtv.cms.portal.ui.title.client.criteria.regex.UiRegexValidator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.regex.UiRegexValidatorAsync;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;

public class RegexEditor
extends DecoratedPopupPanel {
    protected final UiRegexValidatorAsync regexService = (UiRegexValidatorAsync)GWT.create(UiRegexValidator.class);
    private TextBox regexBox;
    private TextBox valueBox;
    private Label validLabel;
    private Label resultValue;

    public RegexEditor() {
        super(false, true);
        this.buildUi();
    }

    public RegexEditor(String regex) {
        this();
        this.setRegex(regex);
    }

    public void setRegex(String regex) {
        this.regexBox.setValue((Object)regex);
        this.validLabel.setText("");
        this.resultValue.setText("");
    }

    private void buildUi() {
        this.regexBox = new TextBox();
        this.regexBox.setWidth("550px");
        this.valueBox = new TextBox();
        this.valueBox.setWidth("550px");
        this.validLabel = new Label();
        this.resultValue = new Label();
        FlexTable container = new FlexTable();
        container.setWidget(0, 0, (Widget)new Label("Regular Expression"));
        container.setWidget(0, 1, (Widget)this.regexBox);
        container.setWidget(1, 0, (Widget)new Label("Sample Value"));
        container.setWidget(1, 1, (Widget)this.valueBox);
        container.setWidget(2, 0, (Widget)new Label("Validation check:"));
        container.setWidget(2, 1, (Widget)this.validLabel);
        container.setWidget(3, 0, (Widget)new Label("Result of regex:"));
        container.setWidget(3, 1, (Widget)this.resultValue);
        HorizontalPanel buttonPanel = new HorizontalPanel();
        buttonPanel.addStyleName("cms_button_container");
        Button proceed = new Button("Proceed");
        proceed.removeStyleName("gwt-Button");
        proceed.addStyleName("ebBtn");
        proceed.addClickHandler(this.getProceedClickHandler());
        Button tryRegex = new Button("Try It Out");
        tryRegex.removeStyleName("gwt-Button");
        tryRegex.addStyleName("ebBtn");
        tryRegex.addClickHandler(this.getCheckClickHandler());
        Button cancel = new Button("Cancel");
        cancel.removeStyleName("gwt-Button");
        cancel.addStyleName("ebBtn");
        cancel.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                RegexEditor.this.hide();
            }
        });
        buttonPanel.add((Widget)tryRegex);
        buttonPanel.add((Widget)proceed);
        buttonPanel.add((Widget)cancel);
        VerticalPanel verticalContainer = new VerticalPanel();
        verticalContainer.add((Widget)container);
        verticalContainer.add((Widget)buttonPanel);
        this.setWidget((Widget)verticalContainer);
    }

    private ClickHandler getProceedClickHandler() {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                RegexEditor.this.regexService.validateRegex(RegexEditor.this.regexBox.getValue(), (AsyncCallback<Boolean>)new NeptuneAsyncCallback<Boolean>(){

                    public void onNeptuneFailure(Throwable caught) {
                        Window.alert((String)"Unexpected error while validating regular expression");
                    }

                    public void onNeptuneSuccess(Boolean result) {
                        if (result.booleanValue()) {
                            RegexDoneEvent event = new RegexDoneEvent(RegexEditor.this.regexBox.getValue());
                            RegexEditor.this.fireEvent(event);
                            RegexEditor.this.hide();
                        } else {
                            RegexEditor.this.validLabel.setText("The regular expression is invalid.");
                            RegexEditor.this.validLabel.addStyleName("red-txt");
                            RegexEditor.this.resultValue.setText("");
                        }
                    }
                });
            }
        };
    }

    private ClickHandler getCheckClickHandler() {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                RegexEditor.this.regexService.tryRegex(RegexEditor.this.regexBox.getValue(), RegexEditor.this.valueBox.getValue(), (AsyncCallback<Boolean>)new NeptuneAsyncCallback<Boolean>(){

                    public void onNeptuneFailure(Throwable caught) {
                        if (caught instanceof UiRegexValidationException) {
                            RegexEditor.this.validLabel.setText("The regular expression is invalid.");
                            RegexEditor.this.validLabel.addStyleName("red-txt");
                        } else {
                            Window.alert((String)"Unexpected error while validating regular expression");
                        }
                    }

                    public void onNeptuneSuccess(Boolean result) {
                        RegexEditor.this.validLabel.setText("The regular expression is valid.");
                        RegexEditor.this.validLabel.removeStyleName("red-txt");
                        RegexEditor.this.resultValue.setText(result.toString());
                    }
                });
            }
        };
    }

    public HandlerRegistration addRegexDoneHandler(RegexDoneHandler handler) {
        return this.addHandler(handler, RegexDoneEvent.TYPE);
    }
}

