/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.client.model.search;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UIDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.SoArrayList;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIParamType;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class BaseOperator
implements IsSerializable {
    protected static HashMap<String, BaseOperator> valueLookup = new HashMap();
    public static final BaseOperator EQUAL = new BaseOperator("equal", UIParamType.VALUE, true, false, true);
    public static final BaseOperator LESSTHAN = new BaseOperator("lessThan", UIParamType.VALUE, true);
    public static final BaseOperator LESSTHANEQUAL = new BaseOperator("lessThanEqual", UIParamType.VALUE, true);
    public static final BaseOperator GREATERTHAN = new BaseOperator("greaterThan", UIParamType.VALUE, true);
    public static final BaseOperator GREATERTHANEQUAL = new BaseOperator("greaterThanEqual", UIParamType.VALUE, true);
    public static final BaseOperator IN = new BaseOperator("in", UIParamType.LIST, true, false, false);
    public static final BaseOperator ISEMPTY = new BaseOperator("isEmpty", UIParamType.NONE, false);
    public static final BaseOperator STARTSWITH = new BaseOperator("startsWith", UIParamType.VALUE, true);
    public static final BaseOperator ENDSWITH = new BaseOperator("endsWith", UIParamType.VALUE, true);
    public static final BaseOperator CONTAINS = new BaseOperator("contains", UIParamType.VALUE, true);
    public static final BaseOperator LISTCONTAINS = new BaseOperator("listContains", UIParamType.VALUE, false, true, true);
    public static final BaseOperator LENGTHEQUALS = new BaseOperator("lengthEquals", UIParamType.VALUE, false);
    public static final BaseOperator LENGTHLESSTHAN = new BaseOperator("lengthLessThan", UIParamType.VALUE, false);
    public static final BaseOperator LENGTHGREATERTHAN = new BaseOperator("lengthGreaterThan", UIParamType.VALUE, false);
    public static final BaseOperator LESSTHANTODAY = new BaseOperator("lessThanToday", UIParamType.VALUE, false);
    public static final BaseOperator EQUALTOTODAY = new BaseOperator("equalToToday", UIParamType.NONE, false);
    public static final BaseOperator GREATERTHANTODAY = new BaseOperator("greaterThanToday", UIParamType.VALUE, false);
    public static final BaseOperator REGEX = new BaseOperator("regex", UIParamType.VALUE, false);
    public static final BaseOperator ISVALIDTIMECODE = new BaseOperator("isValidTimeCode", UIParamType.NONE, false);
    public static final BaseOperator CONTAINSUNPARSABLE = new BaseOperator("containsUnparsable", UIParamType.NONE, false);
    public static final BaseOperator FIELDINVALID = new BaseOperator("fieldInvalid", UIParamType.NONE, false);
    public static final BaseOperator TIER1EQUALS = new BaseOperator("tier1Equals", UIParamType.VALUE, true);
    public static final BaseOperator TIER2EQUALS = new BaseOperator("tier2Equals", UIParamType.VALUE, true);
    public static final BaseOperator TIER3EQUALS = new BaseOperator("tier3Equals", UIParamType.VALUE, true);
    public static final BaseOperator TIER4EQUALS = new BaseOperator("tier4Equals", UIParamType.VALUE, true);
    public static final BaseOperator MISSINGCONTENT = new BaseOperator("missingContent", UIParamType.NONE, false);
    public static final BaseOperator EVALCHILDFIELDS = new BaseOperator("evalChildFields", UIParamType.COMPLEX, false);
    public static final BaseOperator NUMINSTANCESEQUAL = new BaseOperator("numInstancesEqual", UIParamType.VALUE, false, true, false);
    public static final BaseOperator NUMINSTANCESGREATERTHAN = new BaseOperator("numInstancesGreaterThan", UIParamType.VALUE, false, true, false);
    public static final BaseOperator NUMINSTANCESLESSTHAN = new BaseOperator("numInstancesLessThan", UIParamType.VALUE, false, true, false);
    public static final BaseOperator BETWEEN = new BaseOperator("between", UIParamType.RANGE, false);
    public static final BaseOperator TIMEEQUALS = new BaseOperator("timeEquals", UIParamType.VALUE, false);
    public static final BaseOperator TIMELESSTHAN = new BaseOperator("timeLessThan", UIParamType.VALUE, false);
    public static final BaseOperator TIMEGREATERTHAN = new BaseOperator("timeGreaterThan", UIParamType.VALUE, false);
    public static final BaseOperator TOTALLENGTHEQUALS = new BaseOperator("totalLengthEquals", UIParamType.VALUE, false, true, false);
    public static final BaseOperator TOTALLENGTHLESSTHAN = new BaseOperator("totalLengthLessThan", UIParamType.VALUE, false, true, false);
    public static final BaseOperator TOTALLENGTHGREATERTHAN = new BaseOperator("totalLengthGreaterThan", UIParamType.VALUE, false, true, false);
    public static final String CATEGORY_XPATH = "/Fields/Categories/Category/Text";
    private static final String RATING = "/Fields/Rating/RatingValues/RatingValue";
    private static final String RATING_VALUE = "/Fields/Rating/RatingValues/RatingValue/Value";
    private static final String RATING_SYSTEM = "/Fields/Rating/RatingValues/RatingValue/System";
    private static final String GENRE = "/Fields/Genres/Genre/Value";
    private static final String PRODUCT = "/Fields/ProductInfo/Name";
    private static final String STUDIO = "/Fields/CreationInfo/Studio";
    private static final String STUDIO_DISPLAY = "/Fields/CreationInfo/Studio/DisplayName";
    private static final String STUDIO_NAME = "/Fields/CreationInfo/Studio/Name";
    private static final String STUDIO_CODE = "/Fields/CreationInfo/Studio/Code";
    private String key;
    private UIParamType searchParamType;
    private boolean useSuggestedValues;
    private boolean multiFieldOperator;
    protected boolean allowRhsField;

    public BaseOperator() {
    }

    protected BaseOperator(String key, UIParamType paramType, boolean allowRhsField) {
        this(key, paramType, false, false, allowRhsField);
    }

    protected BaseOperator(String key, UIParamType paramType, boolean useSuggestedValues, boolean isMultiField, boolean allowRhsField) {
        this.key = key;
        this.searchParamType = paramType;
        this.useSuggestedValues = useSuggestedValues;
        this.multiFieldOperator = isMultiField;
        valueLookup.put(key.toUpperCase(), this);
        this.allowRhsField = allowRhsField;
    }

    public String toString() {
        return this.key;
    }

    public UIParamType getParamType() {
        return this.searchParamType;
    }

    public boolean hasRightSide() {
        return this.searchParamType == UIParamType.VALUE || this.searchParamType == UIParamType.LIST || this.searchParamType == UIParamType.RANGE;
    }

    public boolean allowRhsField() {
        return this.allowRhsField;
    }

    public static BaseOperator valueOf(String key) {
        return valueLookup.get(key);
    }

    public static Collection<BaseOperator> values() {
        return valueLookup.values();
    }

    public static BaseOperator lookup(String operator) {
        Collection<BaseOperator> values = BaseOperator.values();
        for (BaseOperator val : values) {
            if (!val.key.equalsIgnoreCase(operator)) continue;
            return val;
        }
        return null;
    }

    public boolean multiValued() {
        return this.searchParamType == UIParamType.LIST;
    }

    public List<BaseOperator> getOperators(IFieldTreeObject obj) {
        UIDataType dataType = obj.getDataType();
        switch (dataType) {
            case COMPLEX: {
                return this.complexDataType(obj);
            }
            case STRING: {
                return this.stringDataType(obj);
            }
            case INTEGER: {
                return this.integerDataType(obj);
            }
            case FLOAT: {
                return this.floatDataType(obj);
            }
            case DATE: {
                return this.dateDataType(obj);
            }
            case TIME: {
                return this.timeDataType(obj);
            }
            case BOOLEAN: {
                return this.booleanDataType(obj);
            }
            case TIMECODE: {
                return this.timecodeDataType(obj);
            }
        }
        return new SoArrayList(obj);
    }

    protected List<BaseOperator> timecodeDataType(IFieldTreeObject obj) {
        SoArrayList result = new SoArrayList(obj);
        result.add(EQUAL);
        result.add(LESSTHAN);
        result.add(LESSTHANEQUAL);
        result.add(GREATERTHAN);
        result.add(GREATERTHANEQUAL);
        result.add(IN);
        result.add(ISEMPTY);
        result.add(CONTAINSUNPARSABLE);
        return result;
    }

    protected List<BaseOperator> complexDataType(IFieldTreeObject obj) {
        SoArrayList result = new SoArrayList(obj);
        result.add(ISEMPTY);
        result.add(CONTAINSUNPARSABLE);
        return result;
    }

    protected List<BaseOperator> stringDataType(IFieldTreeObject obj) {
        SoArrayList result = new SoArrayList(obj);
        result.add(CONTAINS);
        result.add(LISTCONTAINS);
        result.add(EQUAL);
        result.add(IN);
        result.add(STARTSWITH);
        result.add(ENDSWITH);
        result.add(ISEMPTY);
        return result;
    }

    protected List<BaseOperator> integerDataType(IFieldTreeObject obj) {
        SoArrayList result = new SoArrayList(obj);
        result.add(EQUAL);
        result.add(LESSTHAN);
        result.add(LESSTHANEQUAL);
        result.add(GREATERTHAN);
        result.add(GREATERTHANEQUAL);
        result.add(IN);
        if (!obj.getField().equals("id")) {
            result.add(ISEMPTY);
            result.add(CONTAINSUNPARSABLE);
        }
        return result;
    }

    protected List<BaseOperator> floatDataType(IFieldTreeObject obj) {
        SoArrayList result = new SoArrayList(obj);
        result.add(EQUAL);
        result.add(LESSTHAN);
        result.add(LESSTHANEQUAL);
        result.add(GREATERTHAN);
        result.add(GREATERTHANEQUAL);
        result.add(IN);
        result.add(ISEMPTY);
        result.add(CONTAINSUNPARSABLE);
        return result;
    }

    protected List<BaseOperator> booleanDataType(IFieldTreeObject obj) {
        SoArrayList result = new SoArrayList(obj);
        result.add(EQUAL);
        result.add(ISEMPTY);
        result.add(CONTAINSUNPARSABLE);
        return result;
    }

    protected List<BaseOperator> dateDataType(IFieldTreeObject obj) {
        SoArrayList result = new SoArrayList(obj);
        result.add(EQUAL);
        result.add(LESSTHAN);
        result.add(LESSTHANEQUAL);
        result.add(LESSTHANTODAY);
        result.add(EQUALTOTODAY);
        result.add(GREATERTHAN);
        result.add(GREATERTHANEQUAL);
        result.add(GREATERTHANTODAY);
        result.add(ISEMPTY);
        result.add(CONTAINSUNPARSABLE);
        return result;
    }

    protected List<BaseOperator> timeDataType(IFieldTreeObject obj) {
        SoArrayList result = new SoArrayList(obj);
        result.add(EQUAL);
        result.add(LESSTHAN);
        result.add(LESSTHANEQUAL);
        result.add(GREATERTHAN);
        result.add(GREATERTHANEQUAL);
        result.add(ISEMPTY);
        result.add(CONTAINSUNPARSABLE);
        return result;
    }

    protected void addCategoryOperators(String xpath, List<BaseOperator> list) {
        if (xpath.equals(CATEGORY_XPATH)) {
            list.add(TIER1EQUALS);
            list.add(TIER2EQUALS);
            list.add(TIER3EQUALS);
            list.add(TIER4EQUALS);
        }
    }

    protected void addFieldInvalidOperator(String xpath, List<BaseOperator> list) {
        if (xpath.equals(CATEGORY_XPATH) || xpath.equals(RATING) || xpath.equals(RATING_VALUE) || xpath.equals(RATING_SYSTEM) || xpath.equals(GENRE) || xpath.equals(PRODUCT) || xpath.equals(STUDIO) || xpath.equals(STUDIO_DISPLAY) || xpath.equals(STUDIO_NAME) || xpath.equals(STUDIO_CODE)) {
            list.add(FIELDINVALID);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof BaseOperator) {
            return ((BaseOperator)o).key.equals(this.key);
        }
        return false;
    }

    public boolean useSuggestedValues() {
        return this.useSuggestedValues;
    }

    public boolean isMultiFieldOperator() {
        return this.multiFieldOperator;
    }
}

