/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.client.model.specification;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIGroupAssetDefinition;
import java.util.ArrayList;
import java.util.List;

public class UIAssetSpecification
implements IsSerializable {
    private String name;
    private String displayName;
    private List<UIAssetDefinition> definitions = new ArrayList<UIAssetDefinition>();
    private long contentClassId;
    private int contentClassTypeId;
    private String contentClassName;
    private long partnerId;
    private String providerId;

    public UIAssetSpecification() {
    }

    public UIAssetSpecification(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getContentClassName() {
        return this.contentClassName;
    }

    public void setContentClassName(String contentClassName) {
        this.contentClassName = contentClassName;
    }

    public long getContentClassId() {
        return this.contentClassId;
    }

    public void setContentClassId(long contentClassId) {
        this.contentClassId = contentClassId;
    }

    public long getPartnerId() {
        return this.partnerId;
    }

    public void setPartnerId(long partnerId) {
        this.partnerId = partnerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public int getContentClassTypeId() {
        return this.contentClassTypeId;
    }

    public void setContentClassTypeId(int contentClassTypeId) {
        this.contentClassTypeId = contentClassTypeId;
    }

    public List<UIAssetDefinition> getAssetDefinitions() {
        return this.definitions;
    }

    public void setAssetDefinitions(List<UIAssetDefinition> definitions) {
        this.definitions = definitions != null ? definitions : new ArrayList();
    }

    public UIAssetDefinition getAssetDefinition(String assetType) {
        UIAssetDefinition definition = null;
        for (UIAssetDefinition child : this.definitions) {
            if (!assetType.equals(child.getAssetType())) continue;
            definition = child;
            break;
        }
        return definition;
    }

    public void addAssetDefinition(UIAssetDefinition assetDefinition) {
        if (assetDefinition != null) {
            assetDefinition.setSpecification(this);
            this.definitions.add(assetDefinition);
        }
    }

    public UIAssetDefinition findFirstAssetDefinition(String assetType) {
        if (assetType == null) {
            return null;
        }
        for (UIAssetDefinition def : this.definitions) {
            UIGroupAssetDefinition groupDef;
            UIAssetDefinition childDef;
            if (assetType.equals(def.getAssetType())) {
                return def;
            }
            if (!(def instanceof UIGroupAssetDefinition) || (childDef = this.findFirstAssetDefinition(groupDef = (UIGroupAssetDefinition)def, assetType)) == null) continue;
            return childDef;
        }
        return null;
    }

    private UIAssetDefinition findFirstAssetDefinition(UIGroupAssetDefinition groupDef, String assetType) {
        if (groupDef == null || assetType == null) {
            return null;
        }
        List<UIAssetDefinition> defs = groupDef.getChildren();
        for (UIAssetDefinition def : defs) {
            UIGroupAssetDefinition childGroupDef;
            UIAssetDefinition childDef;
            if (assetType.equals(def.getAssetType())) {
                return def;
            }
            if (!(def instanceof UIGroupAssetDefinition) || (childDef = this.findFirstAssetDefinition(childGroupDef = (UIGroupAssetDefinition)def, assetType)) == null) continue;
            return childDef;
        }
        return null;
    }

    public UIAssetDefinition getFirstRootDefinition() {
        if (this.definitions != null && !this.definitions.isEmpty()) {
            return this.definitions.get(0);
        }
        return null;
    }
}

