/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.client.msooverrides;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.CellList;
import com.google.gwt.user.cellview.client.HasKeyboardPagingPolicy;
import com.google.gwt.user.cellview.client.HasKeyboardSelectionPolicy;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import com.google.gwt.view.client.SingleSelectionModel;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.MSOOverridesConstants;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.UIMSO;
import com.tandbergtv.cms.portal.ui.title.client.msooverrides.events.MSOSelectedEvent;
import java.util.List;

public class MSOsPanel
extends Composite {
    private static MyUiBinder uiBinder = (MyUiBinder)GWT.create(MyUiBinder.class);
    final ListDataProvider<UIMSO> dataProvider;
    @UiField
    ScrollPanel scrollPanel;
    @UiField(provided=true)
    CellList<UIMSO> msosList;
    private Long siteId;
    private HandlerManager eventBus;
    private MSOOverridesConstants constants = (MSOOverridesConstants)GWT.create(MSOOverridesConstants.class);

    public MSOsPanel() {
        ProvidesKey<UIMSO> keyProvider = new ProvidesKey<UIMSO>(){

            public Object getKey(UIMSO item) {
                return item == null ? null : item.getMsoId();
            }
        };
        this.msosList = new CellList((Cell)new UIMSOCell(), (ProvidesKey)keyProvider);
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.dataProvider = new ListDataProvider();
        this.dataProvider.addDataDisplay(this.msosList);
        SafeHtmlBuilder sb = new SafeHtmlBuilder();
        sb.appendEscaped(this.constants.noMSOs());
        this.msosList.setEmptyListMessage(sb.toSafeHtml());
        this.msosList.setPageSize(10000);
        this.msosList.setKeyboardPagingPolicy(HasKeyboardPagingPolicy.KeyboardPagingPolicy.INCREASE_RANGE);
        this.msosList.setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.BOUND_TO_SELECTION);
        final SingleSelectionModel selectionModel = new SingleSelectionModel((ProvidesKey)keyProvider);
        this.msosList.setSelectionModel((SelectionModel)selectionModel);
        selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                UIMSO selected = (UIMSO)selectionModel.getSelectedObject();
                if (selected != null && MSOsPanel.this.eventBus != null) {
                    MSOsPanel.this.eventBus.fireEvent((GwtEvent)new MSOSelectedEvent(selected));
                }
            }
        });
    }

    public SelectionModel<? super UIMSO> getSelectionModel() {
        return this.msosList.getSelectionModel();
    }

    public void setSelected(UIMSO uiMSO, boolean selected) {
        this.getSelectionModel().setSelected((Object)uiMSO, selected);
    }

    public void setMSOs(List<UIMSO> uiMSOs) {
        this.dataProvider.setList(uiMSOs);
        if (uiMSOs.size() > 0) {
            this.msosList.getSelectionModel().setSelected((Object)uiMSOs.get(0), true);
        }
    }

    public boolean isEmpty() {
        boolean isEmpty = false;
        isEmpty = this.msosList.getRowCount() == 0;
        return isEmpty;
    }

    public Long getSiteId() {
        return this.siteId;
    }

    public void setSiteId(Long siteId) {
        this.siteId = siteId;
    }

    public HandlerManager getEventBus() {
        return this.eventBus;
    }

    public void setEventBus(HandlerManager eventBus) {
        this.eventBus = eventBus;
    }

    public void updateSize(int offsetWidth, int offsetHeight) {
        int height = Window.getClientHeight() - offsetHeight - 40;
        this.scrollPanel.setHeight(height + "px");
    }

    private static class UIMSOCell
    extends AbstractCell<UIMSO> {
        private UIMSOCell() {
            super(new String[0]);
        }

        public void render(Cell.Context context, UIMSO uiMSO, SafeHtmlBuilder sb) {
            if (uiMSO != null) {
                sb.appendEscaped(uiMSO.getMsoName());
            }
        }
    }

    static interface MyUiBinder
    extends UiBinder<Widget, MSOsPanel> {
    }
}

