/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.client.service.specification;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecification;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecificationListItem;
import com.tandbergtv.cms.portal.ui.title.client.service.specification.IUISpecificationManager;
import com.tandbergtv.cms.portal.ui.title.client.service.specification.IUISpecificationManagerAsync;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UISpecificationClientManager
implements IUISpecificationManagerAsync {
    private static final UISpecificationClientManager manager = new UISpecificationClientManager();
    private final IUISpecificationManagerAsync service = (IUISpecificationManagerAsync)GWT.create(IUISpecificationManager.class);
    private final UISpecificationCacheService defaultCacheService = new UISpecificationCacheService(this.service);

    private UISpecificationClientManager() {
    }

    public static UISpecificationClientManager getInstance() {
        return manager;
    }

    @Override
    public void getUISpecification(AsyncCallback<UIAssetSpecification> callback) {
        this.defaultCacheService.getSpecification(callback);
    }

    @Override
    public void getAll(AsyncCallback<List<UIAssetSpecificationListItem>> callback) {
        this.service.getAll(callback);
    }

    @Override
    public void getDefaultListItem(AsyncCallback<UIAssetSpecificationListItem> callback) {
        this.service.getDefaultListItem(callback);
    }

    @Override
    public void getPreviewSpecs(AsyncCallback<List<UIAssetSpecificationListItem>> callback) {
        this.service.getPreviewSpecs(callback);
    }

    @Override
    public void getAllUISpecifications(AsyncCallback<Collection<UIAssetDefinition>> callback) {
        this.service.getAllUISpecifications(callback);
    }

    @Override
    public void getUIAssetSpecification(String type, AsyncCallback<UIAssetSpecification> callback) {
        this.service.getUIAssetSpecification(type, callback);
    }

    private static final class UISpecificationCacheService {
        private final IUISpecificationManagerAsync service;
        private final String name;
        private final List<AsyncCallback<UIAssetSpecification>> callbacks = new ArrayList<AsyncCallback<UIAssetSpecification>>();
        private boolean loading = false;
        private UIAssetSpecification specification = null;

        public UISpecificationCacheService(IUISpecificationManagerAsync service, String name) {
            this.service = service;
            this.name = name;
        }

        public UISpecificationCacheService(IUISpecificationManagerAsync service) {
            this.service = service;
            this.name = null;
        }

        public synchronized void getSpecification(AsyncCallback<UIAssetSpecification> callback) {
            if (this.loading) {
                this.callbacks.add(callback);
            } else if (this.specification != null) {
                callback.onSuccess((Object)this.specification);
            } else {
                this.loading = true;
                this.callbacks.add(callback);
                this.service.getUISpecification((AsyncCallback<UIAssetSpecification>)new NeptuneAsyncCallback<UIAssetSpecification>(){

                    public void onNeptuneSuccess(UIAssetSpecification result) {
                        this.handleGetSpecificationSuccess(result);
                    }

                    public void onNeptuneFailure(Throwable caught) {
                        this.handleGetSpecificationFailure(caught);
                    }
                });
            }
        }

        private synchronized void handleGetSpecificationSuccess(UIAssetSpecification result) {
            this.loading = false;
            this.specification = result;
            for (AsyncCallback<UIAssetSpecification> callback : this.callbacks) {
                try {
                    callback.onSuccess((Object)result);
                }
                catch (Exception exception) {}
            }
            this.callbacks.clear();
        }

        private synchronized void handleGetSpecificationFailure(Throwable error) {
            this.loading = false;
            for (AsyncCallback<UIAssetSpecification> callback : this.callbacks) {
                try {
                    callback.onFailure(error);
                }
                catch (Exception exception) {}
            }
            this.callbacks.clear();
        }
    }
}

