/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.client.view.bundle;

import com.google.gwt.core.client.GWT;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.Image;
import com.tandbergtv.cms.portal.ui.title.client.model.title.UIDistributionStatus;
import com.tandbergtv.cms.portal.ui.title.client.model.title.UIProcessingStatus;
import com.tandbergtv.cms.portal.ui.title.client.model.title.UITitleStatus;
import com.tandbergtv.cms.portal.ui.title.client.model.title.UITrackingStatus;
import com.tandbergtv.cms.portal.ui.title.client.view.bundle.ITitleClientBundle;
import com.tandbergtv.cms.portal.ui.title.client.view.bundle.TitleImageConstants;

public class TitleClientBundle {
    private ITitleClientBundle titleBundle = (ITitleClientBundle)GWT.create(ITitleClientBundle.class);
    private TitleImageConstants constants = (TitleImageConstants)GWT.create(TitleImageConstants.class);
    private static final String STATUS_PREFIX = "status";
    private static final String DISTRIBUTION_STATUS_PREFIX = "distributionStatus";
    private static final String PROCESSING_STATUS_PREFIX = "processingStatus";
    private static final String TRACKING_STATUS_PREFIX = "trackingStatus";
    private static final String OFFER_STATUS_PREFIX = "offerStatus";

    public void updateTitleStatusIcon(Image icon, UITitleStatus status, Boolean isOffer) {
        this.updateTitleStatusIcon(icon, status.toString(), isOffer);
    }

    public void updateTitleStatusIcon(Image icon, String status, Boolean isOffer) {
        if (isOffer.booleanValue()) {
            this.updateIcon(icon, OFFER_STATUS_PREFIX + status);
        } else {
            this.updateIcon(icon, STATUS_PREFIX + status);
        }
    }

    public String getStatusName(UITitleStatus status) {
        return this.getStatusName(status.toString());
    }

    public String getStatusName(String status) {
        return this.constants.getString(STATUS_PREFIX + status);
    }

    public void updateDistributionStatusIcon(Image icon, UIDistributionStatus status) {
        this.updateDistributionStatusIcon(icon, status.toString());
    }

    public void updateDistributionStatusIcon(Image icon, String status) {
        this.updateIcon(icon, DISTRIBUTION_STATUS_PREFIX + status);
    }

    public String getDistributionStatusName(UIDistributionStatus status) {
        return this.getDistributionStatusName(status.toString());
    }

    public String getDistributionStatusName(String status) {
        return this.constants.getString(DISTRIBUTION_STATUS_PREFIX + status);
    }

    public void updateProcessingStatusIcon(Image icon, UIProcessingStatus status) {
        this.updateProcessingStatusIcon(icon, status.toString());
    }

    public void updateProcessingStatusIcon(Image icon, String status) {
        this.updateIcon(icon, PROCESSING_STATUS_PREFIX + status);
    }

    public String getProcessingStatusName(UIProcessingStatus status) {
        return this.getProcessingStatusName(status.toString());
    }

    public String getProcessingStatusName(String status) {
        return this.constants.getString(PROCESSING_STATUS_PREFIX + status);
    }

    public void updateTrackingStatusIcon(Image icon, UITrackingStatus status) {
        this.updateTrackingStatusIcon(icon, status.toString());
    }

    public void updateTrackingStatusIcon(Image icon, String status) {
        this.updateIcon(icon, TRACKING_STATUS_PREFIX + status);
    }

    public String getTrackingStatusName(UITrackingStatus status) {
        return this.getTrackingStatusName(status.toString());
    }

    public String getTrackingStatusName(String status) {
        return this.constants.getString(TRACKING_STATUS_PREFIX + status);
    }

    public void updateIcon(Image icon, String methodName) {
        try {
            ImageResource resource = (ImageResource)this.titleBundle.getResource(methodName);
            String title = this.constants.getString(methodName);
            icon.setResource(resource);
            icon.setTitle(title);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getIconTitle(String methodName) {
        return this.constants.getString(methodName);
    }

    public ITitleClientBundle getTitleBundle() {
        return this.titleBundle;
    }

    public TitleImageConstants getConstants() {
        return this.constants;
    }
}

