/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory;

import com.google.gwt.core.client.GWT;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.DataTypeWidgetFactory;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.DataTypeWidgetMessages;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.DateWidgetConfiguration;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.StringWidgetConfiguration;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.TimeWidgetConfiguration;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.WidgetConfiguration;
import com.tandbergtv.cms.portal.ui.title.client.widget.TypedPositionFieldWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.DataTypeWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedComboBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedDateBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedTextAreaWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedTextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.BooleanConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.DateConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.FloatConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IDateConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IValueConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IntegerConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.StringConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.ValueFormatException;
import java.util.Set;

public class DefaultDataTypeWidgetFactory
extends DataTypeWidgetFactory {
    private DataTypeWidgetMessages messages = (DataTypeWidgetMessages)GWT.create(DataTypeWidgetMessages.class);
    private String inputDateFormat = "yyyy-MM-dd'T'HH:mm:ss";
    private String inputTimeFormat = "HH:mm:ss";
    private static final int COMBOBOX_WIDTH = 500;

    protected DataTypeWidgetMessages getMessages() {
        return this.messages;
    }

    @Override
    public DataTypeWidget<Boolean> createBooleanWidget(WidgetConfiguration configuration) {
        RestrictedBooleanConverter converter = new RestrictedBooleanConverter();
        TypedListBoxWidget widget = new TypedListBoxWidget((IValueConverter)converter);
        widget.addItem(this.messages.booleanWidgetUndefinedValue(), null);
        if (!configuration.hasOptions()) {
            widget.addItem(this.messages.booleanWidgetTrueValue(), (Object)new Boolean(true));
            widget.addItem(this.messages.booleanWidgetFalseValue(), (Object)new Boolean(false));
        } else {
            Set<String> excludedKeys = configuration.getExcludedOptionKeys();
            for (UIValueOption valueOption : configuration.getOptions()) {
                if (excludedKeys != null && excludedKeys.contains(valueOption.getName())) continue;
                widget.addItem(valueOption.getName(), (Object)Boolean.parseBoolean(valueOption.getValue()));
            }
        }
        if (!configuration.isReadOnly()) {
            widget.setToolTip(this.messages.booleanWidgetToolTip());
            widget.setErrorToolTip(this.messages.booleanWidgetErrorToolTip());
        } else {
            widget.setReadOnly(true);
        }
        return widget;
    }

    @Override
    public DataTypeWidget<Long> createIntegerWidget(WidgetConfiguration configuration) {
        IntegerConverter converter = new IntegerConverter();
        TypedTextBoxWidget widget = null;
        if (!configuration.hasOptions()) {
            widget = new TypedTextBoxWidget((IValueConverter)converter);
        } else if (!configuration.isAnyValueAllowed()) {
            TypedListBoxWidget listBox = new TypedListBoxWidget((IValueConverter)new IntegerConverter());
            listBox.addItem("", null);
            Set<String> excludedKeys = configuration.getExcludedOptionKeys();
            for (UIValueOption valueOption : configuration.getOptions()) {
                if (excludedKeys != null && excludedKeys.contains(valueOption.getName())) continue;
                listBox.addItem(valueOption.getName(), (Object)Long.parseLong(valueOption.getValue()));
            }
            widget = listBox;
        } else {
            TypedComboBoxWidget combo = new TypedComboBoxWidget((IValueConverter)converter, 500);
            combo.addItem("", null);
            Set<String> excludedKeys = configuration.getExcludedOptionKeys();
            for (UIValueOption valueOption : configuration.getOptions()) {
                if (excludedKeys != null && excludedKeys.contains(valueOption.getName())) continue;
                combo.addItem(valueOption.getName(), (Object)Long.parseLong(valueOption.getValue()));
            }
            widget = combo;
        }
        if (!configuration.isReadOnly()) {
            widget.setToolTip(this.messages.integerWidgetToolTip());
            widget.setErrorToolTip(this.messages.integerWidgetErrorToolTip());
        } else {
            widget.setReadOnly(true);
        }
        return widget;
    }

    @Override
    public DataTypeWidget<String> createFloatWidget(WidgetConfiguration configuration) {
        FloatConverter converter = new FloatConverter();
        TypedTextBoxWidget widget = null;
        if (!configuration.hasOptions()) {
            widget = new TypedTextBoxWidget((IValueConverter)converter);
        } else if (!configuration.isAnyValueAllowed()) {
            TypedListBoxWidget listBox = new TypedListBoxWidget((IValueConverter)converter);
            listBox.addItem("", null);
            for (UIValueOption valueOption : configuration.getOptions()) {
                listBox.addItem(valueOption.getName(), (Object)valueOption.getValue());
            }
            widget = listBox;
        } else {
            TypedComboBoxWidget combo = new TypedComboBoxWidget((IValueConverter)converter, 500);
            combo.addItem("", null);
            for (UIValueOption valueOption : configuration.getOptions()) {
                combo.addItem(valueOption.getName(), (Object)valueOption.getValue());
            }
            widget = combo;
        }
        if (!configuration.isReadOnly()) {
            widget.setToolTip(this.messages.floatWidgetToolTip());
            widget.setErrorToolTip(this.messages.floatWidgetErrorToolTip());
        } else {
            widget.setReadOnly(true);
        }
        return widget;
    }

    @Override
    public DataTypeWidget<String> createDateWidget(DateWidgetConfiguration configuration) {
        String dateFormat = configuration.getDateFormat();
        if (dateFormat == null || dateFormat.trim().length() == 0) {
            dateFormat = this.messages.dateWidgetFormat();
        }
        DateConverter converter = new DateConverter(this.inputDateFormat, dateFormat);
        TypedDateBoxWidget widget = new TypedDateBoxWidget((IDateConverter)converter);
        if (!configuration.isReadOnly()) {
            widget.setToolTip(this.messages.dateWidgetToolTip(dateFormat));
            widget.setErrorToolTip(this.messages.dateWidgetErrorToolTip(dateFormat));
        } else {
            widget.setReadOnly(true);
        }
        return widget;
    }

    @Override
    public DataTypeWidget<String> createTimeWidget(TimeWidgetConfiguration configuration) {
        String timeFormat = configuration.getTimeFormat();
        if (timeFormat == null || timeFormat.trim().length() == 0) {
            timeFormat = this.messages.timeWidgetFormat();
        }
        DateConverter converter = new DateConverter(this.inputTimeFormat, timeFormat);
        TypedTextBoxWidget widget = new TypedTextBoxWidget((IValueConverter)converter);
        if (!configuration.isReadOnly()) {
            widget.setToolTip(this.messages.timeWidgetToolTip(timeFormat));
            widget.setErrorToolTip(this.messages.timeWidgetErrorToolTip(timeFormat));
        } else {
            widget.setReadOnly(true);
        }
        return widget;
    }

    @Override
    public DataTypeWidget<String> createStringWidget(StringWidgetConfiguration configuration) {
        StringConverter converter = new StringConverter();
        Object widget = null;
        if (configuration.isLongForm()) {
            TypedTextAreaWidget textArea;
            widget = textArea = new TypedTextAreaWidget((IValueConverter)converter);
        } else if (configuration.hasOptions() && !configuration.isAnyValueAllowed()) {
            TypedListBoxWidget listBox = new TypedListBoxWidget((IValueConverter)converter);
            listBox.addItem("", null);
            Set<String> excludedKeys = configuration.getExcludedOptionKeys();
            for (UIValueOption option : configuration.getOptions()) {
                if (excludedKeys != null && excludedKeys.contains(option.getName())) continue;
                listBox.addItem(option.getName(), (Object)option.getValue());
            }
            widget = listBox;
        } else if (configuration.hasOptions()) {
            TypedComboBoxWidget comboBox = new TypedComboBoxWidget((IValueConverter)converter, 500);
            comboBox.addItem("", null);
            Set<String> excludedKeys = configuration.getExcludedOptionKeys();
            for (UIValueOption option : configuration.getOptions()) {
                if (excludedKeys != null && excludedKeys.contains(option.getName())) continue;
                comboBox.addItem(option.getName(), (Object)option.getValue());
            }
            widget = comboBox;
        } else {
            widget = configuration.isPositionField() ? new TypedPositionFieldWidget(converter) : new TypedTextBoxWidget((IValueConverter)converter);
        }
        if (!configuration.isReadOnly()) {
            widget.setToolTip(this.messages.stringWidgetToolTip());
            widget.setErrorToolTip(this.messages.stringWidgetErrorToolTip());
        } else {
            widget.setReadOnly(true);
        }
        return widget;
    }

    public String getInputDatePattern() {
        return this.inputDateFormat;
    }

    public void setInputDateFormat(String format) {
        this.inputDateFormat = format;
    }

    public String getInputTimeFormat() {
        return this.inputTimeFormat;
    }

    public void setInputTimeFormat(String format) {
        this.inputTimeFormat = format;
    }

    private class RestrictedBooleanConverter
    extends BooleanConverter {
        public Boolean getTypedValue(String value) {
            if (value == null || value.trim().length() == 0) {
                return null;
            }
            if (value.trim().equalsIgnoreCase("false") || value.trim().equalsIgnoreCase("true")) {
                return new Boolean(value.trim());
            }
            throw new ValueFormatException(value + " is not a valid boolean.");
        }
    }
}

