/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory;

import com.tandbergtv.cms.portal.ui.title.client.model.specification.UISimpleFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public class WidgetConfiguration {
    private List<UIValueOption> options;
    private boolean anyValueAllowed = true;
    private Set<String> excludedOptionKeys;
    private boolean isReadOnly = false;

    public WidgetConfiguration() {
    }

    public WidgetConfiguration(UISimpleFieldDefinition definition) {
        this.setAnyValueAllowed(definition.isAnyValueAllowed());
        this.options = definition.getSuggestedValues();
    }

    public boolean hasOptions() {
        return this.options != null && !this.options.isEmpty();
    }

    public boolean isAnyValueAllowed() {
        return this.anyValueAllowed;
    }

    public void setAnyValueAllowed(boolean anyValueAllowed) {
        this.anyValueAllowed = anyValueAllowed;
    }

    public Set<String> getExcludedOptionKeys() {
        return this.excludedOptionKeys;
    }

    public void setExcludedOptionKeys(Set<String> excludedOptionKeys) {
        this.excludedOptionKeys = excludedOptionKeys;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public List<UIValueOption> getOptions() {
        return this.options;
    }

    public void setOptions(List<UIValueOption> options) {
        this.options = options;
    }

    public void sortOptions() {
        this.sortOptions(UIValueOption.STRING_COMPARATOR);
    }

    public void sortOptions(Comparator<UIValueOption> comparator) {
        if (this.options != null) {
            Collections.sort(this.options, comparator);
        }
    }
}

