/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.client.widget;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.dom.client.HasKeyDownHandlers;
import com.google.gwt.event.dom.client.HasKeyPressHandlers;
import com.google.gwt.event.dom.client.HasKeyUpHandlers;
import com.google.gwt.event.dom.client.HasMouseDownHandlers;
import com.google.gwt.event.dom.client.HasMouseMoveHandlers;
import com.google.gwt.event.dom.client.HasMouseOutHandlers;
import com.google.gwt.event.dom.client.HasMouseOverHandlers;
import com.google.gwt.event.dom.client.HasMouseUpHandlers;
import com.google.gwt.event.dom.client.HasMouseWheelHandlers;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.dom.client.MouseWheelEvent;
import com.google.gwt.event.dom.client.MouseWheelHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.HasDirection;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasName;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.TextBoxBase;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.DataTypeWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IValueConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.ValueFormatException;

public class TypedPositionFieldWidget<DataType>
extends DataTypeWidget<DataType>
implements HasName,
HasDirection,
HasText,
HasClickHandlers,
HasKeyPressHandlers,
HasKeyUpHandlers,
HasKeyDownHandlers,
HasMouseDownHandlers,
HasMouseMoveHandlers,
HasMouseOutHandlers,
HasMouseOverHandlers,
HasMouseUpHandlers,
HasMouseWheelHandlers {
    private TextBoxWidget widget;
    private IValueConverter<DataType> valueConverter;

    public TypedPositionFieldWidget(IValueConverter<DataType> valueConverter) {
        this.valueConverter = valueConverter;
        this.widget = new TextBoxWidget();
        EventHandler eventHandler = new EventHandler();
        this.widget.addValueChangeHandler((ValueChangeHandler)eventHandler);
        super.initWidget((Widget)this.widget);
        this.init();
    }

    public String getName() {
        return this.widget.getName();
    }

    public void setName(String name) {
        this.widget.setName(name);
    }

    public HasDirection.Direction getDirection() {
        return this.widget.getDirection();
    }

    public void setDirection(HasDirection.Direction direction) {
        this.widget.setDirection(direction);
    }

    public String getText() {
        return this.widget.getText();
    }

    public void setText(String text) {
        this.widget.setText(text);
    }

    public HandlerRegistration addClickHandler(ClickHandler handler) {
        return this.addDomHandler((com.google.gwt.event.shared.EventHandler)handler, ClickEvent.getType());
    }

    public HandlerRegistration addKeyPressHandler(KeyPressHandler handler) {
        return this.addDomHandler((com.google.gwt.event.shared.EventHandler)handler, KeyPressEvent.getType());
    }

    public HandlerRegistration addKeyUpHandler(KeyUpHandler handler) {
        return this.addDomHandler((com.google.gwt.event.shared.EventHandler)handler, KeyUpEvent.getType());
    }

    public HandlerRegistration addKeyDownHandler(KeyDownHandler handler) {
        return this.addDomHandler((com.google.gwt.event.shared.EventHandler)handler, KeyDownEvent.getType());
    }

    public HandlerRegistration addMouseDownHandler(MouseDownHandler handler) {
        return this.addDomHandler((com.google.gwt.event.shared.EventHandler)handler, MouseDownEvent.getType());
    }

    public HandlerRegistration addMouseMoveHandler(MouseMoveHandler handler) {
        return this.addDomHandler((com.google.gwt.event.shared.EventHandler)handler, MouseMoveEvent.getType());
    }

    public HandlerRegistration addMouseOutHandler(MouseOutHandler handler) {
        return this.addDomHandler((com.google.gwt.event.shared.EventHandler)handler, MouseOutEvent.getType());
    }

    public HandlerRegistration addMouseOverHandler(MouseOverHandler handler) {
        return this.addDomHandler((com.google.gwt.event.shared.EventHandler)handler, MouseOverEvent.getType());
    }

    public HandlerRegistration addMouseUpHandler(MouseUpHandler handler) {
        return this.addDomHandler((com.google.gwt.event.shared.EventHandler)handler, MouseUpEvent.getType());
    }

    public HandlerRegistration addMouseWheelHandler(MouseWheelHandler handler) {
        return this.addDomHandler((com.google.gwt.event.shared.EventHandler)handler, MouseWheelEvent.getType());
    }

    public DataType getValue() {
        Object value = null;
        try {
            value = this.valueConverter.getTypedValue(this.widget.getText());
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
        return (DataType)value;
    }

    public void setValue(DataType value) {
        this.setValue(value, false);
    }

    public void setValue(DataType value, boolean fireEvents) {
        this.widget.setValue((Object)this.valueConverter.getStringValue(value), fireEvents);
        this.updateWidgetState();
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<DataType> handler) {
        return this.addHandler((com.google.gwt.event.shared.EventHandler)handler, ValueChangeEvent.getType());
    }

    public int getTabIndex() {
        return this.widget.getTabIndex();
    }

    public void setTabIndex(int index) {
        this.widget.setTabIndex(index);
    }

    public void setAccessKey(char key) {
        this.widget.setAccessKey(key);
    }

    public void setFocus(boolean focused) {
        this.widget.setFocus(focused);
    }

    public HandlerRegistration addFocusHandler(FocusHandler handler) {
        return this.addDomHandler((com.google.gwt.event.shared.EventHandler)handler, FocusEvent.getType());
    }

    public HandlerRegistration addBlurHandler(BlurHandler handler) {
        return this.addDomHandler((com.google.gwt.event.shared.EventHandler)handler, BlurEvent.getType());
    }

    public boolean isValidValue() {
        boolean valid = false;
        try {
            this.valueConverter.getTypedValue(this.widget.getText());
            valid = true;
        }
        catch (ValueFormatException valueFormatException) {
            // empty catch block
        }
        return valid;
    }

    public String getTextValue() {
        return this.getText();
    }

    public void setTextValue(String textValue) {
        this.widget.setText(textValue);
        this.updateWidgetState();
    }

    public boolean isReadOnly() {
        return this.widget.isReadOnly();
    }

    public void setReadOnly(boolean readOnly) {
        this.widget.setReadOnly(readOnly);
    }

    public boolean isEnabled() {
        return this.widget.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.widget.setEnabled(enabled);
    }

    protected void updateStyle() {
        if (this.isInErrorState()) {
            this.widget.addStyleDependentName("dataTypeError");
        } else {
            this.widget.removeStyleDependentName("dataTypeError");
        }
    }

    public String getCurrentToolTip() {
        return this.widget.getTitle();
    }

    protected void setCurrentToolTip(String toolTip) {
        this.widget.setTitle(toolTip);
    }

    public int getMaxLength() {
        return this.widget.getMaxLength();
    }

    public void setMaxLength(int length) {
        this.widget.setMaxLength(length);
    }

    public int getVisibleLength() {
        return this.widget.getVisibleLength();
    }

    public void setVisibleLength(int length) {
        this.widget.setVisibleLength(length);
    }

    public void cancelKey() {
        this.widget.cancelKey();
    }

    public int getCursorPos() {
        return this.widget.getCursorPos();
    }

    public void setCursorPos(int pos) {
        this.widget.setCursorPos(pos);
    }

    public String getSelectedText() {
        return this.widget.getSelectedText();
    }

    public int getSelectionLength() {
        return this.widget.getSelectionLength();
    }

    public void setSelectionRange(int pos, int length) {
        this.widget.setSelectionRange(pos, length);
    }

    public void selectAll() {
        this.widget.selectAll();
    }

    public void setTextAlignment(TextBoxBase.TextAlignConstant align) {
        this.widget.setTextAlignment(align);
    }

    private void init() {
        final TextBox xField = new TextBox();
        xField.setVisibleLength(2);
        final TextBox yField = new TextBox();
        yField.setVisibleLength(2);
        final Grid theGrid = new Grid(1, 1);
        theGrid.addStyleName("theGrid");
        theGrid.setBorderWidth(1);
        theGrid.setSize("320px", "180px");
        final DialogBox dialogBox = new DialogBox();
        dialogBox.setAnimationEnabled(true);
        Button closeButton = new Button("Save");
        closeButton.getElement().setId("closeButton");
        VerticalPanel dialogVPanel = new VerticalPanel();
        dialogVPanel.addStyleName("dialogVPanel");
        HorizontalPanel dimension = new HorizontalPanel();
        dimension.add((Widget)xField);
        dimension.add((Widget)new HTML("<b>x</b>"));
        dimension.add((Widget)yField);
        dialogVPanel.add((Widget)dimension);
        dialogVPanel.add((Widget)theGrid);
        dialogVPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
        dialogVPanel.add((Widget)closeButton);
        dialogBox.setWidget((Widget)dialogVPanel);
        closeButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                String cells = "";
                for (int i = 0; i < theGrid.getRowCount(); ++i) {
                    for (int j = 0; j < theGrid.getCellCount(0); ++j) {
                        if (!theGrid.getCellFormatter().getStyleName(i, j).equals("cellSelect")) continue;
                        cells = cells.equals("") ? "(" + (j + 1) + "," + (i + 1) + ")" : cells + ",(" + (j + 1) + "," + (i + 1) + ")";
                    }
                }
                TypedPositionFieldWidget.this.widget.setText("{" + cells + "}/" + xField.getText() + "x" + yField.getText());
                dialogBox.hide();
            }
        });
        class PositionHandler
        implements ClickHandler,
        FocusHandler {
            PositionHandler() {
            }

            public void onClick(ClickEvent event) {
                this.openDialogBox();
            }

            public void onFocus(FocusEvent event) {
                this.openDialogBox();
            }

            private void openDialogBox() {
                dialogBox.setText("Overlay Position");
                if (TypedPositionFieldWidget.this.widget.getText() != null && TypedPositionFieldWidget.this.widget.getText().matches("{((\\(\\d+,\\d+\\),)*\\(\\d+,\\d+\\)|)}/\\d+x\\d+")) {
                    xField.setText(TypedPositionFieldWidget.this.widget.getText().substring(TypedPositionFieldWidget.this.widget.getText().indexOf("/") + 1, TypedPositionFieldWidget.this.widget.getText().indexOf("x")));
                    yField.setText(TypedPositionFieldWidget.this.widget.getText().substring(TypedPositionFieldWidget.this.widget.getText().indexOf("x") + 1));
                } else {
                    xField.setText("1");
                    yField.setText("1");
                }
                theGrid.resize(0, 0);
                theGrid.resize(Integer.parseInt(yField.getText()), Integer.parseInt(xField.getText()));
                if (TypedPositionFieldWidget.this.widget.getText() != null && TypedPositionFieldWidget.this.widget.getText().matches("{((\\(\\d+,\\d+\\),)*\\(\\d+,\\d+\\)|)}/\\d+x\\d+")) {
                    String[] cells;
                    for (String cell : cells = TypedPositionFieldWidget.this.widget.getText().substring(TypedPositionFieldWidget.this.widget.getText().indexOf("{") + 2, TypedPositionFieldWidget.this.widget.getText().indexOf("}") - 1).split("\\),\\(")) {
                        String[] c = cell.split(",");
                        int x = Integer.parseInt(c[0]) - 1;
                        int y = Integer.parseInt(c[1]) - 1;
                        theGrid.getCellFormatter().setStyleName(y, x, "cellSelect");
                    }
                }
                dialogBox.center();
            }
        }
        PositionHandler handler = new PositionHandler();
        this.widget.addClickHandler((ClickHandler)handler);
        class DimensionHandler
        implements ChangeHandler,
        KeyUpHandler {
            DimensionHandler() {
            }

            public void onChange(ChangeEvent event) {
                theGrid.resize(0, 0);
                theGrid.resize(Integer.parseInt(yField.getText()), Integer.parseInt(xField.getText()));
            }

            public void onKeyUp(KeyUpEvent event) {
                theGrid.resize(0, 0);
                theGrid.resize(Integer.parseInt(yField.getText()), Integer.parseInt(xField.getText()));
            }
        }
        DimensionHandler dHandler = new DimensionHandler();
        xField.addChangeHandler((ChangeHandler)dHandler);
        yField.addChangeHandler((ChangeHandler)dHandler);
        xField.addKeyUpHandler((KeyUpHandler)dHandler);
        yField.addKeyUpHandler((KeyUpHandler)dHandler);
        class GridHandler
        implements ClickHandler {
            GridHandler() {
            }

            public void onClick(ClickEvent event) {
                HTMLTable.Cell cell = theGrid.getCellForEvent(event);
                int x = cell.getRowIndex();
                int y = cell.getCellIndex();
                if (theGrid.getCellFormatter().getStyleName(x, y).equals("cellSelect")) {
                    theGrid.getCellFormatter().removeStyleName(x, y, "cellSelect");
                } else {
                    theGrid.getCellFormatter().setStyleName(x, y, "cellSelect");
                }
            }
        }
        GridHandler gh = new GridHandler();
        theGrid.addClickHandler((ClickHandler)gh);
    }

    private class EventHandler
    implements ValueChangeHandler<String> {
        private EventHandler() {
        }

        public void onValueChange(ValueChangeEvent<String> event) {
            TypedPositionFieldWidget.this.updateWidgetState();
            Object value = null;
            try {
                value = TypedPositionFieldWidget.this.valueConverter.getTypedValue((String)event.getValue());
                String formattedValue = TypedPositionFieldWidget.this.valueConverter.getStringValue(value);
                TypedPositionFieldWidget.this.widget.setValue((Object)formattedValue);
            }
            catch (ValueFormatException valueFormatException) {
                // empty catch block
            }
            ValueChangeEvent.fire((HasValueChangeHandlers)TypedPositionFieldWidget.this, value);
        }
    }
}

