/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.server.msooverrides;

import com.tandbergtv.metadatamanager.search.SearchSchemaHelper;
import com.tandbergtv.watchpoint.pmm.title.conf.ComplexVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleConf;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecification;
import com.tandbergtv.watchpoint.pmm.title.conf.Variable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MetadataFieldsMapBuilder {
    private SearchSchemaHelper searchSchemaHelper = new SearchSchemaHelper();

    public Map<String, String> buildMetadataFieldsMap(UISpecification uiSpecification) {
        HashMap<String, String> metadataFieldsMap = null;
        if (uiSpecification != null) {
            metadataFieldsMap = new HashMap<String, String>();
            this.processTitleConf(null, uiSpecification.getRootTitleConf(), metadataFieldsMap);
        }
        return metadataFieldsMap;
    }

    private MetadataFieldNode processTitleConf(MetadataFieldNode parentMetadataFieldNode, TitleConf titleConf, Map<String, String> metadataFieldsMap) {
        MetadataFieldNode metadataFieldNode = null;
        if (titleConf != null) {
            metadataFieldNode = new MetadataFieldNode();
            metadataFieldNode.setName(titleConf.getName());
            metadataFieldNode.setDisplayName(titleConf.getAlias());
            String xPath = titleConf.getPath();
            metadataFieldNode.setxPath(xPath);
            String fullXPath = this.searchSchemaHelper.prepareSelectXpath(xPath, "").replace("[1]", "");
            metadataFieldNode.setFullXPath(fullXPath);
            if (parentMetadataFieldNode != null) {
                metadataFieldNode.setFullName(parentMetadataFieldNode.getFullName() + "." + titleConf.getName());
                metadataFieldNode.setFullDisplayName(parentMetadataFieldNode.getFullDisplayName() + "." + titleConf.getAlias());
            } else {
                metadataFieldNode.setFullName(titleConf.getName());
                metadataFieldNode.setFullDisplayName(titleConf.getAlias());
            }
            for (Variable variable : titleConf.getMetadata()) {
                MetadataFieldNode variableMetadataFieldNode = this.processVariable(metadataFieldNode, variable, metadataFieldsMap);
                if (variableMetadataFieldNode == null) continue;
                metadataFieldNode.getChildren().add(variableMetadataFieldNode);
            }
            for (TitleConf childTitleConf : titleConf.getChildren()) {
                MetadataFieldNode childTitleConfMetadataFieldNode = this.processTitleConf(metadataFieldNode, childTitleConf, metadataFieldsMap);
                if (childTitleConfMetadataFieldNode == null) continue;
                metadataFieldNode.getChildren().add(childTitleConfMetadataFieldNode);
            }
            if (parentMetadataFieldNode != null && metadataFieldNode.getChildren().size() < 1) {
                metadataFieldNode = null;
            }
        }
        return metadataFieldNode;
    }

    private MetadataFieldNode processVariable(MetadataFieldNode parentMetadataFieldNode, Variable variable, Map<String, String> metadataFieldsMap) {
        MetadataFieldNode metadataFieldNode = null;
        if (variable != null) {
            String variableName = variable.getName();
            String variableDisplayName = variable.getDisplayName();
            String variableXPath = variable.getXPath();
            String nodeFullName = variableName;
            String nodeFullDisplayName = variableDisplayName;
            String nodeFullXPath = variableXPath;
            if (parentMetadataFieldNode != null) {
                nodeFullName = parentMetadataFieldNode.getFullName() + "." + variableName;
                nodeFullDisplayName = parentMetadataFieldNode.getFullDisplayName() + "." + variableDisplayName;
                nodeFullXPath = parentMetadataFieldNode.getFullXPath() + variableXPath;
            }
            metadataFieldNode = new MetadataFieldNode();
            metadataFieldNode.setName(variableName);
            metadataFieldNode.setDisplayName(variableDisplayName);
            metadataFieldNode.setxPath(variableXPath);
            metadataFieldNode.setFullName(nodeFullName);
            metadataFieldNode.setFullDisplayName(nodeFullDisplayName);
            metadataFieldNode.setFullXPath(nodeFullXPath);
            metadataFieldsMap.put(nodeFullXPath, nodeFullDisplayName);
            if (variable instanceof ComplexVariable) {
                metadataFieldNode.setFullXPath(parentMetadataFieldNode.getFullXPath());
                ComplexVariable complexVariable = (ComplexVariable)variable;
                for (Variable childVariable : complexVariable.getChildren()) {
                    MetadataFieldNode childVariableMetadataFieldNode = this.processVariable(metadataFieldNode, childVariable, metadataFieldsMap);
                    if (childVariableMetadataFieldNode == null) continue;
                    metadataFieldNode.getChildren().add(childVariableMetadataFieldNode);
                }
                if (metadataFieldNode.getChildren().size() < 1) {
                    metadataFieldNode = null;
                }
            }
        }
        return metadataFieldNode;
    }

    private static class MetadataFieldNode {
        private String name;
        private String displayName;
        private String xPath;
        private String fullName;
        private String fullDisplayName;
        private String fullXPath;
        private List<MetadataFieldNode> children = new ArrayList<MetadataFieldNode>();

        public MetadataFieldNode() {
            this("");
        }

        public MetadataFieldNode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public String getFullName() {
            return this.fullName;
        }

        public void setFullName(String fullName) {
            this.fullName = fullName;
        }

        public String getFullDisplayName() {
            return this.fullDisplayName;
        }

        public void setFullDisplayName(String fullDisplayName) {
            this.fullDisplayName = fullDisplayName;
        }

        public List<MetadataFieldNode> getChildren() {
            return this.children;
        }

        public String getxPath() {
            return this.xPath;
        }

        public void setxPath(String xPath) {
            this.xPath = xPath;
        }

        public String getFullXPath() {
            return this.fullXPath;
        }

        public void setFullXPath(String fullXPath) {
            this.fullXPath = fullXPath;
        }
    }
}

