/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.server.search;

import com.tandbergtv.cms.portal.ui.title.client.criteria.contentclass.ContentClassInfo;
import com.tandbergtv.cms.portal.ui.title.client.criteria.contentclass.IContentClassProvider;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;
import com.tandbergtv.content.contentclass.service.IContentClassOptionsProvider;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.NeptuneAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.pmm.title.conf.ISpecificationManager;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ContentClassProvider
implements IContentClassProvider,
NeptuneRemoteService {
    private IContentClassOptionsProvider optionsProvider = (IContentClassOptionsProvider)InjectionUtil.injectInstance((String)"cms/ContentClassOptionsProviderService/local", IContentClassOptionsProvider.class);
    ISpecificationManager specManager = (ISpecificationManager)ServiceRegistry.getDefault().lookup(ISpecificationManager.class);

    @Override
    public ContentClassInfo getContentClassInfo() throws NeptuneException {
        String userName = NeptuneAuthorizationManager.getAuthorizationService().getUserName();
        Map<Long, String> contentClasses = this.getContentClasses(userName);
        List<UIValueOption> uiCC = this.convertContentClasses(contentClasses);
        Map<String, Map<String, String>> options = this.getSuggestedValues();
        return new ContentClassInfo(uiCC, options);
    }

    private Map<Long, String> getContentClasses(String userName) {
        return this.optionsProvider.getContentClasses(userName);
    }

    private List<UIValueOption> convertContentClasses(Map<Long, String> contentClasses) throws NeptuneException {
        ArrayList<UIValueOption> result = new ArrayList<UIValueOption>();
        for (Map.Entry<Long, String> cc : contentClasses.entrySet()) {
            result.add(new UIValueOption(cc.getValue(), cc.getKey().toString()));
        }
        return result;
    }

    private Map<String, Map<String, String>> getSuggestedValues() {
        return this.specManager.getFieldsWithOptions();
    }

    public String getRelativePath() {
        return "service/title/contentClassProvider";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }
}

