/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.server.search;

import com.ericsson.cms.criteria.ExpList;
import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateComplex;
import com.ericsson.cms.criteria.PredicateRightField;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.ericsson.cms.criteria.info.PagingInfo;
import com.ericsson.cms.criteria.info.SortOrder;
import com.ericsson.cms.criteria.info.SortingInfo;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UIDataType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.BaseOperator;
import com.tandbergtv.cms.portal.ui.title.client.model.search.IUITitleFilterNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.RhsType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.TitleFilterOperator;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIParamType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UISortOrder;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilter;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterComplexValue;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterConditionNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterListNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterQuickSearchListNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterRHSFieldNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterValueNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiPageInfo;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiSortInfo;
import com.tandbergtv.cms.portal.ui.title.server.search.TitleFilterServiceError;
import com.tandbergtv.cms.portal.ui.title.server.specification.FieldLookupService;
import com.tandbergtv.cms.titlefilter.CriteriaMode;
import com.tandbergtv.cms.titlefilter.TitleFilter;
import java.util.ArrayList;
import java.util.List;

public class UiTitleFilterService {
    public void convertTitleFilter(TitleFilter titleFilter, UITitleFilter uiTitleFilter) {
        titleFilter.setSortInfo(this.convertSortInfo(uiTitleFilter.getSortInfo()));
        titleFilter.setPageInfo(new PagingInfo(uiTitleFilter.getPageInfo().getStartIndex(), uiTitleFilter.getPageInfo().getMaxCount()));
        titleFilter.setCountIncluded(uiTitleFilter.isCountIncluded());
        titleFilter.setRootNode(this.convertTree(titleFilter.getRootNode(), uiTitleFilter.getRootNode()));
        titleFilter.setFilterSiteIds(new ArrayList());
        CriteriaMode criteriaMode = CriteriaMode.MASTER;
        if (uiTitleFilter.getCriteriaMode().equals((Object)UiCriteriaMode.SERIES)) {
            criteriaMode = CriteriaMode.SERIES;
        }
        if (uiTitleFilter.getCriteriaMode().equals((Object)UiCriteriaMode.SITE)) {
            criteriaMode = CriteriaMode.SITE;
            titleFilter.setFilterSiteIds(uiTitleFilter.getFilterSiteIds());
        }
        titleFilter.setCriteriaMode(criteriaMode);
    }

    public SortingInfo convertSortInfo(UiSortInfo sortInfo) {
        if (sortInfo == null || sortInfo.isEmpty()) {
            return null;
        }
        String colName = sortInfo.getSortColumnName();
        String colSection = sortInfo.getSortColumnSection();
        SortOrder sortOrder = SortOrder.valueOf((String)sortInfo.getSortOrder().name());
        FieldType fieldType = FieldType.valueOf((String)sortInfo.getSortFieldType().name());
        return new SortingInfo(colName, sortOrder, colSection, fieldType);
    }

    public UITitleFilter convertTitleFilter(TitleFilter titleFilter) throws TitleFilterServiceError {
        String sortColName = "";
        String SortColAssetType = "";
        UISortOrder sortOrder = null;
        UIFieldType sortFieldType = UIFieldType.ASSET;
        UiCriteriaMode criteriaMode = UiCriteriaMode.EPISODE;
        if (titleFilter.getCriteriaMode().equals((Object)CriteriaMode.SERIES)) {
            criteriaMode = UiCriteriaMode.SERIES;
        }
        if (titleFilter.getSortInfo() != null) {
            sortColName = titleFilter.getSortInfo().getSortItemName();
            SortColAssetType = titleFilter.getSortInfo().getAssetType();
            sortOrder = UISortOrder.valueOf(titleFilter.getSortInfo().getOrder().name());
            sortFieldType = UIFieldType.valueOf(titleFilter.getSortInfo().getFieldType().name());
        }
        UITitleFilter uiFilter = new UITitleFilter(this.convertExpNode(titleFilter.getRootNode()), sortColName, SortColAssetType, sortOrder, sortFieldType, criteriaMode);
        uiFilter.setPageInfo(new UiPageInfo(titleFilter.getPageInfo().getStartIndex(), titleFilter.getPageInfo().getMaxRecordCount()));
        uiFilter.setIncludeCount(titleFilter.isCountIncluded());
        return uiFilter;
    }

    public IUITitleFilterNode convertExpNode(ExpNode rootListNode) throws TitleFilterServiceError {
        if (rootListNode == null) {
            return null;
        }
        if (rootListNode instanceof ExpList) {
            return this.convertListNode((ExpList)rootListNode);
        }
        if (rootListNode instanceof ExpValue) {
            return this.convertUIPredicate((ExpValue)rootListNode);
        }
        throw new TitleFilterServiceError("Got a TreExpNode that is neither a TreExpList or TreExpValue it is a :" + rootListNode.getClass());
    }

    private UITitleFilterListNode convertListNode(ExpList rootListNode) throws TitleFilterServiceError {
        UITitleFilterListNode listNode = new UITitleFilterListNode();
        listNode.setUiRetOperator(this.convertOperator(rootListNode.getOperator()));
        if (rootListNode.getNodes() == null) {
            return listNode;
        }
        for (ExpNode node : rootListNode.getNodes()) {
            if (node instanceof ExpValue) {
                listNode.addItem(this.convertUIPredicate((ExpValue)node));
                continue;
            }
            if (!(node instanceof ExpList)) continue;
            listNode.addItem(this.convertListNode((ExpList)node));
        }
        return listNode;
    }

    private TitleFilterOperator convertOperator(String operator) {
        if (operator.toUpperCase().equals("AND")) {
            return TitleFilterOperator.AND;
        }
        return TitleFilterOperator.OR;
    }

    private UITitleFilterConditionNode convertUIPredicate(ExpValue expVal) throws TitleFilterServiceError {
        return this.convertUIPredicate(expVal.getPredicate());
    }

    private UITitleFilterConditionNode convertUIPredicate(Predicate predicate) throws TitleFilterServiceError {
        String fieldLhs = predicate.getFieldLeft();
        String sectionTypeLhs = predicate.getFieldLeftSectionType();
        boolean ignoreCase = predicate.getIgnoreCase();
        boolean not = predicate.getNot();
        BaseOperator sop = BaseOperator.lookup(predicate.getOperator().name());
        UIParamType paramType = sop.multiValued() ? UIParamType.LIST : (sop.hasRightSide() ? UIParamType.VALUE : UIParamType.VALUE);
        UIFieldType fieldTypeLhs = UIFieldType.valueOf(predicate.getFieldTypeLhs().name());
        FieldLookupService.FieldInfo fieldLeftInfo = FieldLookupService.getInstance().getDisplayName(predicate.getFieldTypeLhs(), predicate.getFieldLeftSectionType(), predicate.getFieldLeft());
        String extendDisplayNameLhs = null;
        String fieldLeftDisplayName = null;
        UIDataType dataType = null;
        String complexType = null;
        if (fieldLeftInfo != null) {
            fieldLeftDisplayName = fieldLeftInfo.getDisplayName();
            dataType = fieldLeftInfo.getDataType();
            complexType = fieldLeftInfo.getComplexType();
            extendDisplayNameLhs = fieldLeftInfo.getFullDisplayName();
        }
        if (predicate instanceof PredicateRightValue) {
            PredicateRightValue pred = (PredicateRightValue)predicate;
            UITitleFilterValueNode result = new UITitleFilterValueNode(fieldLhs, sectionTypeLhs, fieldTypeLhs, sop, this.copyList(pred.getValue()), paramType, ignoreCase, not, dataType, fieldLeftDisplayName, complexType, extendDisplayNameLhs);
            return result;
        }
        if (predicate instanceof PredicateRightField) {
            PredicateRightField prf = (PredicateRightField)predicate;
            FieldLookupService.FieldInfo fieldRightInfo = FieldLookupService.getInstance().getDisplayName(prf.getFieldTypeRhs(), prf.getFieldRightSectionType(), prf.getFieldRight());
            String fieldRightDisplayName = fieldRightInfo == null ? null : fieldRightInfo.getDisplayName();
            String extendedDisplayNameRhs = fieldRightInfo == null ? null : fieldRightInfo.getFullDisplayName();
            String fieldRhs = prf.getFieldRight();
            String sectionTypeRhs = prf.getFieldRightSectionType();
            UIFieldType fieldTypeRhs = UIFieldType.valueOf(prf.getFieldTypeRhs().name());
            UITitleFilterRHSFieldNode result = new UITitleFilterRHSFieldNode(fieldLhs, sectionTypeLhs, fieldTypeLhs, fieldLeftDisplayName, sop, paramType, ignoreCase, not, dataType, fieldRhs, sectionTypeRhs, fieldTypeRhs, fieldRightDisplayName, complexType, extendDisplayNameLhs, extendedDisplayNameRhs);
            return result;
        }
        if (predicate instanceof PredicateComplex) {
            PredicateComplex pred = (PredicateComplex)predicate;
            ArrayList<UITitleFilterConditionNode> children = new ArrayList<UITitleFilterConditionNode>();
            for (Predicate child : pred.getChildren()) {
                children.add(this.convertUIPredicate(child));
            }
            UITitleFilterComplexValue result = new UITitleFilterComplexValue(fieldLhs, sectionTypeLhs, sop, paramType, children, not, fieldTypeLhs, fieldLeftDisplayName, complexType, extendDisplayNameLhs);
            result.setDataType(dataType);
            result.setIgnoreCase(ignoreCase);
            return result;
        }
        if (predicate instanceof Predicate) {
            UITitleFilterValueNode result = new UITitleFilterValueNode(fieldLhs, sectionTypeLhs, fieldTypeLhs, sop, new ArrayList<String>(), paramType, ignoreCase, not, dataType, fieldLeftDisplayName, complexType, extendDisplayNameLhs);
            return result;
        }
        throw new TitleFilterServiceError("Got a TreExpValue that is neither a TrePredicateRightValue or TrePredicate it is a :" + predicate.getClass());
    }

    public ExpNode convertTree(ExpNode currRootNode, IUITitleFilterNode uiRootNode) {
        if (uiRootNode instanceof UITitleFilterConditionNode) {
            return this.convertUIPredicate((UITitleFilterConditionNode)uiRootNode);
        }
        if (uiRootNode instanceof UITitleFilterListNode) {
            ExpList result = null;
            result = currRootNode == null || currRootNode instanceof ExpValue ? new ExpList() : (ExpList)currRootNode;
            this.convertListNodeFromUi(result, (UITitleFilterListNode)uiRootNode);
            if (result.getNodes().size() == 0) {
                return null;
            }
            return result;
        }
        if (uiRootNode instanceof UITitleFilterQuickSearchListNode) {
            ExpList result = null;
            result = currRootNode == null || currRootNode instanceof ExpValue ? new ExpList() : (ExpList)currRootNode;
            this.convertListNodeFromUi(result, (UITitleFilterQuickSearchListNode)uiRootNode);
            if (result.getNodes().size() == 0) {
                return null;
            }
            return result;
        }
        return null;
    }

    private ExpValue convertUIPredicate(UITitleFilterConditionNode node) {
        return new ExpValue(this.convertUIPredicateToPred(node));
    }

    private Predicate convertUIPredicateToPred(UITitleFilterConditionNode node) {
        FieldType fieldTypeLhs = FieldType.valueOf((String)node.getFieldType().name());
        String fieldLhs = node.getField();
        String assetTypeLhs = node.getSectionType();
        LogicalOperator operator = LogicalOperator.lookUp((String)node.getSearchOperator().toString());
        String dataType = "";
        if (node.getDataType() != null) {
            dataType = node.getDataType().getDataTypeName();
        }
        boolean not = node.isNot();
        if (node.getRhsType().equals((Object)RhsType.COMPLEX)) {
            PredicateComplex result = new PredicateComplex(fieldLhs, assetTypeLhs, fieldTypeLhs, operator, dataType, Boolean.valueOf(not));
            UITitleFilterComplexValue complexNode = (UITitleFilterComplexValue)node;
            for (UITitleFilterConditionNode child : complexNode.getChildren()) {
                result.addChild(this.convertUIPredicateToPred(child));
            }
            return result;
        }
        if (node.getRhsType().equals((Object)RhsType.FIELD)) {
            UITitleFilterRHSFieldNode rhsField = (UITitleFilterRHSFieldNode)node;
            String fieldRight = rhsField.getFieldRhs();
            String fieldRightSectionType = rhsField.getSectionTypeRhs();
            FieldType fieldTypeRhs = FieldType.valueOf((String)rhsField.getFieldTypeRhs().name());
            return new PredicateRightField(fieldLhs, assetTypeLhs, fieldTypeLhs, fieldRight, fieldRightSectionType, fieldTypeRhs, operator, dataType, Boolean.valueOf(not), Boolean.valueOf(rhsField.isIgnoreCase()));
        }
        if (!node.getSearchOperator().hasRightSide()) {
            Predicate result = new Predicate(fieldLhs, assetTypeLhs, fieldTypeLhs, operator, dataType, Boolean.valueOf(not));
            result.setIgnoreCase(node.isIgnoreCase());
            return result;
        }
        UITitleFilterValueNode valueNode = (UITitleFilterValueNode)node;
        PredicateRightValue result = new PredicateRightValue(fieldLhs, assetTypeLhs, fieldTypeLhs, valueNode.getValues(), operator, dataType, Boolean.valueOf(not));
        result.setIgnoreCase(node.isIgnoreCase());
        return result;
    }

    private ArrayList<String> copyList(List<String> inList) {
        ArrayList<String> list = new ArrayList<String>();
        for (String str : inList) {
            list.add(str);
        }
        return list;
    }

    private void convertListNodeFromUi(ExpList listNode, UITitleFilterQuickSearchListNode uiQuickListNode) {
        UITitleFilterListNode uiListNode = new UITitleFilterListNode();
        uiListNode.setList(uiQuickListNode.getList());
        uiListNode.setUiRetOperator(uiQuickListNode.getUiRetOperator());
        this.convertListNodeFromUi(listNode, uiListNode);
    }

    private void convertListNodeFromUi(ExpList listNode, UITitleFilterListNode uiListNode) {
        int i;
        int expListSize = listNode.getNodes().size();
        listNode.setOperator(this.convertOperator(uiListNode.getUiRetOperator()));
        for (i = 0; i < uiListNode.getList().size(); ++i) {
            ExpList list;
            IUITitleFilterNode uinode = uiListNode.getList().get(i);
            if (uinode instanceof UITitleFilterConditionNode) {
                if (expListSize > i) {
                    listNode.getNodes().set(i, this.convertUIPredicate((UITitleFilterConditionNode)uinode));
                    continue;
                }
                listNode.addItem((ExpNode)this.convertUIPredicate((UITitleFilterConditionNode)uinode));
                continue;
            }
            if (!(uinode instanceof UITitleFilterListNode)) continue;
            if (expListSize > i) {
                if (listNode.getNodes().get(i) instanceof ExpList) {
                    list = (ExpList)listNode.getNodes().get(i);
                } else {
                    list = new ExpList();
                    listNode.getNodes().set(i, list);
                }
                this.convertListNodeFromUi(list, (UITitleFilterListNode)uinode);
                continue;
            }
            list = new ExpList();
            this.convertListNodeFromUi(list, (UITitleFilterListNode)uinode);
            listNode.addItem((ExpNode)list);
        }
        ArrayList deleteMarker = new ArrayList();
        while (i < listNode.getNodes().size()) {
            deleteMarker.add(listNode.getNodes().get(i));
            ++i;
        }
        for (ExpNode node : deleteMarker) {
            listNode.getNodes().remove(node);
        }
    }

    private String convertOperator(TitleFilterOperator node) {
        if (node.equals((Object)TitleFilterOperator.AND)) {
            return "AND";
        }
        return "OR";
    }
}

