/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.server.specification;

import com.ericsson.cms.criteria.FieldType;
import com.ericsson.extended_interface.IRulesLicensingProvider;
import com.ericsson.extended_interface.impl.RulesLicensingField;
import com.ericsson.rules.fieldprovider.metadataenhancement.IMetadataEnhancementField;
import com.ericsson.rules.fieldprovider.metadataenhancement.IMetadataEnhancementProvider;
import com.ericsson.rules.fieldprovider.metadataenhancement.IMetadataEnhancementProvidersChangeListener;
import com.ericsson.rules.fieldprovider.metadataenhancement.ISubscriptionProfile;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.AssetFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.AssetFileTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.AssetTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UIDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetFileDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetFileFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.server.specification.UIAssetFileDefinitionBuilder;
import com.tandbergtv.content.contentclass.service.ICustomFieldManager;
import com.tandbergtv.marvin.udt.DataTypes;
import com.tandbergtv.metadatamanager.search.SearchSchemaHelper;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.server.locale.ClientLocaleProvider;
import com.tandbergtv.watchpoint.pmm.title.conf.BooleanVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.ComplexVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.CustomField;
import com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup;
import com.tandbergtv.watchpoint.pmm.title.conf.DateVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.FloatVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.ISpecificationManager;
import com.tandbergtv.watchpoint.pmm.title.conf.IntegerVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.StringVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.TimeCodeVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.TimeVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleConf;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleConfMetadata;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecification;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecificationChangeListener;
import com.tandbergtv.watchpoint.pmm.title.conf.Variable;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class FieldLookupService {
    private static final Logger logger = Logger.getLogger(FieldLookupService.class);
    private static FieldLookupService service;
    private Map<String, AssetTreeObject> assetTreeObjects = new HashMap<String, AssetTreeObject>();
    private List<FieldInfo> displayNameLookup = new ArrayList<FieldInfo>();
    private List<IFieldTreeObject> mdmTree = new ArrayList<IFieldTreeObject>();
    private Date mdmTreeUpdateDate;
    private Map<String, FieldInfo> enhancementFieldDisplayNameLookup = new HashMap<String, FieldInfo>();
    private Map<String, FieldInfo> LicensingFieldDisplayNameLookup = new HashMap<String, FieldInfo>();
    private Map<String, FieldInfo> customFieldDisplayNameLookup = new HashMap<String, FieldInfo>();
    private Map<Character, SearchNode> searchIndex = new HashMap<Character, SearchNode>();
    private IMetadataEnhancementProvider metdataEnhancementProvider = (IMetadataEnhancementProvider)InjectionUtil.injectInstance((String)"cms/MEManager/local", IMetadataEnhancementProvider.class);
    private IRulesLicensingProvider licensingProvider = (IRulesLicensingProvider)InjectionUtil.injectInstance((String)"cms/RulesLicensingProvider/local", IRulesLicensingProvider.class);
    private ICustomFieldManager custManager;
    private CustomFieldUpdateHandler custUpdateHandler = new CustomFieldUpdateHandler();
    private SearchSchemaHelper ssh = new SearchSchemaHelper();
    private UIAssetFileDefinitionBuilder fileBuilder = new UIAssetFileDefinitionBuilder();
    private Map<String, String> complexFieldType = this.ssh.getFieldComplexTypes();
    private Date enhancementLastUpdateDate;

    private FieldLookupService() {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        ISpecificationManager manager = (ISpecificationManager)registry.lookup(ISpecificationManager.class);
        this.buildDisplayNameLookup(manager.getUISpecification(UISpecification.Type.PACKAGE));
        this.buildDisplayNameLookup(manager.getUISpecification(UISpecification.Type.SERIES));
        manager.addUISpecificationChangeListener((UISpecificationChangeListener)this.custUpdateHandler);
        this.addPMMFieldsToLookup();
        this.addLicensingFields();
        this.addSubscriptionFields();
        this.custManager = (ICustomFieldManager)registry.lookup(ICustomFieldManager.class);
        Collections.sort(this.displayNameLookup);
        this.custUpdateHandler.afterCustomFieldUpdate(this.custManager.getAllCustomFieldsForUISpec());
        this.metdataEnhancementProvider.addMetadataEnhancementProvidersChangeListener(new IMetadataEnhancementProvidersChangeListener(){

            public void metadataEnhancementProvidersChanged() {
                FieldLookupService.this.addSubscriptionFields();
            }
        });
    }

    public List<IFieldTreeObject> getMdmTree() {
        return this.mdmTree;
    }

    public Date getMdmLastUpdateDate() {
        return this.mdmTreeUpdateDate;
    }

    private void addSubscriptionFields() {
        this.enhancementLastUpdateDate = new Date();
        this.enhancementFieldDisplayNameLookup.clear();
        List subProfiles = this.metdataEnhancementProvider.getSubscriptionProfiles();
        for (ISubscriptionProfile sp : subProfiles) {
            String profileName = sp.getName();
            for (IMetadataEnhancementField field : sp.getFields()) {
                UIDataType dataType;
                String fullDisplayName = profileName + "." + field.getDisplayName();
                DataTypes enhancementDataType = field.getDataType();
                if (enhancementDataType.equals((Object)DataTypes.STRING) && !field.getDatatype().equalsIgnoreCase(CustomField.DataType.STRING.name())) {
                    dataType = UIDataType.COMPLEX;
                } else {
                    String dataTypeStr = enhancementDataType.getDataTypeName();
                    dataType = UIDataType.fromValue(dataTypeStr);
                }
                FieldInfo fieldInfo = new FieldInfo(FieldType.ENHANCEMENT, sp.getId().toString(), field.getFieldIdentifier(), fullDisplayName, fullDisplayName, dataType, field.getDatatype());
                this.enhancementFieldDisplayNameLookup.put(fieldInfo.getKey(), fieldInfo);
            }
        }
    }

    private void addLicensingFields() {
        this.LicensingFieldDisplayNameLookup.clear();
        List fields = this.licensingProvider.getFields();
        for (RulesLicensingField field : fields) {
            String identifier = field.getFieldIdentifier();
            String dataTypeStr = field.getFieldDataType().name();
            UIDataType dataType = dataTypeStr.equals("LONG") ? UIDataType.INTEGER : UIDataType.valueOf(dataTypeStr);
            String[] path = field.getDisplayName().split("/");
            String displayName = path[path.length - 1];
            String fullDisplayName = field.getDisplayName().replace("/", ".");
            FieldInfo fieldInfo = new FieldInfo(FieldType.LICENSE, "", identifier, fullDisplayName, displayName, dataType, null);
            this.LicensingFieldDisplayNameLookup.put(fieldInfo.getKey(), fieldInfo);
        }
    }

    private void addPMMFieldsToLookup() {
        Locale locale = ClientLocaleProvider.getClientLocaleProvider().getLocale();
        ResourceBundle bundle = locale != null ? ResourceBundle.getBundle("com.tandbergtv.cms.portal.ui.title.client.TitleConstants", locale) : ResourceBundle.getBundle("com.tandbergtv.cms.portal.ui.title.client.TitleConstants");
        FieldInfo contentClass = new FieldInfo(FieldType.PMM_TITLE, "", "contentClassId", bundle.getString("contentClass"), bundle.getString("contentClass"), UIDataType.INTEGER, null);
        this.displayNameLookup.add(contentClass);
        FieldInfo titleStatus = new FieldInfo(FieldType.PMM_TITLE, "", "status", bundle.getString("titleStatus"), bundle.getString("titleStatus"), UIDataType.STRING, null);
        this.displayNameLookup.add(titleStatus);
        FieldInfo titleId = new FieldInfo(FieldType.PMM_TITLE, "", "id", bundle.getString("TitleId"), bundle.getString("TitleId"), UIDataType.INTEGER, null);
        this.displayNameLookup.add(titleId);
        FieldInfo titleDistributionStatus = new FieldInfo(FieldType.PMM_TITLE, "", "distributionStatus", bundle.getString("distributionStatus"), bundle.getString("distributionStatus"), UIDataType.STRING, null);
        this.displayNameLookup.add(titleDistributionStatus);
        FieldInfo distributionDate = new FieldInfo(FieldType.PMM_TITLE, "", "distributionDate", bundle.getString("distributionDate"), bundle.getString("distributionDate"), UIDataType.DATE, null);
        this.displayNameLookup.add(distributionDate);
        FieldInfo createDate = new FieldInfo(FieldType.PMM_TITLE, "", "createDate", bundle.getString("createDate"), bundle.getString("createDate"), UIDataType.DATE, null);
        this.displayNameLookup.add(createDate);
        FieldInfo retirementDate = new FieldInfo(FieldType.PMM_TITLE, "", "retirementDate", bundle.getString("retirementDate"), bundle.getString("retirementDate"), UIDataType.DATE, null);
        this.displayNameLookup.add(retirementDate);
        FieldInfo titleProcessingStatus = new FieldInfo(FieldType.PMM_TITLE, "", "processingStatus", bundle.getString("processingStatus"), bundle.getString("processingStatus"), UIDataType.STRING, null);
        this.displayNameLookup.add(titleProcessingStatus);
    }

    private void buildSearchIndex() {
        for (FieldInfo entry : this.displayNameLookup) {
            String[] words;
            Map<Character, SearchNode> currMap = this.searchIndex;
            String displayName = entry.getFullDisplayName();
            for (String word : words = displayName.split("\\W")) {
                for (int i = 0; i < word.length(); ++i) {
                    Character c = Character.valueOf(word.charAt(i));
                    SearchNode node = currMap.get(c);
                    if (node == null) {
                        currMap.put(c, new SearchNode(entry));
                    } else {
                        node.addResult(entry);
                    }
                    currMap = node.getChildIndex();
                }
            }
        }
    }

    private void buildDisplayNameLookup(UISpecification spec) {
        TitleConf root = spec.getRootTitleConf();
        this.mdmTree.add(this.processTitleConf(root, ""));
    }

    private IFieldTreeObject processTitleConf(TitleConf titleConf, String parentDisplayName) {
        AssetFileTreeObject afto;
        TitleConfMetadata metadata = titleConf.getTitleConfMetadata();
        String assetDisplayName = titleConf.getAlias();
        String assetPath = titleConf.getPath();
        String fullDisplayName = parentDisplayName.isEmpty() ? assetDisplayName : parentDisplayName + "." + assetDisplayName;
        FieldInfo entry = new FieldInfo(FieldType.ASSET, assetPath, "", fullDisplayName, assetDisplayName, UIDataType.COMPLEX, null);
        this.displayNameLookup.add(entry);
        AssetTreeObject ato = new AssetTreeObject(assetDisplayName, assetPath, "", fullDisplayName);
        this.assetTreeObjects.put(ato.getAssetType(), ato);
        if (metadata != null && metadata.coreFields != null) {
            ato.setChildren(this.processVariables(metadata.coreFields, assetPath, assetDisplayName, fullDisplayName));
        }
        if ((afto = this.getFileDef(titleConf, fullDisplayName)).getChildren().size() > 0) {
            ato.addChild(afto);
        }
        if (titleConf.hasChildren()) {
            for (TitleConf childConf : titleConf.getChildren()) {
                ato.addChild(this.processTitleConf(childConf, fullDisplayName));
            }
        }
        return ato;
    }

    private AssetFileTreeObject getFileDef(TitleConf titleConf, String fullDisplayNameStart) {
        UIAssetFileDefinition file = this.fileBuilder.build(titleConf);
        String assetPath = titleConf.getPath() + "/FILE";
        String assetDisplayName = "File";
        String assetFullDisplayName = fullDisplayNameStart + "." + assetDisplayName;
        FieldInfo assetEntry = new FieldInfo(FieldType.ASSET, assetPath, "", assetFullDisplayName, assetDisplayName, UIDataType.COMPLEX, null);
        this.displayNameLookup.add(assetEntry);
        ArrayList<IFieldTreeObject> children = new ArrayList<IFieldTreeObject>();
        for (UIAssetFileFieldDefinition fileField : file.getFieldDefinitions()) {
            UIDataType dataType = this.convertDataType(fileField.getDatatype());
            String field = fileField.getFieldDefinition().getXPath();
            String displayName = assetDisplayName + "." + fileField.getDisplayName();
            String fullDisplayName = assetFullDisplayName + "." + fileField.getDisplayName();
            FieldInfo entry = new FieldInfo(FieldType.ASSET, assetPath, field, fullDisplayName, displayName, dataType, null);
            this.displayNameLookup.add(entry);
            AssetFieldTreeObject afto = new AssetFieldTreeObject(field, dataType, assetPath, displayName, null, fullDisplayName);
            children.add(afto);
        }
        return new AssetFileTreeObject(assetPath, children, fullDisplayNameStart + ".File");
    }

    private UIDataType convertDataType(UIFieldDataType dataType) {
        if (dataType == null) {
            return UIDataType.COMPLEX;
        }
        if (dataType.getName() == "string") {
            return UIDataType.STRING;
        }
        if (dataType.getName() == "integer") {
            return UIDataType.INTEGER;
        }
        if (dataType.getName() == "float") {
            return UIDataType.FLOAT;
        }
        if (dataType.getName() == "date") {
            return UIDataType.DATE;
        }
        if (dataType.getName() == "boolean") {
            return UIDataType.BOOLEAN;
        }
        if (dataType.getName() == "time") {
            return UIDataType.TIME;
        }
        if (dataType.getName() == "timecode") {
            return UIDataType.TIMECODE;
        }
        return UIDataType.STRING;
    }

    private List<IFieldTreeObject> processVariables(List<Variable> variables, String assetPath, String assetDisplayName, String parentFullDisplayName) {
        ArrayList<IFieldTreeObject> treeObj = new ArrayList<IFieldTreeObject>();
        for (Variable variable : variables) {
            if ("CustomFields".equals(variable.getName())) continue;
            String displayName = variable.getDisplayName();
            String xpath = variable.getXPath();
            String fullDisplayName = parentFullDisplayName + "." + displayName;
            String displayNameWAsset = assetDisplayName + "." + displayName;
            String complexType = this.complexFieldType.get(xpath);
            UIDataType dataType = this.getDataType(variable);
            FieldInfo entry = new FieldInfo(FieldType.ASSET, assetPath, xpath, fullDisplayName, displayNameWAsset, dataType, complexType);
            this.displayNameLookup.add(entry);
            AssetFieldTreeObject afto = new AssetFieldTreeObject(xpath, dataType, assetPath, displayNameWAsset, complexType, fullDisplayName);
            treeObj.add(afto);
            if (!(variable instanceof ComplexVariable)) continue;
            ComplexVariable complexVariable = (ComplexVariable)variable;
            List<IFieldTreeObject> children = this.processVariables(complexVariable.getChildren(), assetPath, assetDisplayName, fullDisplayName);
            afto.setChildren(children);
        }
        return treeObj;
    }

    private UIDataType getDataType(Variable var) {
        if (var instanceof StringVariable) {
            return UIDataType.STRING;
        }
        if (var instanceof IntegerVariable) {
            return UIDataType.INTEGER;
        }
        if (var instanceof FloatVariable) {
            return UIDataType.FLOAT;
        }
        if (var instanceof DateVariable) {
            return UIDataType.DATE;
        }
        if (var instanceof TimeVariable) {
            return UIDataType.TIME;
        }
        if (var instanceof BooleanVariable) {
            return UIDataType.BOOLEAN;
        }
        if (var instanceof TimeCodeVariable) {
            return UIDataType.TIMECODE;
        }
        return UIDataType.COMPLEX;
    }

    public static synchronized FieldLookupService getInstance() {
        if (service == null) {
            try {
                service = new FieldLookupService();
            }
            catch (RuntimeException e) {
                logger.error((Object)"error initializing FieldLookupService", (Throwable)e);
                throw e;
            }
        }
        return service;
    }

    public FieldInfo getDisplayName(FieldType fieldType, String sectionType, String field) {
        if (sectionType == null) {
            sectionType = "";
        }
        if (field == null) {
            field = "";
        }
        if (sectionType.startsWith("NEW/")) {
            sectionType = sectionType.substring(4);
        }
        if (fieldType.equals((Object)FieldType.LICENSE)) {
            return this.getLicensingDisplayName(field);
        }
        if (fieldType.equals((Object)FieldType.ENHANCEMENT)) {
            return this.enhancementFieldDisplayNameLookup.get(FieldLookupService.getDisplayNamekey(fieldType, sectionType, field));
        }
        if (field.startsWith("/Fields/CustomFields") && !sectionType.endsWith("/FILE")) {
            return this.customFieldDisplayNameLookup.get(FieldLookupService.getDisplayNamekey(fieldType, sectionType, field));
        }
        logger.debug((Object)("start search for " + field));
        int pos = Collections.binarySearch(this.displayNameLookup, new FieldInfo(fieldType, sectionType, field));
        logger.debug((Object)("end search for " + field));
        if (pos > -1) {
            return this.displayNameLookup.get(pos);
        }
        return null;
    }

    private FieldInfo getLicensingDisplayName(String field) {
        String key = FieldLookupService.getDisplayNamekey(FieldType.LICENSE, "", field);
        if (!this.LicensingFieldDisplayNameLookup.containsKey(key)) {
            this.addLicensingFields();
        }
        return this.LicensingFieldDisplayNameLookup.get(key);
    }

    private static String getDisplayNamekey(FieldType fieldType, String sectionType, String field) {
        StringBuffer sb = new StringBuffer(fieldType.toString());
        if (sectionType != null && !fieldType.equals((Object)FieldType.PMM_TITLE) && !fieldType.equals((Object)FieldType.LICENSE)) {
            sb.append(sectionType);
        }
        if (field != null) {
            sb.append(field);
        }
        return sb.toString();
    }

    public List<FieldInfo> search(String searchStr) {
        Map<Character, SearchNode> currMap = this.searchIndex;
        for (int i = 0; i < searchStr.length(); ++i) {
            Character c = Character.valueOf(searchStr.charAt(i));
            SearchNode node = currMap.get(c);
            if (node == null) {
                return new ArrayList<FieldInfo>(0);
            }
            if (i == searchStr.length() - 1) {
                return node.getResults();
            }
            currMap = node.getChildIndex();
        }
        return new ArrayList<FieldInfo>(0);
    }

    public Date getEnhancementLastUpdateDate() {
        return this.enhancementLastUpdateDate;
    }

    private class CustomFieldUpdateHandler
    implements UISpecificationChangeListener {
        private CustomFieldUpdateHandler() {
        }

        public void afterUpdate(UISpecification.Type type, UISpecification uiSpec) {
        }

        public void afterCustomFieldUpdate(Map<String, List<CustomFieldGroup>> map) {
            FieldLookupService.this.customFieldDisplayNameLookup.clear();
            for (AssetTreeObject assetTreeObject : FieldLookupService.this.assetTreeObjects.values()) {
                Iterator<IFieldTreeObject> iterator = assetTreeObject.getChildren().iterator();
                while (iterator.hasNext()) {
                    IFieldTreeObject fto = iterator.next();
                    if (!fto.getField().startsWith("/Fields/CustomFields")) continue;
                    iterator.remove();
                }
            }
            for (Map.Entry entry : map.entrySet()) {
                boolean seasonAssetExists;
                String assetType = (String)entry.getKey();
                this.afterUpdateHelper(assetType, (List)entry.getValue());
                if (!assetType.startsWith("PACKAGE/")) continue;
                String seriesAssetType = "SERIES" + assetType.substring(7);
                String seasonAssetType = "SERIES/SEASON" + assetType.substring(7);
                boolean seriesAssetExists = Collections.binarySearch(FieldLookupService.this.displayNameLookup, new FieldInfo(FieldType.ASSET, seriesAssetType, null)) > -1;
                boolean bl = seasonAssetExists = Collections.binarySearch(FieldLookupService.this.displayNameLookup, new FieldInfo(FieldType.ASSET, seasonAssetType, null)) > -1;
                if (!map.containsKey(seriesAssetType) && seriesAssetExists) {
                    this.afterUpdateHelper(seriesAssetType, (List)entry.getValue());
                }
                if (map.containsKey(seasonAssetType) || !seasonAssetExists) continue;
                this.afterUpdateHelper(seasonAssetType, (List)entry.getValue());
            }
            FieldLookupService.this.mdmTreeUpdateDate = new Date();
        }

        private void afterUpdateHelper(String assetType, List<CustomFieldGroup> groups) {
            FieldInfo assetInfo = FieldLookupService.this.getDisplayName(FieldType.ASSET, assetType, "");
            AssetTreeObject ato = (AssetTreeObject)FieldLookupService.this.assetTreeObjects.get(assetType);
            String assetDisplayName = assetInfo.getDisplayName();
            String assetFullDisplayName = assetInfo.getFullDisplayName();
            for (CustomFieldGroup group : groups) {
                AssetFieldTreeObject groupObj = new AssetFieldTreeObject("/Fields/CustomFields", UIDataType.COMPLEX, assetType, assetDisplayName + "." + group.displayName, null, assetFullDisplayName + "." + group.displayName);
                ato.addChild(groupObj);
                for (CustomField field : group.fields) {
                    String identifier = "/Fields/CustomFields/CustomField[@name=" + field.name + "]/@value";
                    UIDataType dataType = UIDataType.fromValue(field.dataType.name().toLowerCase());
                    String fullDisplayName = assetFullDisplayName + "." + group.displayName + "." + field.displayName;
                    String displayName = assetDisplayName + "." + field.displayName;
                    FieldInfo fieldInfo = new FieldInfo(FieldType.ASSET, assetType, identifier, fullDisplayName, displayName, dataType, "CustomFieldType");
                    FieldLookupService.this.customFieldDisplayNameLookup.put(fieldInfo.getKey(), fieldInfo);
                    AssetFieldTreeObject afto = new AssetFieldTreeObject(identifier, dataType, assetType, displayName, null, fullDisplayName);
                    groupObj.addChild(afto);
                }
            }
        }
    }

    public class FieldInfo
    implements Comparable<FieldInfo> {
        private String key;
        private FieldType fieldType;
        private String sectionType;
        private String field;
        private String fullDisplayName;
        private String displayName;
        private UIDataType dataType;
        private String complexType;

        public FieldInfo(FieldType fieldType, String sectionType, String field, String fullDisplayName, String displayName, UIDataType dataType, String complexType) {
            this.fieldType = fieldType;
            this.sectionType = sectionType;
            this.field = field;
            this.setFullDisplayName(fullDisplayName);
            this.setDisplayName(displayName);
            this.setDataType(dataType);
            this.complexType = complexType;
            this.key = FieldLookupService.getDisplayNamekey(fieldType, sectionType, field);
        }

        public FieldInfo(FieldType fieldType, String sectionType, String field) {
            this.key = FieldLookupService.getDisplayNamekey(fieldType, sectionType, field);
        }

        public FieldType getFieldType() {
            return this.fieldType;
        }

        public void setFieldType(FieldType fieldType) {
            this.fieldType = fieldType;
        }

        public String getSectionType() {
            return this.sectionType;
        }

        public void setSectionType(String sectionType) {
            this.sectionType = sectionType;
        }

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public String getFullDisplayName() {
            return this.fullDisplayName;
        }

        public void setFullDisplayName(String fullDisplayName) {
            this.fullDisplayName = fullDisplayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public UIDataType getDataType() {
            return this.dataType;
        }

        public void setDataType(UIDataType dataType) {
            this.dataType = dataType;
        }

        private String getKey() {
            return this.key;
        }

        public boolean equals(Object obj) {
            if (obj instanceof FieldInfo) {
                return this.key.equals(((FieldInfo)obj).key);
            }
            return false;
        }

        @Override
        public int compareTo(FieldInfo o) {
            return this.key.compareTo(o.key);
        }

        public String getComplexType() {
            return this.complexType;
        }
    }

    private static class SearchNode {
        private Map<Character, SearchNode> childIndex = new HashMap<Character, SearchNode>();
        private List<FieldInfo> results = new ArrayList<FieldInfo>();

        public SearchNode(FieldInfo firstResult) {
            this.results.add(firstResult);
        }

        public List<FieldInfo> getResults() {
            return this.results;
        }

        public void addResult(FieldInfo result) {
            this.results.add(result);
        }

        public Map<Character, SearchNode> getChildIndex() {
            return this.childIndex;
        }
    }
}

