/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.server.specification;

import com.tandbergtv.cms.contentmgmt.service.specification.IAssetSpecificationManager;
import com.tandbergtv.cms.portal.ui.title.server.specification.ITitleMetadataHelper;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.workflow.web.table.Column;
import com.tandbergtv.workflow.web.table.Table;
import java.util.ArrayList;
import java.util.List;

public class TitleMetadataHelper
implements ITitleMetadataHelper {
    private IAssetSpecificationManager specManager = (IAssetSpecificationManager)InjectionUtil.injectInstance((String)"cms/AssetSpecificationManager/local", IAssetSpecificationManager.class);

    @Override
    public List<Field> getMetadataByTitle(Title title, String tableName) {
        if (title == null) {
            throw new RuntimeException("Title does not exist.");
        }
        return this.getMetadata(title, this.getTable(tableName));
    }

    @Override
    public List<Field> getMetadataByTitleID(long titleId, String tableName) {
        ITitleManager titleManager = (ITitleManager)InjectionUtil.injectInstance((String)"cms/TitleManagerProxy/local", ITitleManager.class);
        Title title = titleManager.get(Long.valueOf(titleId));
        return this.getMetadataByTitle(title, tableName);
    }

    private Table getTable(String tableName) {
        return this.specManager.getTableConfiguration(tableName);
    }

    private List<Field> getMetadata(Title title, Table table) {
        ArrayList<Field> fields = new ArrayList<Field>();
        List columns = table.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            Column col = (Column)columns.get(i);
            Field metadataField = this.getMetadataField(title.getAsset(), col);
            if (metadataField != null) {
                fields.add(metadataField);
                continue;
            }
            fields.add(new Field(col.getParameter(), ""));
        }
        return fields;
    }

    private Field getMetadataField(Asset asset, Column col) {
        for (Field f : asset.getAllDescendantAssetFields()) {
            if (!f.getTtvXPath().equalsIgnoreCase(col.getParameter()) || !f.getParentAsset().getPath().equalsIgnoreCase(col.getTitleSection())) continue;
            return f;
        }
        return null;
    }
}

