/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.server.specification;

import com.tandbergtv.cms.portal.ui.title.client.model.datatype.BooleanDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.DateDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.FloatDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.IUIFieldDataTypeVisitor;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.IntegerDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.StringDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.TimeCodeDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.TimeDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataTypeProvider;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetFileDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetFileFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIBooleanFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIDateFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIFloatFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIIntegerFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UISimpleFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIStringFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UITimeCodeFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UITimeFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;
import com.tandbergtv.cms.portal.ui.title.server.specification.IUIValueOptionProvider;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleConf;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

class UIAssetFileDefinitionBuilder {
    private static final String FILE_FIELD_KEYS = "FieldDefinitionKeys";
    private static final String VALUE_SEPARATOR = ",";
    private static final String KEY_SEPARATOR = ".";
    private static final String FIELD_DATATYPE_KEY = "DataType";
    private static final String FIELD_NAME_KEY = "Name";
    private static final String FIELD_DISPLAYNAME_KEY = "DisplayName";
    private static final String FIELD_ANYVALUEALLOWED_KEY = "AnyValueAllowed";
    private static final String FIELD_DISPLAYFORMAT_KEY = "DisplayFormat";
    private static final String FIELD_OPTIONPROVIDER_KEY = "OptionProvider";
    private static final String FIELD_OPTIONKEYS_KEY = "OptionKeys";
    private static final String OPTION_KEY_PREFIX = ".OptionKey.";
    private static final String FIELD_OPTIONKEY_NAME = "Name";
    private static final String FIELD_OPTIONKEY_VALUE = "Value";
    private ResourceBundle configurationBundle;
    private ResourceBundle localizationBundle;
    private final Map<String, UIFieldDataType> datatypes;
    private UIFieldDataType defaultDataType = new StringDataType();

    public UIAssetFileDefinitionBuilder() {
        this.configurationBundle = ResourceBundle.getBundle(this.getClass().getName());
        this.localizationBundle = ResourceBundle.getBundle(this.getClass().getName() + "Keys");
        this.datatypes = new UIFieldDataTypeProvider().getAll();
    }

    public UIAssetFileDefinition build(TitleConf titleConf) {
        UIAssetFileDefinition definition = new UIAssetFileDefinition();
        this.buildFieldDefinitions(titleConf, definition);
        return definition;
    }

    private void buildFieldDefinitions(TitleConf titleConf, UIAssetFileDefinition definition) {
        List<String> fieldDefinitionKeys = this.getFieldDefinitionKeys(titleConf);
        for (String key : fieldDefinitionKeys) {
            UIAssetFileFieldDefinition fieldDefinition = new UIAssetFileFieldDefinition();
            fieldDefinition.setFieldDefinition(this.buildFieldDefinition(key));
            definition.addFieldDefinition(fieldDefinition);
        }
    }

    private UISimpleFieldDefinition buildFieldDefinition(String key) {
        String defaultTypeName = this.defaultDataType.getName();
        String dataTypeName = this.getFieldDefinitionProperty(key, FIELD_DATATYPE_KEY, defaultTypeName);
        UIFieldDataType dataType = this.datatypes.get(dataTypeName);
        FieldDefinitionBuilder builder = new FieldDefinitionBuilder();
        return builder.build(key, dataType);
    }

    private String getFieldDefinitionProperty(String fieldDefinitionKey, String suffix) {
        String key = fieldDefinitionKey + KEY_SEPARATOR + suffix;
        return this.configurationBundle.getString(key);
    }

    private String getFieldDefinitionProperty(String fieldDefinitionKey, String suffix, String defaultValue) {
        String value = null;
        String key = fieldDefinitionKey + KEY_SEPARATOR + suffix;
        try {
            value = this.configurationBundle.getString(key);
        }
        catch (MissingResourceException mre) {
            value = defaultValue;
        }
        return value;
    }

    private List<String> getFieldDefinitionKeys(TitleConf titleConf) {
        String[] values;
        String specificKeyName;
        ArrayList<String> keys = new ArrayList<String>();
        String keyName = FILE_FIELD_KEYS;
        String assetType = titleConf.getName();
        if (assetType != null && assetType.length() > 0 && this.configurationBundle.containsKey(specificKeyName = keyName + KEY_SEPARATOR + assetType)) {
            keyName = specificKeyName;
        }
        String keyValue = this.configurationBundle.getString(keyName);
        for (String value : values = keyValue.split(VALUE_SEPARATOR)) {
            if (value == null || value.trim().length() <= 0) continue;
            keys.add(value.trim());
        }
        return keys;
    }

    private String getLocalizedValue(String key) {
        String localizedValue = key;
        try {
            localizedValue = this.localizationBundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return localizedValue;
    }

    private List<UIValueOption> loadOptions(String providerClass) {
        Object providerInstance = null;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = classLoader.loadClass(providerClass);
            providerInstance = clazz.newInstance();
        }
        catch (Exception e) {
            String msg = "Failed to load option provider class: " + providerClass;
            throw new RuntimeException(msg, e);
        }
        if (!(providerInstance instanceof IUIValueOptionProvider)) {
            String className = IUIValueOptionProvider.class.getName();
            String msg = "The option provider class: " + providerClass + " does not implement interface: " + className;
            throw new RuntimeException(msg);
        }
        IUIValueOptionProvider provider = providerInstance;
        return provider.getOptions();
    }

    private class FieldDefinitionBuilder
    implements IUIFieldDataTypeVisitor {
        private String key;
        private UISimpleFieldDefinition builtDefinition = null;

        private FieldDefinitionBuilder() {
        }

        public UISimpleFieldDefinition build(String key, UIFieldDataType dataType) {
            this.key = key;
            dataType.accept(this);
            return this.getBuiltDefinition();
        }

        private UISimpleFieldDefinition getBuiltDefinition() {
            UISimpleFieldDefinition definition = this.builtDefinition;
            this.key = null;
            this.builtDefinition = null;
            return definition;
        }

        @Override
        public void visit(BooleanDataType datatype) {
            UIBooleanFieldDefinition definition = new UIBooleanFieldDefinition();
            this.buildDefinition(definition);
            this.addOptions(definition);
            this.builtDefinition = definition;
        }

        @Override
        public void visit(IntegerDataType datatype) {
            UIIntegerFieldDefinition definition = new UIIntegerFieldDefinition();
            this.buildDefinition(definition);
            this.addOptions(definition);
            this.builtDefinition = definition;
        }

        @Override
        public void visit(FloatDataType datatype) {
            UIFloatFieldDefinition definition = new UIFloatFieldDefinition();
            this.buildDefinition(definition);
            this.addOptions(definition);
            this.builtDefinition = definition;
        }

        @Override
        public void visit(DateDataType datatype) {
            UIDateFieldDefinition definition = new UIDateFieldDefinition();
            this.buildDefinition(definition);
            this.addOptions(definition);
            String format = UIAssetFileDefinitionBuilder.this.getFieldDefinitionProperty(this.key, UIAssetFileDefinitionBuilder.FIELD_DISPLAYFORMAT_KEY, null);
            definition.setDisplayFormat(format);
            this.builtDefinition = definition;
        }

        @Override
        public void visit(TimeDataType datatype) {
            UITimeFieldDefinition definition = new UITimeFieldDefinition();
            this.buildDefinition(definition);
            this.addOptions(definition);
            String format = UIAssetFileDefinitionBuilder.this.getFieldDefinitionProperty(this.key, UIAssetFileDefinitionBuilder.FIELD_DISPLAYFORMAT_KEY, null);
            definition.setDisplayFormat(format);
            this.builtDefinition = definition;
        }

        @Override
        public void visit(StringDataType datatype) {
            UIStringFieldDefinition definition = new UIStringFieldDefinition();
            this.buildDefinition(definition);
            this.addOptions(definition);
            definition.setLongForm(false);
            this.builtDefinition = definition;
        }

        @Override
        public void visit(TimeCodeDataType datatype) {
            UITimeCodeFieldDefinition definition = new UITimeCodeFieldDefinition();
            this.buildDefinition(definition);
            this.addOptions(definition);
            String format = UIAssetFileDefinitionBuilder.this.getFieldDefinitionProperty(this.key, UIAssetFileDefinitionBuilder.FIELD_DISPLAYFORMAT_KEY, null);
            definition.setDisplayFormat(format);
            this.builtDefinition = definition;
        }

        private void addOptions(UISimpleFieldDefinition definition) {
            List<String> optionKeyList;
            String optionProvider = UIAssetFileDefinitionBuilder.this.getFieldDefinitionProperty(this.key, UIAssetFileDefinitionBuilder.FIELD_OPTIONPROVIDER_KEY, null);
            String optionKeys = UIAssetFileDefinitionBuilder.this.getFieldDefinitionProperty(this.key, UIAssetFileDefinitionBuilder.FIELD_OPTIONKEYS_KEY, null);
            if (optionProvider != null) {
                List options = UIAssetFileDefinitionBuilder.this.loadOptions(optionProvider);
                definition.setSuggestedValues(options);
            } else if (optionKeys != null && !(optionKeyList = this.getOptionKeys(optionKeys)).isEmpty()) {
                ArrayList<UIValueOption> options = new ArrayList<UIValueOption>();
                for (String optionKey : optionKeyList) {
                    String name = UIAssetFileDefinitionBuilder.this.getFieldDefinitionProperty(optionKey, "Name");
                    String displayName = UIAssetFileDefinitionBuilder.this.getLocalizedValue(name);
                    String value = UIAssetFileDefinitionBuilder.this.getFieldDefinitionProperty(optionKey, UIAssetFileDefinitionBuilder.FIELD_OPTIONKEY_VALUE);
                    UIValueOption option = new UIValueOption(displayName, value);
                    options.add(option);
                }
                definition.setSuggestedValues(options);
            }
        }

        private void buildDefinition(UISimpleFieldDefinition definition) {
            String name = UIAssetFileDefinitionBuilder.this.getFieldDefinitionProperty(this.key, "Name");
            String displayName = UIAssetFileDefinitionBuilder.this.getFieldDefinitionProperty(this.key, UIAssetFileDefinitionBuilder.FIELD_DISPLAYNAME_KEY);
            String anyValueAllowed = UIAssetFileDefinitionBuilder.this.getFieldDefinitionProperty(this.key, UIAssetFileDefinitionBuilder.FIELD_ANYVALUEALLOWED_KEY, "true");
            definition.setName(name);
            definition.setDisplayName(UIAssetFileDefinitionBuilder.this.getLocalizedValue(displayName));
            definition.setXPath(name);
            definition.setAnyValueAllowed(Boolean.parseBoolean(anyValueAllowed));
            definition.setAttribute(false);
        }

        private List<String> getOptionKeys(String keys) {
            String[] keyValues;
            ArrayList<String> optionKeys = new ArrayList<String>();
            for (String keyValue : keyValues = keys.split(UIAssetFileDefinitionBuilder.VALUE_SEPARATOR)) {
                if (keyValue == null || keyValue.trim().length() <= 0) continue;
                String optionKey = this.key + UIAssetFileDefinitionBuilder.OPTION_KEY_PREFIX + keyValue.trim();
                optionKeys.add(optionKey);
            }
            return optionKeys;
        }
    }
}

