/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.server.specification;

import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetFileDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecification;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecificationListItem;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIBooleanFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIComplexFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIDateFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIFloatFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIGroupAssetDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIIntegerFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIItemAssetDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UISimpleFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIStringFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UITimeCodeFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UITimeFieldDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;
import com.tandbergtv.cms.portal.ui.title.server.specification.IUIAssetSpecificationBuilder;
import com.tandbergtv.cms.portal.ui.title.server.specification.UIAssetFileDefinitionBuilder;
import com.tandbergtv.content.contentclass.entities.ContentClassAsset;
import com.tandbergtv.content.contentclass.entities.ContentClassField;
import com.tandbergtv.content.contentclass.entities.ContentClassMetadata;
import com.tandbergtv.content.contentclass.entities.ContentClassOption;
import com.tandbergtv.watchpoint.pmm.title.conf.BooleanVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.ComplexVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.CustomField;
import com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup;
import com.tandbergtv.watchpoint.pmm.title.conf.DateVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.FloatVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.IVariableOptionProvider;
import com.tandbergtv.watchpoint.pmm.title.conf.IntegerVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.SimpleVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.watchpoint.pmm.title.conf.StringVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.TimeCodeVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.TimeVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleConf;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleConfMetadata;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecification;
import com.tandbergtv.watchpoint.pmm.title.conf.Variable;
import com.tandbergtv.watchpoint.pmm.title.conf.VariableOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class UIAssetSpecificationBuilder
implements IUIAssetSpecificationBuilder {
    private static Logger logger = Logger.getLogger(UIAssetSpecificationBuilder.class);

    @Override
    public UIAssetSpecification build(UISpecification specification) {
        UIAssetSpecification uiSpecification = new UIAssetSpecification();
        TitleConf root = specification.getRootTitleConf();
        UIAssetDefinition assetDefinition = this.buildAssetDefinition(root);
        if (assetDefinition != null) {
            uiSpecification.addAssetDefinition(assetDefinition);
        }
        return uiSpecification;
    }

    @Override
    public UIAssetSpecification build(UISpecification specification, ContentClassMetadata ccMetadata) {
        UIAssetSpecification uiSpecification = new UIAssetSpecification();
        TitleConf root = specification.getRootTitleConf();
        UIAssetDefinition assetDefinition = this.buildAssetDefinition(root, ccMetadata);
        if (assetDefinition != null) {
            uiSpecification.addAssetDefinition(assetDefinition);
        }
        return uiSpecification;
    }

    @Override
    public UIAssetSpecificationListItem buildListItem(Specification specification) {
        UIAssetSpecificationListItem listItem = new UIAssetSpecificationListItem();
        listItem.setName(specification.getName());
        listItem.setDisplayName(specification.getName());
        return listItem;
    }

    private UIAssetDefinition buildAssetDefinition(TitleConf titleConf, ContentClassMetadata ccMetadata) {
        UIAssetDefinition assetDefinition = null;
        ContentClassAsset ccAsset = null;
        if (ccMetadata != null) {
            ccAsset = ccMetadata.getAsset(titleConf.getPath());
        }
        if (ccAsset == null || ccAsset.isDisabled()) {
            return null;
        }
        if (titleConf.hasChildren()) {
            UIGroupAssetDefinition groupDefinition = new UIGroupAssetDefinition();
            groupDefinition.setAssetType(titleConf.getName());
            groupDefinition.setPath(titleConf.getPath());
            for (Object childTitleConf : titleConf.getChildren()) {
                UIAssetDefinition child = this.buildAssetDefinition((TitleConf)childTitleConf, ccMetadata);
                if (child == null) continue;
                groupDefinition.addChild(child);
            }
            assetDefinition = groupDefinition;
        } else {
            UIItemAssetDefinition itemDefinition = new UIItemAssetDefinition();
            itemDefinition.setAssetType(titleConf.getName());
            itemDefinition.setPath(titleConf.getPath());
            assetDefinition = itemDefinition;
        }
        assetDefinition.setDisplayName(titleConf.getAlias());
        if (ccAsset != null) {
            assetDefinition.setMaximumCount(ccAsset.getMax());
            assetDefinition.setMinimumCount(ccAsset.getMin());
            assetDefinition.setBatchMaximumCount(ccAsset.getBatchMax());
            assetDefinition.setBatchMinimumCount(ccAsset.getBatchMin());
            assetDefinition.setFilesAllowed(ccAsset.isRequiresFile());
            assetDefinition.setHideFileView(ccAsset.isHideFileView());
        }
        UIComplexFieldDefinition rootFieldDefinition = assetDefinition.getRootFieldDefinition();
        TitleConfMetadata metadata = titleConf.getTitleConfMetadata();
        if (metadata != null && metadata.coreFields != null) {
            for (Variable variable : metadata.coreFields) {
                UIFieldDefinition fieldDefinition;
                if ("CustomFields".equals(variable.getName()) || (fieldDefinition = this.buildFieldDefinition(variable, ccAsset)) == null) continue;
                fieldDefinition.setAssetDefinition(assetDefinition);
                rootFieldDefinition.addChild(fieldDefinition);
            }
        }
        if (metadata != null && metadata.customFields != null) {
            for (CustomFieldGroup cfGroup : metadata.customFields.getGroups()) {
                String groupXPath;
                ContentClassField ccGroup;
                if (cfGroup.fields == null || cfGroup.fields.isEmpty() || (ccGroup = ccAsset.getField(groupXPath = "/Fields/CustomFields;" + cfGroup.groupId)) == null || ccGroup.isDisabled()) continue;
                UIComplexFieldDefinition groupDef = new UIComplexFieldDefinition();
                groupDef.setName("CustomFields");
                groupDef.setXPath("/Fields/CustomFields");
                groupDef.setDisplayName(cfGroup.displayName);
                for (CustomField cf : cfGroup.fields) {
                    UIFieldDefinition fieldDef = this.buildCustomField(cf, ccAsset);
                    if (fieldDef == null) continue;
                    groupDef.addChild(fieldDef);
                }
                if (!groupDef.hasChildren()) continue;
                rootFieldDefinition.addChild(groupDef);
            }
        }
        UIAssetFileDefinition fileDefinition = this.buildFileDefinition(titleConf);
        assetDefinition.setFileDefinition(fileDefinition);
        return assetDefinition;
    }

    private UIFieldDefinition buildCustomField(CustomField cf, ContentClassAsset ccAsset) {
        ContentClassField.FieldType fieldType;
        String parentXpath = "/Fields/CustomFields/CustomField[@name=" + cf.name + "]";
        String xpath = parentXpath + "/@value";
        ContentClassField ccField = ccAsset.getField(xpath);
        if (ccField == null || ccField.isDisabled()) {
            return null;
        }
        UIFieldDefinition def = null;
        switch (cf.dataType) {
            case BOOLEAN: {
                def = new UIBooleanFieldDefinition();
                break;
            }
            case DATE: {
                def = new UIDateFieldDefinition();
                ((UIDateFieldDefinition)def).setDisplayFormat(ccField.getDisplayPattern());
                break;
            }
            case FLOAT: {
                def = new UIFloatFieldDefinition();
                break;
            }
            case INTEGER: {
                def = new UIIntegerFieldDefinition();
                break;
            }
            case STRING: {
                def = new UIStringFieldDefinition();
                fieldType = null;
                if (ccField != null) {
                    fieldType = ccField.getFieldType();
                }
                if (ccField == null || fieldType == null) {
                    ((UIStringFieldDefinition)def).setLongForm(cf.multiLine);
                    break;
                }
                ((UIStringFieldDefinition)def).setLongForm(fieldType == ContentClassField.FieldType.TEXT_AREA);
                break;
            }
            case TIME: {
                def = new UITimeFieldDefinition();
                ((UITimeFieldDefinition)def).setDisplayFormat(ccField.getDisplayPattern());
            }
        }
        def.setName("value");
        def.setXPath(xpath);
        def.setDisplayName(cf.displayName);
        ((UISimpleFieldDefinition)def).setAttribute(true);
        ((UISimpleFieldDefinition)def).setDefaultValue(ccField.getDefaultValue());
        ((UISimpleFieldDefinition)def).setHideInUI(ccField.hideInUIOnly());
        ((UISimpleFieldDefinition)def).setLocked(ccField.isLocked());
        ((UISimpleFieldDefinition)def).setBatch(ccField.getIncludeInBatch());
        ((UISimpleFieldDefinition)def).setAutoFillable(ccField.isAutofillable());
        ((UISimpleFieldDefinition)def).setRequired(ccField.isRequired());
        if (ccField != null && ccField.getFieldType() != null) {
            fieldType = ccField.getFieldType();
            ((UISimpleFieldDefinition)def).setAnyValueAllowed(fieldType == ContentClassField.FieldType.COMBO_BOX);
            if (fieldType == ContentClassField.FieldType.DROP_DOWN || fieldType == ContentClassField.FieldType.COMBO_BOX) {
                List<UIValueOption> options = this.createOptions(cf, ccField);
                ((UISimpleFieldDefinition)def).setSuggestedValues(options);
            }
        } else if (cf.dropDown) {
            ((UISimpleFieldDefinition)def).setAnyValueAllowed(cf.anyValueAllowed);
            List<UIValueOption> options = this.createOptions(cf, ccField);
            ((UISimpleFieldDefinition)def).setSuggestedValues(options);
        }
        UIComplexFieldDefinition parentDef = new UIComplexFieldDefinition();
        parentDef.setXPath(parentXpath);
        parentDef.setName("CustomField[@name=" + cf.name + "]");
        parentDef.setShowCollapsed(true);
        parentDef.addChild(def);
        if (cf.multiValue) {
            parentDef.setMinimumCount(ccField == null || ccField.getMin() == null ? 1 : ccField.getMin());
            parentDef.setMaximumCount(ccField == null || ccField.getMax() == null ? -1 : ccField.getMax());
            parentDef.setShowCollapsed(false);
        } else {
            parentDef.setMinimumCount(1);
            parentDef.setMaximumCount(1);
        }
        return parentDef;
    }

    private UIFieldDefinition buildCustomField(CustomField cf) {
        String parentXpath = "/Fields/CustomFields/CustomField[@name=" + cf.name + "]";
        String xpath = parentXpath + "/@value";
        UIFieldDefinition def = null;
        switch (cf.dataType) {
            case BOOLEAN: {
                def = new UIBooleanFieldDefinition();
                break;
            }
            case DATE: {
                def = new UIDateFieldDefinition();
                break;
            }
            case FLOAT: {
                def = new UIFloatFieldDefinition();
                break;
            }
            case INTEGER: {
                def = new UIIntegerFieldDefinition();
                break;
            }
            case STRING: {
                def = new UIStringFieldDefinition();
                ((UIStringFieldDefinition)def).setLongForm(cf.multiLine);
                break;
            }
            case TIME: {
                def = new UITimeFieldDefinition();
            }
        }
        def.setName("value");
        def.setXPath(xpath);
        def.setDisplayName(cf.displayName);
        ((UISimpleFieldDefinition)def).setAttribute(true);
        UIComplexFieldDefinition parentDef = new UIComplexFieldDefinition();
        parentDef.setXPath(parentXpath);
        parentDef.setName("CustomField[@name=" + cf.name + "]");
        parentDef.setShowCollapsed(true);
        parentDef.addChild(def);
        return parentDef;
    }

    private UIAssetDefinition buildAssetDefinition(TitleConf titleConf) {
        UIAssetDefinition assetDefinition = null;
        if (titleConf.hasChildren()) {
            UIGroupAssetDefinition groupDefinition = new UIGroupAssetDefinition();
            groupDefinition.setAssetType(titleConf.getName());
            groupDefinition.setPath(titleConf.getPath());
            for (Object childTitleConf : titleConf.getChildren()) {
                UIAssetDefinition child = this.buildAssetDefinition((TitleConf)childTitleConf);
                if (child == null) continue;
                groupDefinition.addChild(child);
            }
            assetDefinition = groupDefinition;
        } else {
            UIItemAssetDefinition itemDefinition = new UIItemAssetDefinition();
            itemDefinition.setAssetType(titleConf.getName());
            itemDefinition.setPath(titleConf.getPath());
            assetDefinition = itemDefinition;
        }
        assetDefinition.setDisplayName(titleConf.getAlias());
        UIComplexFieldDefinition rootFieldDefinition = assetDefinition.getRootFieldDefinition();
        TitleConfMetadata metadata = titleConf.getTitleConfMetadata();
        if (metadata != null && metadata.coreFields != null) {
            for (Variable variable : metadata.coreFields) {
                UIFieldDefinition fieldDefinition;
                if ("CustomFields".equals(variable.getName()) || (fieldDefinition = this.buildFieldDefinition(variable)) == null) continue;
                fieldDefinition.setAssetDefinition(assetDefinition);
                rootFieldDefinition.addChild(fieldDefinition);
            }
        }
        if (metadata != null && metadata.customFields != null) {
            for (CustomFieldGroup cfGroup : metadata.customFields.getGroups()) {
                if (cfGroup.fields == null || cfGroup.fields.isEmpty()) continue;
                String groupXPath = "/Fields/CustomFields;" + cfGroup.groupId;
                UIComplexFieldDefinition groupDef = new UIComplexFieldDefinition();
                groupDef.setName("CustomFields");
                groupDef.setXPath("/Fields/CustomFields");
                groupDef.setDisplayName(cfGroup.displayName);
                for (CustomField cf : cfGroup.fields) {
                    UIFieldDefinition fieldDef = this.buildCustomField(cf);
                    if (fieldDef == null) continue;
                    groupDef.addChild(fieldDef);
                }
                if (!groupDef.hasChildren()) continue;
                rootFieldDefinition.addChild(groupDef);
            }
        }
        UIAssetFileDefinition fileDefinition = this.buildFileDefinition(titleConf);
        assetDefinition.setFileDefinition(fileDefinition);
        return assetDefinition;
    }

    private UIFieldDefinition buildFieldDefinition(Variable variable, ContentClassAsset ccAsset) {
        if (variable == null) {
            return null;
        }
        UIFieldDefinition fieldDefinition = null;
        ContentClassField ccField = null;
        if (ccAsset != null) {
            ccField = ccAsset.getField(variable.getXPath());
        }
        if (variable instanceof ComplexVariable) {
            if (ccField == null || ccField.isDisabled()) {
                return null;
            }
            ComplexVariable complexVariable = (ComplexVariable)variable;
            UIComplexFieldDefinition definition = new UIComplexFieldDefinition();
            definition.setShowCollapsed(complexVariable.isShowCollapsed());
            definition.setArtificial(complexVariable.isArtificial());
            for (Variable childVariable : complexVariable.getChildren()) {
                UIFieldDefinition childDefinition = this.buildFieldDefinition(childVariable, ccAsset);
                if (childDefinition == null) continue;
                definition.addChild(childDefinition);
            }
            if (!definition.hasChildren()) {
                return null;
            }
            fieldDefinition = definition;
        } else if (variable instanceof BooleanVariable) {
            if (ccField == null || ccField.isDisabled()) {
                return null;
            }
            BooleanVariable booleanVariable = (BooleanVariable)variable;
            UIBooleanFieldDefinition definition = new UIBooleanFieldDefinition();
            this.buildSimpleFieldDefinition(definition, (SimpleVariable)booleanVariable, ccField);
            fieldDefinition = definition;
        } else if (variable instanceof IntegerVariable) {
            if (ccField == null || ccField.isDisabled()) {
                return null;
            }
            IntegerVariable integerVariable = (IntegerVariable)variable;
            UIIntegerFieldDefinition definition = new UIIntegerFieldDefinition();
            this.buildSimpleFieldDefinition(definition, (SimpleVariable)integerVariable, ccField);
            fieldDefinition = definition;
        } else if (variable instanceof FloatVariable) {
            if (ccField == null || ccField.isDisabled()) {
                return null;
            }
            FloatVariable floatVariable = (FloatVariable)variable;
            UIFloatFieldDefinition definition = new UIFloatFieldDefinition();
            this.buildSimpleFieldDefinition(definition, (SimpleVariable)floatVariable, ccField);
            fieldDefinition = definition;
        } else if (variable instanceof DateVariable) {
            if (ccField == null || ccField.isDisabled()) {
                return null;
            }
            DateVariable dateVariable = (DateVariable)variable;
            UIDateFieldDefinition definition = new UIDateFieldDefinition();
            this.buildSimpleFieldDefinition(definition, (SimpleVariable)dateVariable, ccField);
            if (ccField != null) {
                definition.setDisplayFormat(ccField.getDisplayPattern());
            }
            fieldDefinition = definition;
        } else if (variable instanceof TimeVariable) {
            if (ccField == null || ccField.isDisabled()) {
                return null;
            }
            TimeVariable timeVariable = (TimeVariable)variable;
            UITimeFieldDefinition definition = new UITimeFieldDefinition();
            this.buildSimpleFieldDefinition(definition, (SimpleVariable)timeVariable, ccField);
            if (ccField != null) {
                definition.setDisplayFormat(ccField.getDisplayPattern());
            }
            fieldDefinition = definition;
        } else if (variable instanceof StringVariable) {
            if (ccField == null || ccField.isDisabled()) {
                return null;
            }
            StringVariable stringVariable = (StringVariable)variable;
            UIStringFieldDefinition definition = new UIStringFieldDefinition();
            this.buildSimpleFieldDefinition(definition, (SimpleVariable)stringVariable, ccField);
            ContentClassField.FieldType fieldType = null;
            if (ccField != null) {
                fieldType = ccField.getFieldType();
            }
            if (ccField == null || fieldType == null) {
                definition.setLongForm(stringVariable.isLongFormat());
            } else {
                definition.setLongForm(fieldType == ContentClassField.FieldType.TEXT_AREA);
            }
            fieldDefinition = definition;
        } else if (variable instanceof TimeCodeVariable) {
            if (ccField == null || ccField.isDisabled()) {
                return null;
            }
            TimeCodeVariable tcVariable = (TimeCodeVariable)variable;
            UITimeCodeFieldDefinition definition = new UITimeCodeFieldDefinition();
            this.buildSimpleFieldDefinition(definition, (SimpleVariable)tcVariable, ccField);
            if (ccField != null) {
                definition.setDisplayFormat(ccField.getDisplayPattern());
            }
            fieldDefinition = definition;
        } else {
            return null;
        }
        fieldDefinition.setName(variable.getName());
        fieldDefinition.setDisplayName(variable.getDisplayName());
        fieldDefinition.setXPath(variable.getXPath());
        if (variable.isMultiValue()) {
            fieldDefinition.setMinimumCount(ccField == null || ccField.getMin() == null ? 1 : ccField.getMin());
            fieldDefinition.setMaximumCount(ccField == null || ccField.getMax() == null ? -1 : ccField.getMax());
        } else {
            fieldDefinition.setMinimumCount(1);
            fieldDefinition.setMaximumCount(1);
        }
        return fieldDefinition;
    }

    private UIFieldDefinition buildFieldDefinition(Variable variable) {
        if (variable == null) {
            return null;
        }
        UIFieldDefinition fieldDefinition = null;
        if (variable instanceof ComplexVariable) {
            ComplexVariable complexVariable = (ComplexVariable)variable;
            UIComplexFieldDefinition definition = new UIComplexFieldDefinition();
            definition.setShowCollapsed(complexVariable.isShowCollapsed());
            definition.setArtificial(complexVariable.isArtificial());
            for (Variable childVariable : complexVariable.getChildren()) {
                UIFieldDefinition childDefinition = this.buildFieldDefinition(childVariable);
                if (childDefinition == null) continue;
                definition.addChild(childDefinition);
            }
            fieldDefinition = definition;
        } else if (variable instanceof BooleanVariable) {
            BooleanVariable booleanVariable = (BooleanVariable)variable;
            UIBooleanFieldDefinition definition = new UIBooleanFieldDefinition();
            this.buildSimpleFieldDefinition(definition, (SimpleVariable)booleanVariable, null);
            fieldDefinition = definition;
        } else if (variable instanceof IntegerVariable) {
            IntegerVariable integerVariable = (IntegerVariable)variable;
            UIIntegerFieldDefinition definition = new UIIntegerFieldDefinition();
            this.buildSimpleFieldDefinition(definition, (SimpleVariable)integerVariable, null);
            fieldDefinition = definition;
        } else if (variable instanceof FloatVariable) {
            FloatVariable floatVariable = (FloatVariable)variable;
            UIFloatFieldDefinition definition = new UIFloatFieldDefinition();
            this.buildSimpleFieldDefinition(definition, (SimpleVariable)floatVariable, null);
            fieldDefinition = definition;
        } else if (variable instanceof DateVariable) {
            DateVariable dateVariable = (DateVariable)variable;
            UIDateFieldDefinition definition = new UIDateFieldDefinition();
            this.buildSimpleFieldDefinition(definition, (SimpleVariable)dateVariable, null);
            fieldDefinition = definition;
        } else if (variable instanceof TimeVariable) {
            TimeVariable timeVariable = (TimeVariable)variable;
            UITimeFieldDefinition definition = new UITimeFieldDefinition();
            this.buildSimpleFieldDefinition(definition, (SimpleVariable)timeVariable, null);
            fieldDefinition = definition;
        } else if (variable instanceof StringVariable) {
            StringVariable stringVariable = (StringVariable)variable;
            UIStringFieldDefinition definition = new UIStringFieldDefinition();
            this.buildSimpleFieldDefinition(definition, (SimpleVariable)stringVariable, null);
            definition.setLongForm(stringVariable.isLongFormat());
            fieldDefinition = definition;
        } else if (variable instanceof TimeCodeVariable) {
            TimeCodeVariable tcVariable = (TimeCodeVariable)variable;
            UITimeCodeFieldDefinition definition = new UITimeCodeFieldDefinition();
            this.buildSimpleFieldDefinition(definition, (SimpleVariable)tcVariable, null);
            fieldDefinition = definition;
        } else {
            return null;
        }
        fieldDefinition.setName(variable.getName());
        fieldDefinition.setDisplayName(variable.getDisplayName());
        fieldDefinition.setXPath(variable.getXPath());
        return fieldDefinition;
    }

    private void buildSimpleFieldDefinition(UISimpleFieldDefinition fieldDefinition, SimpleVariable variable, ContentClassField ccField) {
        fieldDefinition.setAttribute(variable.isAttribute());
        fieldDefinition.setAnyValueAllowed(variable.isAnyValueAllowed());
        if (ccField != null) {
            fieldDefinition.setDefaultValue(ccField.getDefaultValue());
            fieldDefinition.setHideInUI(ccField.hideInUIOnly());
            fieldDefinition.setLocked(ccField.isLocked());
            fieldDefinition.setBatch(ccField.getIncludeInBatch());
            fieldDefinition.setAutoFillable(ccField.isAutofillable());
            fieldDefinition.setRequired(ccField.isRequired());
            ContentClassField.FieldType fieldType = ccField.getFieldType();
            if (fieldType != null) {
                fieldDefinition.setAnyValueAllowed(fieldType == ContentClassField.FieldType.COMBO_BOX);
                if (fieldType == ContentClassField.FieldType.COMBO_BOX || fieldType == ContentClassField.FieldType.DROP_DOWN) {
                    List<UIValueOption> options = this.createOptions(variable, ccField);
                    fieldDefinition.setSuggestedValues(options);
                }
            } else {
                List<UIValueOption> options = this.createOptions(variable, ccField);
                fieldDefinition.setSuggestedValues(options);
            }
        } else {
            List<UIValueOption> options = this.createOptions(variable, ccField);
            fieldDefinition.setSuggestedValues(options);
        }
    }

    private UIAssetFileDefinition buildFileDefinition(TitleConf titleConf) {
        UIAssetFileDefinitionBuilder builder = new UIAssetFileDefinitionBuilder();
        return builder.build(titleConf);
    }

    private List<UIValueOption> createOptions(CustomField cf, ContentClassField ccField) {
        if (ccField != null) {
            Set disabledOptionKeys = ccField.getDisabledOptionKeys();
            List ccOptions = ccField.getOptions();
            if (ccOptions != null && !ccOptions.isEmpty()) {
                ArrayList<UIValueOption> list = new ArrayList<UIValueOption>();
                for (ContentClassOption ccOption : ccOptions) {
                    String key = ccOption.getValue();
                    if (disabledOptionKeys != null && disabledOptionKeys.contains(key)) continue;
                    UIValueOption uiOption = new UIValueOption();
                    uiOption.setName(ccOption.getDisplayName());
                    uiOption.setValue(ccOption.getValue());
                    list.add(uiOption);
                }
                return list;
            }
        }
        return null;
    }

    private List<UIValueOption> createOptions(SimpleVariable var, ContentClassField ccField) {
        List ccOptions;
        String optionProvider;
        if (var == null) {
            return null;
        }
        List<VariableOption> options = null;
        Set disabledOptionKeys = null;
        if (ccField != null) {
            disabledOptionKeys = ccField.getDisabledOptionKeys();
        }
        if ((optionProvider = var.getOptionProvider()) != null) {
            options = UIAssetSpecificationBuilder.getProviderOptions(optionProvider);
        } else if (ccField != null && (ccOptions = ccField.getOptions()) != null && !ccOptions.isEmpty()) {
            ArrayList<UIValueOption> list = new ArrayList<UIValueOption>();
            for (ContentClassOption ccOption : ccOptions) {
                String key = ccOption.getValue();
                if (disabledOptionKeys != null && disabledOptionKeys.contains(key)) continue;
                UIValueOption uiOption = new UIValueOption();
                uiOption.setName(ccOption.getDisplayName());
                uiOption.setValue(ccOption.getValue());
                list.add(uiOption);
            }
            return list;
        }
        if (options != null) {
            ArrayList<UIValueOption> list = new ArrayList<UIValueOption>();
            for (VariableOption option : options) {
                String key = option.getValue();
                if (disabledOptionKeys != null && disabledOptionKeys.contains(key)) continue;
                UIValueOption uiOption = new UIValueOption();
                uiOption.setName(option.getName());
                uiOption.setValue(option.getValue());
                list.add(uiOption);
            }
            return list;
        }
        return null;
    }

    public static List<VariableOption> getProviderOptions(String className) {
        try {
            ClassLoader classloader = UIAssetSpecificationBuilder.class.getClassLoader();
            Class<?> providerClass = classloader.loadClass(className);
            Object obj = providerClass.newInstance();
            if (obj instanceof IVariableOptionProvider) {
                IVariableOptionProvider provider = (IVariableOptionProvider)obj;
                return provider.getOptions();
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to get options", (Throwable)ex);
        }
        return null;
    }
}

