/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.ui.title.server.specification;

import com.tandbergtv.cms.contentmgmt.service.specification.IAssetSpecificationManager;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetDefinition;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecification;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecificationListItem;
import com.tandbergtv.cms.portal.ui.title.client.service.specification.IUISpecificationManager;
import com.tandbergtv.cms.portal.ui.title.server.specification.UIAssetSpecificationBuilder;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecification;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class UISpecificationManager
implements IUISpecificationManager,
NeptuneRemoteService {
    private IAssetSpecificationManager specificationManager = (IAssetSpecificationManager)InjectionUtil.injectInstance((String)"cms/AssetSpecificationManager/local", IAssetSpecificationManager.class);

    @Override
    public List<UIAssetSpecificationListItem> getAll() {
        Collection specifications = this.specificationManager.getAllSpecifications();
        ArrayList<UIAssetSpecificationListItem> all = new ArrayList<UIAssetSpecificationListItem>();
        if (specifications != null) {
            UIAssetSpecificationBuilder builder = new UIAssetSpecificationBuilder();
            for (Specification specification : specifications) {
                UIAssetSpecificationListItem listItem = builder.buildListItem(specification);
                all.add(listItem);
            }
            Collections.sort(all, new Comparator<UIAssetSpecificationListItem>(){

                @Override
                public int compare(UIAssetSpecificationListItem o1, UIAssetSpecificationListItem o2) {
                    Collator collator = Collator.getInstance();
                    return collator.compare(o1.getDisplayName(), o2.getDisplayName());
                }
            });
        }
        return all;
    }

    @Override
    public List<UIAssetSpecificationListItem> getPreviewSpecs() throws NeptuneException {
        Collection specs = this.specificationManager.getSpecsWithFromTTVTranslator();
        ArrayList<UIAssetSpecificationListItem> previewSpecs = new ArrayList<UIAssetSpecificationListItem>();
        if (specs != null) {
            UIAssetSpecificationBuilder builder = new UIAssetSpecificationBuilder();
            for (Specification spec : specs) {
                UIAssetSpecificationListItem listItem = builder.buildListItem(spec);
                previewSpecs.add(listItem);
            }
            Comparator<UIAssetSpecificationListItem> comp = new Comparator<UIAssetSpecificationListItem>(){

                @Override
                public int compare(UIAssetSpecificationListItem o1, UIAssetSpecificationListItem o2) {
                    Collator collator = Collator.getInstance();
                    return collator.compare(o1.getDisplayName(), o2.getDisplayName());
                }
            };
            Collections.sort(previewSpecs, comp);
        }
        return previewSpecs;
    }

    @Override
    public UIAssetSpecificationListItem getDefaultListItem() {
        return null;
    }

    @Override
    public UIAssetSpecification getUISpecification() {
        UISpecification defaultSpecification = this.specificationManager.getUISpecification(UISpecification.Type.PACKAGE);
        UIAssetSpecificationBuilder builder = new UIAssetSpecificationBuilder();
        return defaultSpecification != null ? builder.build(defaultSpecification) : null;
    }

    @Override
    public Collection<UIAssetDefinition> getAllUISpecifications() {
        UISpecification packageSpecification = this.specificationManager.getUISpecification(UISpecification.Type.PACKAGE);
        UISpecification seriesSpecification = this.specificationManager.getUISpecification(UISpecification.Type.SERIES);
        UIAssetSpecificationBuilder builder = new UIAssetSpecificationBuilder();
        List<UIAssetDefinition> result = builder.build(packageSpecification).getAssetDefinitions();
        result.addAll(builder.build(seriesSpecification).getAssetDefinitions());
        return result;
    }

    public String getRelativePath() {
        return "service/title/specification/IUISpecificationManager";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    @Override
    public UIAssetSpecification getUIAssetSpecification(String type) {
        UISpecification specification = null;
        specification = type.equalsIgnoreCase(UISpecification.Type.PACKAGE.toString()) ? this.specificationManager.getUISpecification(UISpecification.Type.PACKAGE) : this.specificationManager.getUISpecification(UISpecification.Type.SERIES);
        UIAssetSpecificationBuilder builder = new UIAssetSpecificationBuilder();
        return specification != null ? builder.build(specification) : null;
    }
}

