/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.titlelist.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.titlelist.client.TitleListComponentConstants;
import com.tandbergtv.cms.portal.content.titlelist.client.services.AddAssetToTitleList;
import com.tandbergtv.cms.portal.content.titlelist.client.services.RunTemplate;
import com.tandbergtv.cms.portal.content.titlelist.client.services.TitleListDeleteService;
import com.tandbergtv.cms.portal.content.titlelist.client.services.TitleListXportService;
import com.tandbergtv.cms.portal.content.titlelist.client.tab.TitleListsPanel;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleListService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.PortletFactory;
import com.tandbergtv.neptune.widgettoolkit.client.application.Service;
import com.tandbergtv.neptune.widgettoolkit.client.application.ServiceLoader;
import com.tandbergtv.neptune.widgettoolkit.client.application.WidgetFactory;
import com.tandbergtv.neptune.widgettoolkit.client.component.ComponentBase;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventListenerRegistry;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventSink;
import com.tandbergtv.neptune.widgettoolkit.client.menu.GroupMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.menu.MenuItemBase;
import com.tandbergtv.neptune.widgettoolkit.client.menu.MenuItemProxy;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TitleListComponent
extends ComponentBase {
    public static final String COMPONENT_NAME = "Title List Management";
    private String spec = "";
    private final TitleListComponentConstants constants = (TitleListComponentConstants)GWT.create(TitleListComponentConstants.class);

    public void init(EventListenerRegistry eventListenerRegistry, EventSink eventSink, ServiceLoader serviceLoader, Map<String, String> info) {
        super.init(eventListenerRegistry, eventSink, serviceLoader, info);
        this.spec = info.get("ContentComponent.Specification");
    }

    public List<PortletFactory> listPortlets(NeptuneSecurity security) {
        ArrayList<PortletFactory> portletFactories = new ArrayList<PortletFactory>();
        return portletFactories;
    }

    public <E extends Service> List<E> listServices(Class<E> clazz, NeptuneSecurity security) {
        if (clazz.getName().equalsIgnoreCase(ITitleListService.class.getName())) {
            return this.getTitleListServices();
        }
        if (clazz.getName().equalsIgnoreCase(ITitleService.class.getName())) {
            ArrayList<AddAssetToTitleList> listServices = new ArrayList<AddAssetToTitleList>();
            if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"AssetListManagement_Modify"})) {
                listServices.add(new AddAssetToTitleList());
            }
            return listServices;
        }
        return null;
    }

    private List<ITitleListService> getTitleListServices() {
        ArrayList<ITitleListService> titleListServices = new ArrayList<ITitleListService>();
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"AssetListManagement_Delete"})) {
            titleListServices.add(new TitleListDeleteService());
        }
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"AssetListManagement_View", "AssetListManagement_Modify"})) {
            titleListServices.add(new TitleListXportService());
        }
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"WorkOrderManagement_Create"})) {
            titleListServices.add(new RunTemplate());
        }
        return titleListServices;
    }

    public List<MenuItemBase> listTabs(NeptuneSecurity security) {
        ArrayList<MenuItemBase> tabs = new ArrayList<MenuItemBase>();
        ArrayList childMenuItems = new ArrayList();
        MenuItemProxy rootMenuItem = new MenuItemProxy(this.constants.menuItemContent(), childMenuItems);
        this.buildTitleListMenuItems(rootMenuItem);
        tabs.add((MenuItemBase)rootMenuItem);
        return tabs;
    }

    private void buildTitleListMenuItems(MenuItemProxy parentMenuItem) {
        ArrayList titleListsGroup = new ArrayList();
        String displayName = this.constants.menuItemTitleList();
        GroupMenuItem menuItem = new GroupMenuItem("TitleLists", displayName, titleListsGroup);
        parentMenuItem.getItems().add(menuItem);
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"AssetListManagement_View"}) && ClientAuthorizationManager.isAuthorized((String[])new String[]{"AssetListManagement_View"})) {
            final TitleListsPanel titleListPanel = new TitleListsPanel(this.spec, ClientAuthorizationManager.getSecurity(), this.serviceLoader);
            displayName = this.constants.menuItemTitleList();
            WidgetMenuItem titleListsView = new WidgetMenuItem("TitleLists", displayName, new WidgetFactory(){

                public Widget getInstance() {
                    return titleListPanel;
                }

                public void release(Widget widget) {
                }
            }, titleListPanel.getAnchorChangeListener());
            titleListPanel.setReverseAnchorChangeListener(titleListsView.getReverseAnchorChangeListener());
            parentMenuItem.getItems().add(titleListsView);
        }
    }

    public String getSpecificationName() {
        return this.spec;
    }

    public String getName() {
        return "TITLE_LIST";
    }

    public String getDisplayName() {
        return this.constants.componentDisplayName();
    }
}

