/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.titlelist.client.imageeditor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Random;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.titlelist.client.i18n.TitleListConstants;
import com.tandbergtv.cms.portal.content.titlelist.client.imageeditor.UploadImageDialogBox;
import com.tandbergtv.cms.portal.content.titlelist.client.model.SaveImageRequest;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.ImageEditorService;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.ImageEditorServiceAsync;
import com.tandbergtv.neptune.widgettoolkit.client.widget.INeptuneWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;

public class ImageWidget
extends Composite
implements INeptuneWidget {
    private static final String GET_IMAGE_JSP_PATH = "/portal/cms_titlelistmgmt_ui/jsps/get_image.jsp";
    private final ImageEditorServiceAsync imageEditorService = (ImageEditorServiceAsync)GWT.create(ImageEditorService.class);
    private TitleListConstants constants = (TitleListConstants)GWT.create(TitleListConstants.class);
    private Image image;
    private VerticalPanel mainPanel;
    private SaveImageRequest saveImageRequest;
    private boolean removeImage = false;
    private final BusyIndicator busyIndicator = new BusyIndicator();

    public ImageWidget(SaveImageRequest saveImageRequest) {
        this.initializeWidget(saveImageRequest);
    }

    private void initializeWidget(SaveImageRequest saveImageRequest) {
        this.saveImageRequest = saveImageRequest;
        Button uploadImageButton = new Button(this.constants.upload());
        uploadImageButton.removeStyleName("gwt-Button");
        uploadImageButton.addStyleName("ebBtn");
        uploadImageButton.addStyleName("ebBtn_color_green");
        Button removeImageButton = new Button(this.constants.remove());
        removeImageButton.removeStyleName("gwt-Button");
        removeImageButton.addStyleName("ebBtn");
        removeImageButton.addStyleName("delete_button_icon");
        uploadImageButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ImageWidget.this.loadUploadDialog();
            }
        });
        removeImageButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ImageWidget.this.removeImage();
            }
        });
        this.image = new Image();
        this.image.setHeight("80px");
        this.image.setUrl(this.generateUrl(false));
        this.mainPanel = new VerticalPanel();
        this.mainPanel.add((Widget)this.image);
        Label vertSpace = new Label();
        vertSpace.setHeight("5px");
        this.mainPanel.add((Widget)vertSpace);
        HorizontalPanel buttonsPanel = new HorizontalPanel();
        buttonsPanel.addStyleName("cms_button_container");
        buttonsPanel.add((Widget)uploadImageButton);
        Label horSpace = new Label();
        horSpace.setWidth("5px");
        buttonsPanel.add((Widget)horSpace);
        buttonsPanel.add((Widget)removeImageButton);
        this.mainPanel.add((Widget)buttonsPanel);
        this.initWidget((Widget)this.mainPanel);
    }

    private void loadUploadDialog() {
        this.busyIndicator.center();
        this.imageEditorService.putImageInSession(this.saveImageRequest, new AsyncCallback<Void>(){

            public void onFailure(Throwable caught) {
                ImageWidget.this.busyIndicator.hide();
                Window.alert((String)("Failed to store image in session : putImageInSession RPC Failure : " + caught.getMessage() + "\n Please try again."));
            }

            public void onSuccess(Void result) {
                UploadImageDialogBox uploadImageDialogBox = new UploadImageDialogBox(new AsyncCallback<Void>(){

                    public void onFailure(Throwable caught) {
                        Window.alert((String)("Failed to load the upload image dialog : " + caught.getMessage() + "\n Please try again."));
                    }

                    public void onSuccess(Void result) {
                        ImageWidget.this.image.setUrl(ImageWidget.this.generateUrl(true));
                    }
                });
                uploadImageDialogBox.setSaveImageRequest(ImageWidget.this.saveImageRequest);
                uploadImageDialogBox.center();
                UploadImageDialogBox.loadImageUrl(ImageWidget.this.generateUrl(false), "dummy.jpg");
                ImageWidget.this.busyIndicator.hide();
            }
        });
    }

    private void removeImage() {
        this.saveImageRequest.setImageDataBase64(null);
        this.removeImage = true;
        this.imageEditorService.putImageInSession(this.saveImageRequest, new AsyncCallback<Void>(){

            public void onFailure(Throwable caught) {
                Window.alert((String)("Failed to store image in session : putImageInSession RPC Failure : " + caught.getMessage() + "\n Please try again."));
                ImageWidget.this.removeImage = false;
            }

            public void onSuccess(Void result) {
                ImageWidget.this.image.setUrl(ImageWidget.this.generateUrl(false));
                ImageWidget.this.removeImage = false;
            }
        });
    }

    private String generateUrl(boolean decode) {
        StringBuffer imageUrl = new StringBuffer(String.valueOf(Window.Location.getProtocol()) + "//" + Window.Location.getHost() + GET_IMAGE_JSP_PATH);
        imageUrl.append("?key=" + Random.nextInt());
        if (decode) {
            imageUrl.append("&decode=true");
        }
        if (this.saveImageRequest.getAssetListElementId() != null) {
            imageUrl.append("&assetListId=" + this.saveImageRequest.getAssetListId());
            imageUrl.append("&assetListElementId=" + this.saveImageRequest.getAssetListElementId());
            imageUrl.append("&metadataFieldName=" + this.saveImageRequest.getMetadataFieldName());
            if (this.removeImage) {
                imageUrl.append("&removeImage=yes");
            }
        } else if (this.saveImageRequest.getAssetListId() != null) {
            imageUrl.append("&assetListId=" + this.saveImageRequest.getAssetListId());
            imageUrl.append("&metadataFieldName=" + this.saveImageRequest.getMetadataFieldName());
            if (this.removeImage) {
                imageUrl.append("&removeImage=yes");
            }
        }
        return imageUrl.toString();
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public Image getImage() {
        return this.image;
    }

    public void setSaveImageRequest(SaveImageRequest saveImageRequest) {
        this.saveImageRequest = saveImageRequest;
    }

    public SaveImageRequest getSaveImageRequest() {
        return this.saveImageRequest;
    }
}

