/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.titlelist.client.imageeditor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.AttachEvent;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.titlelist.client.i18n.TitleListConstants;
import com.tandbergtv.cms.portal.content.titlelist.client.model.SaveImageRequest;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.ImageEditorService;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.ImageEditorServiceAsync;

public class UploadImageDialogBox
extends DialogBox {
    private final ImageEditorServiceAsync imageEditorService = (ImageEditorServiceAsync)GWT.create(ImageEditorService.class);
    private TitleListConstants constants = (TitleListConstants)GWT.create(TitleListConstants.class);
    private Button saveButton;
    private Button cancelButton;
    private SaveImageRequest saveImageRequest;
    private AsyncCallback<Void> callback;

    public UploadImageDialogBox(AsyncCallback<Void> callback) {
        super(false, true);
        this.callback = callback;
        this.init();
    }

    public void init() {
        this.setText(this.constants.uploadImage());
        VerticalPanel verticalPanel = new VerticalPanel();
        StringBuffer tmp = new StringBuffer("<div style=\"visibility:hidden\" id=\"imageeditor\">");
        tmp.append("<div id=\"container\" >");
        tmp.append("\r\n</div>");
        tmp.append("\r\n</div>");
        HTML imgEditorHTML = new HTML(tmp.toString());
        verticalPanel.add((Widget)imgEditorHTML);
        verticalPanel.addAttachHandler(new AttachEvent.Handler(){

            public void onAttachOrDetach(AttachEvent event) {
                if (event.isAttached()) {
                    UploadImageDialogBox.initImageEditor();
                }
            }
        });
        HorizontalPanel horizontalPanel = new HorizontalPanel();
        horizontalPanel.setSpacing(5);
        TextArea saveImageContent = new TextArea();
        saveImageContent.setVisible(false);
        horizontalPanel.add((Widget)saveImageContent);
        horizontalPanel.add((Widget)this.initSaveButton());
        horizontalPanel.add((Widget)this.initCancelButton());
        verticalPanel.add((Widget)horizontalPanel);
        this.setWidget((Widget)verticalPanel);
    }

    private Button initSaveButton() {
        this.saveButton = new Button(this.constants.saveButtonName());
        this.saveButton.removeStyleName("gwt-Button");
        this.saveButton.addStyleName("ebBtn");
        this.saveButton.addStyleName("ebBtn_color_green");
        this.saveButton.addStyleName("save_button_icon");
        this.saveButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                UploadImageDialogBox.this.setSavingState(true);
                String imageDataBase64 = UploadImageDialogBox.getImageDataBase64();
                if (UploadImageDialogBox.this.saveImageRequest != null) {
                    UploadImageDialogBox.this.saveImageRequest.setImageDataBase64(imageDataBase64.split(",")[1]);
                    UploadImageDialogBox.this.imageEditorService.putImageInSession(UploadImageDialogBox.this.saveImageRequest, new AsyncCallback<Void>(){

                        public void onFailure(Throwable caught) {
                            UploadImageDialogBox.this.setSavingState(false);
                            if (UploadImageDialogBox.this.callback != null) {
                                UploadImageDialogBox.this.callback.onFailure(null);
                            }
                        }

                        public void onSuccess(Void result) {
                            UploadImageDialogBox.cleanupImageEditor();
                            UploadImageDialogBox.this.hide();
                            if (UploadImageDialogBox.this.callback != null) {
                                UploadImageDialogBox.this.callback.onSuccess(null);
                            }
                        }
                    });
                } else {
                    UploadImageDialogBox.this.setSavingState(false);
                }
            }
        });
        return this.saveButton;
    }

    private Button initCancelButton() {
        this.cancelButton = new Button(this.constants.cancelButtonName());
        this.cancelButton.removeStyleName("gwt-Button");
        this.cancelButton.addStyleName("ebBtn");
        this.cancelButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                UploadImageDialogBox.cleanupImageEditor();
                UploadImageDialogBox.this.hide();
            }
        });
        return this.cancelButton;
    }

    private void setSavingState(boolean isSaving) {
        this.saveButton.setEnabled(!isSaving);
        this.cancelButton.setEnabled(!isSaving);
        this.saveButton.setText(isSaving ? this.constants.savingButtonText() : this.constants.saveButtonName());
    }

    public static native String getImageDataBase64();

    public SaveImageRequest getSaveImageRequest() {
        return this.saveImageRequest;
    }

    public void setSaveImageRequest(SaveImageRequest saveImageRequest) {
        this.saveImageRequest = saveImageRequest;
    }

    public static native void loadImageUrl(String var0, String var1);

    public static native void initImageEditor();

    public static native void cleanupImageEditor();

    public static native void console(String var0);
}

