/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.titlelist.client.services;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.ITitleListService;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.ITitleListServiceAsync;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.UiValidationException;
import com.tandbergtv.cms.portal.content.titlelist.client.services.AddAssetToTitleListResult;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IOperationResult;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleAssetActionService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.TitleActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ViewInput;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;

public class AddAssetToTitleList
implements ITitleAssetActionService {
    private ContentConstants displayConstants = (ContentConstants)GWT.create(ContentConstants.class);
    private ITitleListServiceAsync titleListService = (ITitleListServiceAsync)GWT.create(ITitleListService.class);
    private static final Map<String, String> _serviceActionParameters = new HashMap<String, String>();

    static {
        _serviceActionParameters.put("TITLE_TYPE", "MASTER");
        _serviceActionParameters.put("UPDATE_TYPE", "MULTIPLE");
    }

    public void execute(List<Long> assetIds, String serviceParameter, IActionInput input, AsyncCallback<IOperationResult> callback) {
        throw new UnsupportedOperationException();
    }

    public void executeAddAssets(Map<Long, List<Long>> titleAssetIdsMap, String serviceParameter, IActionInput input, final AsyncCallback<IOperationResult> callback) {
        final TitleActionInput actionInput = (TitleActionInput)input;
        if (actionInput.getTitleListId() == 0L) {
            callback.onFailure((Throwable)new RuntimeException(this.displayConstants.titleListRequiredFailure()));
            return;
        }
        final BusyIndicator busyIndicator = new BusyIndicator();
        busyIndicator.center();
        this.titleListService.addAssetsToTitleList(actionInput.getTitleListId(), titleAssetIdsMap, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                busyIndicator.hide();
                if (caught instanceof UiValidationException) {
                    List<String> errorCodes = ((UiValidationException)((Object)caught)).getErrorCodes();
                    StringBuilder sb = new StringBuilder(AddAssetToTitleList.this.displayConstants.invalidAssets());
                    for (String code : errorCodes) {
                        if (sb.length() > 0) {
                            sb.append("\n");
                        }
                        sb.append(" - ");
                        try {
                            sb.append(AddAssetToTitleList.this.displayConstants.getString(code));
                        }
                        catch (MissingResourceException missingResourceException) {
                            sb.append(code);
                        }
                    }
                    Window.alert((String)sb.toString());
                } else {
                    Window.alert((String)caught.getLocalizedMessage());
                }
            }

            public void onNeptuneSuccess(Void result) {
                busyIndicator.hide();
                callback.onSuccess((Object)new AddAssetToTitleListResult(actionInput.getSpec(), actionInput.getTitleListId()));
            }
        });
    }

    public String getDescription() {
        return this.displayConstants.addAssetToList();
    }

    public String getName() {
        return this.displayConstants.addAssetToListServiceName();
    }

    public void getServiceParameters(NeptuneAsyncCallback<List<String>> callback) {
        callback.onSuccess(null);
    }

    public Map<String, String> getServiceActionParameters() {
        return _serviceActionParameters;
    }

    public void gotoResultPage(IOperationResult result, IView sourceView) {
        History.newItem((String)("Content.TitleLists.View?titleListId=" + ((AddAssetToTitleListResult)result).getTitleListId() + "&spec=" + ((AddAssetToTitleListResult)result).getSpec()));
    }

    public boolean getConfirmation() {
        return false;
    }

    public boolean isSelected(ViewInput inputData) {
        return inputData.getTitleListId() != 0L;
    }

    public boolean needTitlesTobeSelected() {
        return true;
    }
}

