/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.titlelist.client.services;

import com.google.gwt.core.client.GWT;
import com.tandbergtv.cms.portal.content.titlelist.client.i18n.TitleListConstants;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IOperationResult;
import java.util.HashMap;
import java.util.Map;

public class TitleListExportResponse
implements IOperationResult {
    private Map<Long, String> sucessfulExportTitleList;
    private Map<Long, String> failedExportTitleList;
    private String NEWLINE_CHAR = "\n";

    public TitleListExportResponse() {
        this.sucessfulExportTitleList = new HashMap<Long, String>();
        this.failedExportTitleList = new HashMap<Long, String>();
    }

    public TitleListExportResponse(Map<Long, String> sucessfulExportTitleList, Map<Long, String> failedExportTitleList) {
        this.sucessfulExportTitleList = sucessfulExportTitleList;
        this.failedExportTitleList = failedExportTitleList;
    }

    public Map<Long, String> getSucessfulExportTitleList() {
        return this.sucessfulExportTitleList;
    }

    public void setSucessfulExportTitleList(Map<Long, String> sucessfulExportTitleList) {
        this.sucessfulExportTitleList = sucessfulExportTitleList;
    }

    public Map<Long, String> getFailedExportTitleList() {
        return this.failedExportTitleList;
    }

    public void setFailedExportTitleList(Map<Long, String> failedExportTitleList) {
        this.failedExportTitleList = failedExportTitleList;
    }

    public String getMessage() {
        TitleListConstants displayConstants = (TitleListConstants)GWT.create(TitleListConstants.class);
        StringBuilder sb = new StringBuilder();
        boolean prefixDelimiter = false;
        if (this.sucessfulExportTitleList.size() > 0) {
            sb.append(String.valueOf(displayConstants.titleListExportSuccessPrefix()) + this.NEWLINE_CHAR);
            for (Map.Entry<Long, String> entry : this.sucessfulExportTitleList.entrySet()) {
                if (prefixDelimiter) {
                    sb.append(this.NEWLINE_CHAR);
                }
                sb.append("TitleList " + entry.getKey() + " [" + entry.getValue() + "]");
                prefixDelimiter = true;
            }
        }
        if (this.failedExportTitleList.size() > 0) {
            if (this.sucessfulExportTitleList.size() > 0) {
                sb.append(this.NEWLINE_CHAR);
            }
            sb.append(String.valueOf(displayConstants.titleListExportFailurePrefix()) + this.NEWLINE_CHAR);
            prefixDelimiter = false;
            for (Map.Entry<Long, String> entry : this.failedExportTitleList.entrySet()) {
                if (prefixDelimiter) {
                    sb.append(this.NEWLINE_CHAR);
                }
                sb.append("TitleList " + entry.getKey() + " : " + entry.getValue());
                prefixDelimiter = true;
            }
        }
        return sb.toString();
    }
}

