/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.titlelist.client.tab;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.titlelist.client.i18n.TitleListConstants;
import com.tandbergtv.cms.portal.content.titlelist.client.imageeditor.TypedImageBoxWidget;
import com.tandbergtv.cms.portal.content.titlelist.client.model.SaveImageRequest;
import com.tandbergtv.cms.portal.content.titlelist.client.model.UiAssetMap;
import com.tandbergtv.cms.portal.content.titlelist.client.model.UiDataType;
import com.tandbergtv.cms.portal.content.titlelist.client.model.UiMetadataField;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.DefaultDataTypeWidgetFactory;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.StringWidgetConfiguration;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.WidgetConfiguration;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.DataTypeWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IValueConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.StringConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AssetMetadataForm
extends Composite {
    private VerticalContainer verticalContainer;
    private FormContainer form;
    private List<ButtonWidget> buttonsList;
    private Long assetListId;
    private UiAssetMap uiAssetMap;
    private Map<UiMetadataField, DataTypeWidget<?>> metadataFieldsMap;
    private TitleListConstants constants = (TitleListConstants)GWT.create(TitleListConstants.class);

    public AssetMetadataForm() {
        this(null, null, null);
    }

    public AssetMetadataForm(Long assetListId, UiAssetMap uiAssetMap, List<UiMetadataField> metadataFields) {
        this.assetListId = assetListId;
        this.uiAssetMap = uiAssetMap;
        this.metadataFieldsMap = new HashMap();
        this.init(metadataFields);
    }

    private void init(List<UiMetadataField> metadataFields) {
        this.verticalContainer = new VerticalContainer();
        this.buttonsList = new ArrayList<ButtonWidget>();
        this.form = new FormContainer(HasHorizontalAlignment.ALIGN_LEFT);
        DefaultDataTypeWidgetFactory factory = new DefaultDataTypeWidgetFactory();
        for (UiMetadataField metadataField : metadataFields) {
            UiMetadataField metadataFieldCopy = new UiMetadataField();
            this.copyProperties(metadataField, metadataFieldCopy);
            DataTypeWidget<?> dataTypeWidget = this.createDataTypeWidget(factory, metadataFieldCopy);
            if (dataTypeWidget == null) continue;
            this.metadataFieldsMap.put(metadataFieldCopy, dataTypeWidget);
            this.form.addRow(metadataFieldCopy.getDisplayName(), dataTypeWidget, metadataFieldCopy.isRequired());
        }
        this.verticalContainer.add((Widget)this.form);
        this.verticalContainer.setWidth("100%");
        this.initWidget((Widget)this.verticalContainer);
    }

    private void copyProperties(UiMetadataField source, UiMetadataField dest) {
        dest.setDataType(source.getDataType());
        dest.setDisplayName(source.getDisplayName());
        dest.setId(source.getId());
        dest.setName(source.getName());
        dest.setValue(source.getValue());
        dest.setRequired(source.isRequired());
        dest.setOptions(source.getOptions());
    }

    private DataTypeWidget<?> createDataTypeWidget(DefaultDataTypeWidgetFactory factory, UiMetadataField metadataField) {
        TypedImageBoxWidget<String> dataTypeWidget = null;
        if (UiDataType.STRING.equals((Object)metadataField.getDataType())) {
            StringWidgetConfiguration swc = new StringWidgetConfiguration();
            List<UiMetadataField.Option> optionsList = metadataField.getOptions();
            if (optionsList != null && !optionsList.isEmpty()) {
                ArrayList<UIValueOption> options = new ArrayList<UIValueOption>();
                for (UiMetadataField.Option option : optionsList) {
                    UIValueOption uiso = new UIValueOption(option.getName(), option.getValue());
                    options.add(uiso);
                }
                swc.setAnyValueAllowed(false);
                swc.setOptions(options);
            }
            dataTypeWidget = factory.createStringWidget(swc);
        } else if (UiDataType.INTEGER.equals((Object)metadataField.getDataType())) {
            dataTypeWidget = factory.createIntegerWidget(new WidgetConfiguration());
        } else if (UiDataType.IMAGE.equals((Object)metadataField.getDataType())) {
            dataTypeWidget = this.createImageWidget(metadataField.getName());
        }
        return dataTypeWidget;
    }

    public FormContainer getForm() {
        return this.form;
    }

    public void addButton(ButtonWidget button) {
        this.buttonsList.add(button);
    }

    public void removeButton(ButtonWidget button) {
        this.buttonsList.remove(button);
    }

    private void updateMetadataFields() {
        Set<Map.Entry<UiMetadataField, DataTypeWidget<?>>> metadataEntries = this.metadataFieldsMap.entrySet();
        for (Map.Entry<UiMetadataField, DataTypeWidget<?>> entry : metadataEntries) {
            entry.getKey().setValue(entry.getValue().getTextValue());
        }
    }

    public void setBorderWidth(int width) {
        this.verticalContainer.setBorderWidth(width);
    }

    public List<UiMetadataField> getMetadataFields() {
        this.updateMetadataFields();
        return new ArrayList<UiMetadataField>(this.metadataFieldsMap.keySet());
    }

    public void initMetadataFields(List<UiMetadataField> assetMetadataFields) {
        block0: for (UiMetadataField uiMetadataField : assetMetadataFields) {
            for (Map.Entry<UiMetadataField, DataTypeWidget<?>> entry : this.metadataFieldsMap.entrySet()) {
                if (!uiMetadataField.getName().equals(entry.getKey().getName())) continue;
                String value = uiMetadataField.getValue();
                entry.getValue().setTextValue(value);
                continue block0;
            }
        }
    }

    private TypedImageBoxWidget<String> createImageWidget(String metadataFieldName) {
        StringConverter converter = new StringConverter();
        SaveImageRequest saveImageRequest = new SaveImageRequest();
        if (this.uiAssetMap != null) {
            saveImageRequest.setAssetListId(this.assetListId);
            saveImageRequest.setAssetListElementId(this.uiAssetMap.getId());
            saveImageRequest.setMetadataFieldName(metadataFieldName);
        }
        TypedImageBoxWidget<String> widget = new TypedImageBoxWidget<String>((IValueConverter<String>)converter, saveImageRequest);
        return widget;
    }

    public boolean isValid() {
        return this.getInvalidFieldsMessages().size() == 0;
    }

    public List<String> getInvalidFieldsMessages() {
        ArrayList<String> invalidFields = new ArrayList<String>();
        Set<Map.Entry<UiMetadataField, DataTypeWidget<?>>> entries = this.metadataFieldsMap.entrySet();
        for (Map.Entry<UiMetadataField, DataTypeWidget<?>> entry : entries) {
            UiMetadataField field = entry.getKey();
            DataTypeWidget<?> widget = entry.getValue();
            if (field.isRequired() && (widget.getTextValue() == null || widget.getTextValue().trim().equals(""))) {
                invalidFields.add(String.valueOf(field.getDisplayName()) + " (" + this.constants.requiredFieldToolTip() + ")");
                widget.showValidationError(this.constants.requiredFieldToolTip());
            }
            if (widget.isValidValue()) continue;
            invalidFields.add(String.valueOf(field.getDisplayName()) + " (" + widget.getErrorToolTip() + ")");
        }
        return invalidFields;
    }

    public UiAssetMap getUiAssetMap() {
        return this.uiAssetMap;
    }
}

