/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.titlelist.client.tab;

import com.allen_sauer.gwt.dnd.client.DragContext;
import com.allen_sauer.gwt.dnd.client.drop.AbstractPositioningDropController;
import com.allen_sauer.gwt.dnd.client.util.CoordinateLocation;
import com.allen_sauer.gwt.dnd.client.util.DOMUtil;
import com.allen_sauer.gwt.dnd.client.util.Location;
import com.allen_sauer.gwt.dnd.client.util.LocationWidgetComparator;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.IndexedPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.dnd.TableRowBeforeMoveEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.dnd.TableRowDragController;
import com.tandbergtv.neptune.widgettoolkit.client.widget.dnd.TableRowMoveEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.dnd.TableRowMoveHandler;
import java.util.ArrayList;
import java.util.List;

public class TableRowDropController
extends AbstractPositioningDropController {
    private List<TableRowMoveHandler> handlers = new ArrayList<TableRowMoveHandler>();
    private final IndexedTablePanel tableWrapper;

    public TableRowDropController(FlexTable table) {
        super((Panel)table);
        this.tableWrapper = new IndexedTablePanel(table);
    }

    public FlexTable getDropTarget() {
        return (FlexTable)super.getDropTarget();
    }

    public void onDrop(DragContext context) {
        if (!(context.dragController instanceof TableRowDragController)) {
            return;
        }
        TableRowDragController dragController = (TableRowDragController)context.dragController;
        FlexTable table = this.getDropTarget();
        if (!table.equals(dragController.getTable())) {
            return;
        }
        int index = dragController.getDraggedRowIndex();
        int targetIndex = this.getTargetRowIndex(context);
        if (!this.isValidIndex(index) || !this.isValidIndex(targetIndex)) {
            return;
        }
        TableRowBeforeMoveEvent event = new TableRowBeforeMoveEvent(table, index, targetIndex);
        for (TableRowMoveHandler handler : this.handlers) {
            handler.onBeforeRowMove(event);
            if (!event.isCanceled()) continue;
            return;
        }
        this.moveRow(index, targetIndex);
        TableRowMoveEvent moveEvent = new TableRowMoveEvent(table, index, targetIndex);
        for (TableRowMoveHandler handler : this.handlers) {
            handler.onRowMove(moveEvent);
        }
        super.onDrop(context);
    }

    protected void moveRow(int index, int targetIndex) {
        this.moveRowContent(index, targetIndex);
    }

    public void addTableRowMoveHandler(TableRowMoveHandler handler) {
        if (handler != null && !this.handlers.contains(handler)) {
            this.handlers.add(handler);
        }
    }

    public void removeTableRowMoveHandler(TableRowMoveHandler handler) {
        this.handlers.remove(handler);
    }

    protected IndexedTablePanel getTable() {
        return this.tableWrapper;
    }

    protected int getTargetRowIndex(DragContext context) {
        CoordinateLocation location = new CoordinateLocation(context.mouseX, context.mouseY);
        LocationWidgetComparator comparator = LocationWidgetComparator.BOTTOM_HALF_COMPARATOR;
        int targetIndex = DOMUtil.findIntersect((IndexedPanel)this.tableWrapper, (Location)location, (LocationWidgetComparator)comparator) - 1;
        return targetIndex;
    }

    private boolean isValidIndex(int rowIndex) {
        return rowIndex >= 0 && rowIndex < this.getDropTarget().getRowCount();
    }

    protected void moveRowContent(int source, int target) {
        FlexTable table = this.getDropTarget();
        if (target == source) {
            return;
        }
        if (target > source) {
            ++target;
        }
        table.insertRow(target);
        if (target < source) {
            ++source;
        }
        int column = 0;
        while (column < table.getCellCount(source)) {
            Widget w = table.getWidget(source, column);
            if (w != null) {
                table.setWidget(target, column, w);
            } else {
                HTML html = new HTML(table.getHTML(source, column));
                table.setWidget(target, column, (Widget)html);
            }
            String style = table.getCellFormatter().getStyleName(source, column);
            table.getCellFormatter().setStyleName(target, column, style);
            int columnSpan = table.getFlexCellFormatter().getColSpan(source, column);
            table.getFlexCellFormatter().setColSpan(target, column, columnSpan);
            ++column;
        }
        String rowStyle = table.getRowFormatter().getStyleName(source);
        table.getRowFormatter().setStyleName(target, rowStyle);
        table.removeRow(source);
    }

    private static final class IndexedTablePanel
    implements IndexedPanel {
        private final FlexTable table;

        public IndexedTablePanel(FlexTable table) {
            this.table = table;
        }

        public Widget getWidget(int index) {
            return this.table.getWidget(index, 0);
        }

        public int getWidgetCount() {
            return this.table.getRowCount();
        }

        public int getWidgetIndex(Widget child) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(int index) {
            throw new UnsupportedOperationException();
        }
    }
}

