/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.titlelist.client.tab;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.titlelist.client.i18n.TitleListConstants;
import com.tandbergtv.cms.portal.content.titlelist.client.model.UiTitleList;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.ITitleListService;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.ITitleListServiceAsync;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.UiValidationException;
import com.tandbergtv.cms.portal.content.titlelist.client.tab.TitleListForm;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.ResizableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.Iterator;
import java.util.List;

public class TitleListCreatePanel
extends VerticalContainer {
    private HeaderPanel headerPanel;
    private TitleListForm titleListForm;
    private MessageArea messageArea;
    private TitleListConstants constants = (TitleListConstants)GWT.create(TitleListConstants.class);
    private ContentConstants contentConstants = (ContentConstants)GWT.create(ContentConstants.class);
    private ITitleListServiceAsync service = (ITitleListServiceAsync)GWT.create(ITitleListService.class);
    private ResizableContainer resizableContainer;

    public TitleListCreatePanel(final String spec) {
        this.headerPanel = new HeaderPanel(this.constants.createTitleListHeader());
        this.titleListForm = new TitleListForm();
        this.setWidth("100%");
        this.messageArea = new MessageArea();
        this.messageArea.reset();
        ButtonWidget saveButton = new ButtonWidget(this.constants.saveTitleListButtonName());
        saveButton.removeStyleName("gwt-Button");
        saveButton.addStyleName("ebBtn");
        saveButton.addStyleName("ebBtn_color_green");
        saveButton.addStyleName("save_button_icon");
        saveButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (TitleListCreatePanel.this.titleListForm.isValid()) {
                    TitleListCreatePanel.this.service.save(TitleListCreatePanel.this.titleListForm.getCurrentUiTitleList(), (AsyncCallback<UiTitleList>)new NeptuneAsyncCallback<UiTitleList>(){

                        public void onNeptuneFailure(Throwable caught) {
                            if (caught instanceof UiValidationException) {
                                TitleListCreatePanel.this.messageArea.setErrorHTML(TitleListCreatePanel.this.getErrorMessageFromList(((UiValidationException)((Object)caught)).getErrorCodes()));
                                TitleListCreatePanel.this.resizableContainer.updateSize();
                            }
                        }

                        public void onNeptuneSuccess(UiTitleList result) {
                            History.newItem((String)("Content.TitleLists.View?titleListId=" + result.getKey().getId() + "&spec=" + spec));
                        }
                    });
                } else {
                    StringBuffer sbInvalidMessage = new StringBuffer(TitleListCreatePanel.this.constants.invalidFormData());
                    for (String invalidFieldMessage : TitleListCreatePanel.this.titleListForm.getInvalidFieldsMessages()) {
                        sbInvalidMessage.append("<br>");
                        sbInvalidMessage.append(" - ");
                        sbInvalidMessage.append(invalidFieldMessage);
                    }
                    TitleListCreatePanel.this.messageArea.setErrorHTML(sbInvalidMessage.toString());
                    TitleListCreatePanel.this.resizableContainer.updateSize();
                }
            }
        });
        ButtonWidget cancelButton = new ButtonWidget(this.constants.cancelTitleListButtonName());
        cancelButton.removeStyleName("gwt-Button");
        cancelButton.addStyleName("ebBtn");
        cancelButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                History.newItem((String)("Content.TitleLists.View?spec=" + spec));
            }
        });
        this.resizableContainer = new ResizableContainer((Widget)this.titleListForm, "Title List", null);
        this.resizableContainer.addHeightOffsettingWidget((Widget)this.headerPanel);
        this.resizableContainer.addHeightOffsettingWidget((Widget)this.messageArea);
        this.resizableContainer.addBottomWidget("Title List", (Widget)saveButton);
        this.resizableContainer.addBottomWidget("Title List", (Widget)cancelButton);
        this.add((Widget)this.headerPanel);
        this.add((Widget)this.messageArea);
        this.add((Widget)this.resizableContainer);
    }

    private String getErrorMessageFromList(List<String> errorCodes) {
        String message = "";
        if (errorCodes != null) {
            Iterator<String> i = errorCodes.iterator();
            while (i.hasNext()) {
                String code = i.next();
                message = String.valueOf(message) + this.contentConstants.getString(code);
                if (!i.hasNext()) continue;
                message = String.valueOf(message) + "<br>";
            }
        }
        return message;
    }
}

