/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.titlelist.client.tab;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.content.titlelist.client.i18n.TitleListConstants;
import com.tandbergtv.cms.portal.content.titlelist.client.model.UiTitleList;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.ITitleListService;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.ITitleListServiceAsync;
import com.tandbergtv.cms.portal.content.titlelist.client.tab.TitleListDetailView;
import com.tandbergtv.cms.portal.content.titlelist.client.tab.TitleListsPanel;
import com.tandbergtv.cms.portal.content.titlelist.client.tab.UiTitleListKey;
import com.tandbergtv.cms.portal.content.titlelist.client.tab.UiTitleListKeySerializer;
import com.tandbergtv.cms.portal.content.titlelist.client.tab.UiTitleListRecord;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.KeySerializer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.AbstractDetailFeature;
import java.util.List;

public class TitleListDetailFeature
extends AbstractDetailFeature<UiTitleListKey, UiTitleListRecord> {
    private String spec;
    private NeptuneSecurity security;
    private TitleListsPanel parentPanel;
    private ITitleListServiceAsync titleListService = (ITitleListServiceAsync)GWT.create(ITitleListService.class);
    private TitleListConstants constants = (TitleListConstants)GWT.create(TitleListConstants.class);

    public TitleListDetailFeature(String spec, NeptuneSecurity security, TitleListsPanel parentPanel) {
        super((KeySerializer)new UiTitleListKeySerializer());
        this.spec = spec;
        this.security = security;
        this.parentPanel = parentPanel;
    }

    public void delete(List<UiTitleListRecord> records, AsyncCallback<Void> callback) {
        throw new UnsupportedOperationException();
    }

    public void getNew(AsyncCallback<UiTitleListRecord> callback) {
        throw new UnsupportedOperationException();
    }

    public DetailView<UiTitleListKey, UiTitleListRecord> getView(UiTitleListRecord record, DetailViewCallback<UiTitleListKey, UiTitleListRecord> callback) {
        this.parentPanel.cleanup();
        TitleListDetailView view = new TitleListDetailView(this.spec, this.security, record, callback, this.parentPanel);
        return view;
    }

    public boolean hasDetailLink(Column<?, UiTitleListRecord> column) {
        return column.getDisplayName().equals(this.constants.titleListNameColumn()) && this.security.isUserInRole("AssetListManagement_View");
    }

    public void save(UiTitleListRecord record, final AsyncCallback<Void> callback) {
        this.titleListService.save(record.getTitleList(), (AsyncCallback<UiTitleList>)new NeptuneAsyncCallback<UiTitleList>(){

            public void onNeptuneFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(UiTitleList result) {
                callback.onSuccess(null);
                TitleListDetailFeature.this.parentPanel.getMessageArea().reset();
                TitleListDetailFeature.this.parentPanel.getMessageArea().setInfoMessage("Title List has been saved");
            }
        });
    }

    public boolean showCreateButton() {
        return false;
    }

    public boolean showDeleteButton() {
        return false;
    }
}

