/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.titlelist.client.tab;

import com.allen_sauer.gwt.dnd.client.drop.DropController;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.model.UiAsset;
import com.tandbergtv.cms.portal.content.client.model.UiField;
import com.tandbergtv.cms.portal.content.client.model.UiTitle;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TableColumnNameHelper;
import com.tandbergtv.cms.portal.content.titlelist.client.i18n.TitleListConstants;
import com.tandbergtv.cms.portal.content.titlelist.client.model.UiAssetMap;
import com.tandbergtv.cms.portal.content.titlelist.client.model.UiMetadataField;
import com.tandbergtv.cms.portal.content.titlelist.client.model.UiTitleList;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.ITitleListService;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.ITitleListServiceAsync;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.TitleListSearchService;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.TitleListSearchServiceAsync;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.UiValidationException;
import com.tandbergtv.cms.portal.content.titlelist.client.tab.AssetMetadataForm;
import com.tandbergtv.cms.portal.content.titlelist.client.tab.ExpandCollapseButton;
import com.tandbergtv.cms.portal.content.titlelist.client.tab.TitleListForm;
import com.tandbergtv.cms.portal.content.titlelist.client.tab.TitleListRowMoveController;
import com.tandbergtv.cms.portal.content.titlelist.client.tab.TitleListTableRowDragController;
import com.tandbergtv.cms.portal.content.titlelist.client.tab.TitleListsPanel;
import com.tandbergtv.cms.portal.content.titlelist.client.tab.UiTitleListKey;
import com.tandbergtv.cms.portal.content.titlelist.client.tab.UiTitleListRecord;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.ResizableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.dnd.TableRowBeforeMoveEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.dnd.TableRowMoveEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.dnd.TableRowMoveHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TitleListDetailView
extends Composite
implements DetailView<UiTitleListKey, UiTitleListRecord> {
    private static final String DRAG_HANDLE_IMAGE_URL = "neptune_widget_toolkit/images/drag_drop_cue.gif";
    private static final String STYLE = "content-TitleListDetailView";
    private static final String STYLE_PROPERTY_PANEL = "content-TitleListDetailView-properties";
    private static final String STYLE_TABLE = "content-TitleListDetailView-titlesTable";
    private static final String INVALID_ASSETS = "invalidAssets";
    private String spec;
    private NeptuneSecurity security;
    private UiTitleListRecord record;
    private DetailViewCallback<UiTitleListKey, UiTitleListRecord> callback;
    private String previousName;
    private String previousDescription;
    private String previousType;
    private Long previousContentClass;
    private List<UiMetadataField> previousListMetadataFields;
    private Map<UiAssetMap, AssetMetadataForm> uiAssetMapFormMap;
    private MessageArea messageArea;
    private TitleListConstants constants = (TitleListConstants)GWT.create(TitleListConstants.class);
    private ITitleListServiceAsync service = (ITitleListServiceAsync)GWT.create(ITitleListService.class);
    private ContentConstants contentConstants = (ContentConstants)GWT.create(ContentConstants.class);
    private ResizableContainer resizableContainer;
    private TitleListForm titleListForm;
    private int FORM_CONTAINER_BORDER_WIDTH = 1;
    private List<AssetMetadataForm> assetMetadataFormList;
    VerticalContainer mainContainer;
    private int SPACING_BETWEEN_MESSAGE_TABLE = 2;
    VerticalContainer propertiesButtonsContainer = new VerticalContainer();
    VerticalContainer itemsButtonsContainer = new VerticalContainer();
    TitleListsPanel parentPanel = null;
    private BusyIndicator busyIndicator;
    private static int CHECKBOX_COLUMN = 1;
    private static int DATA_ROW = 1;
    private static String ID_COLUMN_NAME = "id";

    public TitleListDetailView(String spec, NeptuneSecurity security, UiTitleListRecord record, DetailViewCallback<UiTitleListKey, UiTitleListRecord> callback, TitleListsPanel parentPanel) {
        this.parentPanel = parentPanel;
        this.messageArea = parentPanel.getMessageArea();
        this.init(spec, security, record, callback);
        this.initWidget((Widget)this.mainContainer);
        this.showBusyIndicator();
    }

    private void fetchMetadata(String spec, UiTitleListRecord record) {
        TitleListSearchServiceAsync searchService = (TitleListSearchServiceAsync)GWT.create(TitleListSearchService.class);
        searchService.getFullAssetList(record.getKey().getId(), (AsyncCallback<UiTitleList>)new NeptuneAsyncCallback<UiTitleList>(){

            public void onNeptuneFailure(Throwable caught) {
                TitleListDetailView.this.hideBusyIndicator();
                TitleListDetailView.this.callback.cancel(null);
            }

            public void onNeptuneSuccess(UiTitleList uiTitleList) {
                if (uiTitleList.hasViewPermission()) {
                    TitleListDetailView.this.copyProperties(uiTitleList, TitleListDetailView.this.record.getTitleList());
                    TitleListDetailView.this.buildView(uiTitleList);
                } else {
                    TitleListDetailView.this.buildNoPermissionView(uiTitleList);
                }
                TitleListDetailView.this.hideBusyIndicator();
            }
        });
    }

    private void copyProperties(UiTitleList sourceUiTitleList, UiTitleList destUiTitleList) {
        destUiTitleList.setKey(sourceUiTitleList.getKey());
        destUiTitleList.setAssets(sourceUiTitleList.getAssets());
        destUiTitleList.setAssetColumns(sourceUiTitleList.getAssetColumns());
        destUiTitleList.setTitleColumns(sourceUiTitleList.getTitleColumns());
        destUiTitleList.setTitleListColumns(sourceUiTitleList.getTitleListColumns());
    }

    private void init(String spec, NeptuneSecurity security, UiTitleListRecord record, DetailViewCallback<UiTitleListKey, UiTitleListRecord> callback) {
        this.spec = spec;
        this.security = security;
        this.record = record;
        this.callback = callback;
        this.uiAssetMapFormMap = new HashMap<UiAssetMap, AssetMetadataForm>();
        this.assetMetadataFormList = new ArrayList<AssetMetadataForm>();
        this.titleListForm = new TitleListForm(record.getTitleList(), new NeptuneAsyncCallback<TitleListForm>(){

            public void onNeptuneFailure(Throwable caught) {
                Window.alert((String)TitleListDetailView.this.constants.failureCreatingForm());
            }

            public void onNeptuneSuccess(TitleListForm result) {
                TitleListDetailView.this.fetchMetadata(TitleListDetailView.this.spec, TitleListDetailView.this.record);
            }
        });
        this.titleListForm.setBorderWidth(this.FORM_CONTAINER_BORDER_WIDTH);
        this.mainContainer = new VerticalContainer();
        this.mainContainer.setSpacing(this.SPACING_BETWEEN_MESSAGE_TABLE);
        this.mainContainer.setStyleName(STYLE);
        this.itemsButtonsContainer = new VerticalContainer();
        this.itemsButtonsContainer.addStyleName("nwt-TableListViewPanel");
        this.propertiesButtonsContainer = new VerticalContainer();
        this.propertiesButtonsContainer.addStyleName("nwt-TableListViewPanel");
        final long assetListId = record.getKey().getId();
        this.service.getErrorsFromHttpSession(assetListId, new AsyncCallback<Map<String, Integer>>(){

            public void onFailure(Throwable caught) {
                Window.alert((String)TitleListDetailView.this.constants.errorsMapError());
            }

            public void onSuccess(Map<String, Integer> errorsMap) {
                Integer invalidAssets = errorsMap.get(TitleListDetailView.INVALID_ASSETS + assetListId);
                if (invalidAssets != null && invalidAssets > 0) {
                    TitleListDetailView.this.messageArea.setInfoMessage(TitleListDetailView.this.constants.invalidAssetsContentClass());
                }
            }
        });
        this.busyIndicator = new BusyIndicator();
    }

    public void refresh() {
        this.mainContainer.clear();
        this.itemsButtonsContainer.clear();
        this.propertiesButtonsContainer.clear();
        this.showBusyIndicator();
        this.fetchMetadata(this.spec, this.record);
    }

    public void commit() {
        this.previousName = this.record.getTitleList().getName();
        this.previousDescription = this.record.getTitleList().getDescription();
        this.previousType = this.record.getTitleList().getType();
        this.previousContentClass = this.record.getTitleList().getContentClass();
        this.previousListMetadataFields = this.record.getTitleList().getMetadataFields();
        this.record.getTitleList().setName(this.titleListForm.getName());
        this.record.getTitleList().setDescription(this.titleListForm.getDescription());
        this.record.getTitleList().setType(this.titleListForm.getType());
        this.record.getTitleList().setContentClass(this.titleListForm.getContentClass());
        this.record.getTitleList().setMetadataFields(this.titleListForm.getMetadataFields());
        for (UiAssetMap uiAssetMap : this.record.getTitleList().getAssets()) {
            AssetMetadataForm form = this.uiAssetMapFormMap.get(uiAssetMap);
            if (form == null) continue;
            ArrayList<UiMetadataField> metadaFields = new ArrayList<UiMetadataField>();
            metadaFields.addAll(form.getMetadataFields());
            uiAssetMap.setMetadataFields(metadaFields);
        }
    }

    private void removeAssetsFromRecord(List<Long> titleAssetRecordIds) {
        for (Long recordId : titleAssetRecordIds) {
            this.record.getTitleList().getAssets().remove(new UiAssetMap(recordId));
        }
    }

    public UiTitleListRecord getRecord() {
        return this.record;
    }

    public void revert() {
        this.record.getTitleList().setName(this.previousName);
        this.record.getTitleList().setDescription(this.previousDescription);
        this.record.getTitleList().setType(this.previousType);
        this.record.getTitleList().setContentClass(this.previousContentClass);
        this.record.getTitleList().setMetadataFields(this.previousListMetadataFields);
    }

    public String getStyleName() {
        return null;
    }

    public Widget getWidget() {
        return this;
    }

    public void release() {
    }

    public void saveFailed(Throwable throwable) {
        if (throwable instanceof UiValidationException) {
            this.revert();
            this.messageArea.setErrorHTML(this.getErrorMessageFromList(((UiValidationException)((Object)throwable)).getErrorCodes()));
        }
    }

    private String getErrorMessageFromList(List<String> errorCodes) {
        String message = "";
        if (errorCodes != null) {
            Iterator<String> i = errorCodes.iterator();
            while (i.hasNext()) {
                String code = i.next();
                message = String.valueOf(message) + this.contentConstants.getString(code);
                if (!i.hasNext()) continue;
                message = String.valueOf(message) + "<br>";
            }
        }
        return message;
    }

    private void buildView(UiTitleList uiTitleList) {
        Widget assetTable = this.prepareTable(uiTitleList);
        this.propertiesButtonsContainer.add(this.createButtonPanel((FlexTableContainer)assetTable));
        this.itemsButtonsContainer.add(this.createItemsButtonPanel((FlexTableContainer)assetTable));
        VerticalContainer propertyTableContainer = new VerticalContainer();
        propertyTableContainer.setStylePrimaryName(STYLE_PROPERTY_PANEL);
        propertyTableContainer.add((Widget)this.titleListForm);
        propertyTableContainer.setCellHorizontalAlignment((Widget)this.titleListForm, HasHorizontalAlignment.ALIGN_LEFT);
        int tabIndex = 0;
        if (this.parentPanel.getResizableContainer() != null) {
            tabIndex = this.parentPanel.getResizableContainer().getTabContainer().getTabBar().getSelectedTab();
        }
        this.parentPanel.removeResizableContainer();
        this.resizableContainer = new ResizableContainer((Widget)propertyTableContainer, "Properties", null);
        this.resizableContainer.addBottomWidget("Properties", (Widget)this.propertiesButtonsContainer);
        this.resizableContainer.addTab(assetTable, "Items");
        this.resizableContainer.addBottomWidget("Items", (Widget)this.itemsButtonsContainer);
        this.parentPanel.addResizableContainer(this.resizableContainer);
        if (tabIndex == 1) {
            this.resizableContainer.selectTab("Items");
        }
        this.resizableContainer.getTabContainer().addSelectionHandler((SelectionHandler)new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> event) {
                TitleListDetailView.this.messageArea.reset();
            }
        });
        this.titleListForm.initMetadataFields(uiTitleList.getMetadataFields());
    }

    private void buildNoPermissionView(UiTitleList uiTitleList) {
        this.messageArea.setErrorMessage(this.constants.noViewPermission());
        ButtonWidget cancelTitlesButton = new ButtonWidget(this.constants.cancelButtonName(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                TitleListDetailView.this.callback.cancel((DetailView)TitleListDetailView.this);
                History.newItem((String)"Content.TitleLists.View");
            }
        });
        cancelTitlesButton.removeStyleName("gwt-Button");
        cancelTitlesButton.addStyleName("ebBtn");
        this.parentPanel.removeResizableContainer();
        this.resizableContainer = new ResizableContainer((Widget)new SimpleContainer(), "Items", null);
        this.resizableContainer.addBottomWidget("Items", (Widget)cancelTitlesButton);
        this.parentPanel.addResizableContainer(this.resizableContainer);
    }

    private Widget createItemsButtonPanel(final FlexTableContainer assetTable) {
        SimplePanel buttonPanel = new SimplePanel();
        HorizontalContainer buttonContainer = new HorizontalContainer();
        if (this.security.isUserInRole("AssetListManagement_Modify")) {
            ButtonWidget saveButton = new ButtonWidget(this.constants.saveButtonName(), new ClickHandler(){

                public void onClick(ClickEvent event) {
                    if (TitleListDetailView.this.titleListForm.isValid() && TitleListDetailView.this.allAssetMetadataFormsValid()) {
                        TitleListDetailView.this.callback.save((DetailView)TitleListDetailView.this);
                    } else {
                        String invalidMessage = TitleListDetailView.this.generateInvalidMessage();
                        TitleListDetailView.this.messageArea.setErrorHTML(invalidMessage);
                        TitleListDetailView.this.resizableContainer.updateSize();
                    }
                }
            });
            buttonContainer.addStyleName("cms_button_container");
            saveButton.removeStyleName("gwt-Button");
            saveButton.addStyleName("ebBtn");
            saveButton.addStyleName("ebBtn_color_green");
            saveButton.addStyleName("save_button_icon");
            buttonContainer.add((Widget)saveButton);
        }
        if (this.security.isUserInRole("AssetListManagement_Modify")) {
            ButtonWidget addAssetsButton = new ButtonWidget(this.constants.addAssetsButtonName(), new ClickHandler(){

                public void onClick(ClickEvent event) {
                    History.newItem((String)("Content.Search?titleListId=" + TitleListDetailView.this.record.getKey().getId()));
                    TitleListDetailView.this.resizableContainer.selectTab("Items");
                }
            });
            addAssetsButton.removeStyleName("gwt-Button");
            addAssetsButton.addStyleName("ebBtn");
            addAssetsButton.addStyleName("addgreen_button_icon");
            ButtonWidget removeAssetsButton = new ButtonWidget(this.constants.removeAssetsButtonName(), new ClickHandler(){

                public void onClick(ClickEvent event) {
                    ArrayList<Long> recordsToRemove = new ArrayList<Long>();
                    ArrayList<Long> titleIdsToRemove = new ArrayList<Long>();
                    int oldIndex = 0;
                    int i = DATA_ROW;
                    while (i < assetTable.getRowCount()) {
                        if (((CheckBoxWidget)assetTable.getWidget(i, CHECKBOX_COLUMN)).getValue().booleanValue()) {
                            UiTitleList uiTitleList = TitleListDetailView.this.record.getTitleList();
                            UiAssetMap uiAssetMap = uiTitleList.getAssets().get(i - oldIndex - 1);
                            recordsToRemove.add(uiAssetMap.getId());
                            titleIdsToRemove.add(uiAssetMap.getTitleId());
                        }
                        oldIndex = i - oldIndex;
                        i += 2;
                    }
                    if (recordsToRemove.size() == 0) {
                        TitleListDetailView.this.messageArea.setErrorMessage(TitleListDetailView.this.constants.assetSelectionRequired());
                        TitleListDetailView.this.refresh();
                        return;
                    }
                    TitleListDetailView.this.removeAssets(TitleListDetailView.this.record.getKey().getId(), recordsToRemove, titleIdsToRemove);
                }
            });
            removeAssetsButton.removeStyleName("gwt-Button");
            removeAssetsButton.addStyleName("ebBtn");
            removeAssetsButton.addStyleName("delete_button_icon");
            buttonContainer.add((Widget)addAssetsButton);
            buttonContainer.add((Widget)removeAssetsButton);
        }
        ButtonWidget cancelTitlesButton = new ButtonWidget(this.constants.cancelButtonName(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                TitleListDetailView.this.callback.cancel((DetailView)TitleListDetailView.this);
                History.newItem((String)"Content.TitleLists.View");
            }
        });
        cancelTitlesButton.removeStyleName("gwt-Button");
        cancelTitlesButton.addStyleName("ebBtn");
        buttonContainer.add((Widget)cancelTitlesButton);
        buttonPanel.add((Widget)buttonContainer);
        return buttonPanel;
    }

    private Widget createButtonPanel(FlexTableContainer assetTable) {
        SimplePanel buttonPanel = new SimplePanel();
        HorizontalContainer buttonContainer = new HorizontalContainer();
        if (this.security.isUserInRole("AssetListManagement_Modify")) {
            ButtonWidget saveButton = new ButtonWidget(this.constants.saveButtonName(), new ClickHandler(){

                public void onClick(ClickEvent event) {
                    if (TitleListDetailView.this.titleListForm.isValid() && TitleListDetailView.this.allAssetMetadataFormsValid()) {
                        TitleListDetailView.this.callback.save((DetailView)TitleListDetailView.this);
                    } else {
                        String invalidMessage = TitleListDetailView.this.generateInvalidMessage();
                        TitleListDetailView.this.messageArea.setErrorHTML(invalidMessage);
                        TitleListDetailView.this.resizableContainer.updateSize();
                    }
                }
            });
            buttonContainer.addStyleName("cms_button_container");
            saveButton.removeStyleName("gwt-Button");
            saveButton.addStyleName("ebBtn");
            saveButton.addStyleName("ebBtn_color_green");
            saveButton.addStyleName("save_button_icon");
            buttonContainer.add((Widget)saveButton);
        }
        ButtonWidget cancelTitlesButton = new ButtonWidget(this.constants.cancelButtonName(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                TitleListDetailView.this.callback.cancel((DetailView)TitleListDetailView.this);
                History.newItem((String)"Content.TitleLists.View");
            }
        });
        cancelTitlesButton.removeStyleName("gwt-Button");
        cancelTitlesButton.addStyleName("ebBtn");
        buttonContainer.add((Widget)cancelTitlesButton);
        buttonPanel.add((Widget)buttonContainer);
        return buttonPanel;
    }

    private String generateInvalidMessage() {
        StringBuffer sbInvalidMessage = new StringBuffer(this.constants.invalidFormData());
        for (String invalidFieldMessage : this.titleListForm.getInvalidFieldsMessages()) {
            sbInvalidMessage.append("\n - ");
            sbInvalidMessage.append(invalidFieldMessage);
        }
        for (AssetMetadataForm amf : this.assetMetadataFormList) {
            List<String> invalidFieldMessageList = amf.getInvalidFieldsMessages();
            if (invalidFieldMessageList.size() > 0) {
                sbInvalidMessage.append("<br>  ");
                sbInvalidMessage.append(this.constants.invalidElementFormData());
                sbInvalidMessage.append(" ");
                sbInvalidMessage.append(amf.getUiAssetMap().getTitleId());
                sbInvalidMessage.append("-");
                sbInvalidMessage.append(amf.getUiAssetMap().getAsset().getType());
            }
            for (String invalidFieldMessage : invalidFieldMessageList) {
                sbInvalidMessage.append("<br>    - ");
                sbInvalidMessage.append(invalidFieldMessage);
            }
        }
        return sbInvalidMessage.toString();
    }

    private boolean allAssetMetadataFormsValid() {
        boolean allValid = true;
        for (AssetMetadataForm amf : this.assetMetadataFormList) {
            if (amf.isValid()) continue;
            allValid = false;
            break;
        }
        return allValid;
    }

    private void removeAssets(long titleListId, final List<Long> titleAssetRecordIds, final List<Long> titleIds) {
        this.service.removeAssetsFromTitleList(titleListId, titleAssetRecordIds, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                StringBuilder sb = new StringBuilder();
                for (Long titleId : titleIds) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(titleId);
                }
                TitleListDetailView.this.messageArea.setErrorMessage(String.valueOf(TitleListDetailView.this.constants.removeAssetsFailureMessage()) + sb.toString());
                TitleListDetailView.this.refresh();
            }

            public void onNeptuneSuccess(Void result) {
                StringBuilder sb = new StringBuilder();
                for (Long titleId : titleIds) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(titleId);
                }
                TitleListDetailView.this.removeAssetsFromRecord(titleAssetRecordIds);
                TitleListDetailView.this.messageArea.setInfoMessage(String.valueOf(TitleListDetailView.this.constants.removeAssetsSuccessMessage()) + " " + sb.toString());
                TitleListDetailView.this.refresh();
            }
        });
    }

    private Widget prepareTable(UiTitleList uiTitleList) {
        LabelWidget label;
        List<UiMetadataField> elementMetadataFieldsFromType;
        final FlexTableContainer table = new FlexTableContainer();
        table.setStylePrimaryName(STYLE_TABLE);
        TitleListTableRowDragController dragController = new TitleListTableRowDragController((AbsolutePanel)RootPanel.get(), (FlexTable)table);
        TitleListRowMoveController rowDropController = new TitleListRowMoveController((FlexTable)table);
        rowDropController.addTableRowMoveHandler(new TableRowMoveHandler(){

            public void onBeforeRowMove(TableRowBeforeMoveEvent event) {
                if (event.getTargetRowIndex() <= 0) {
                    event.cancel();
                }
            }

            public void onRowMove(TableRowMoveEvent event) {
                int oldIndex = event.getOldRowIndex();
                int newIndex = event.getRowIndex();
                if (newIndex % 2 == 0) {
                    ++newIndex;
                }
                TitleListDetailView.this.record.getTitleList().move((oldIndex - 1) / 2, (newIndex - 1) / 2);
                int start = oldIndex < newIndex ? oldIndex : newIndex;
                int end = oldIndex >= newIndex ? oldIndex : newIndex;
                int index = start;
                while (index <= end) {
                    if (index % 2 == 1) {
                        String styleName = index / 2 % 2 == 0 ? "table-data-odd-row" : "table-data-even-row";
                        table.getRowFormatter().setStyleName(index, styleName);
                    }
                    ++index;
                }
            }
        });
        dragController.registerDropController((DropController)rowDropController);
        int rowIndex = 0;
        int columnIndex = 0;
        table.getRowFormatter().addStyleName(rowIndex, "table-header-row");
        LabelWidget reorderHeadingLabel = new LabelWidget("");
        reorderHeadingLabel.addStyleName("table-header-nonSortable-text");
        table.setWidget(0, columnIndex++, (Widget)reorderHeadingLabel);
        if (this.security.isUserInRole("AssetListManagement_Modify")) {
            final CheckBoxWidget headerChkBox = new CheckBoxWidget();
            headerChkBox.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    int i = 1;
                    while (i < table.getRowCount()) {
                        ((CheckBoxWidget)table.getWidget(i, CHECKBOX_COLUMN)).setValue(headerChkBox.getValue());
                        i += 2;
                    }
                }
            });
            table.setWidget(rowIndex, columnIndex++, (Widget)headerChkBox);
        }
        if (!(elementMetadataFieldsFromType = this.titleListForm.getUiAssetListType().getElementMetadata()).isEmpty()) {
            table.setWidget(rowIndex, columnIndex, (Widget)new Label("+"));
            table.getCellFormatter().addStyleName(rowIndex, columnIndex, "nwt-TableColumnPanel-dataCell");
            table.getCellFormatter().addStyleName(rowIndex, columnIndex, "nwt-TableColumnPanel-dataCell-checkbox");
            ++columnIndex;
        }
        for (UiColumn col : this.record.getTitleList().getTitleColumns()) {
            label = new LabelWidget(col.getDisplayName());
            label.addStyleName("table-header-nonSortable-text");
            table.setWidget(rowIndex, columnIndex++, (Widget)label);
        }
        for (UiColumn col : this.record.getTitleList().getAssetColumns()) {
            label = new LabelWidget(col.getDisplayName());
            label.addStyleName("table-header-nonSortable-text");
            table.setWidget(rowIndex, columnIndex++, (Widget)label);
        }
        HTMLTable.CellFormatter cellFormatter = table.getCellFormatter();
        this.assetMetadataFormList = new ArrayList<AssetMetadataForm>();
        Iterator<UiAssetMap> iterator = uiTitleList.getAssets().iterator();
        while (iterator.hasNext()) {
            UiAssetMap uam;
            final UiAssetMap uiAssetMap = uam = iterator.next();
            rowIndex = table.getRowCount();
            columnIndex = 0;
            table.insertRow(rowIndex);
            ImageWidget handle = new ImageWidget(DRAG_HANDLE_IMAGE_URL);
            table.setWidget(rowIndex, columnIndex, (Widget)handle);
            cellFormatter.addStyleName(rowIndex, columnIndex, "nwt-TableColumnPanel-dataCell");
            cellFormatter.addStyleName(rowIndex, columnIndex, "nwt-TableColumnPanel-dataCell-icon");
            dragController.makeDraggable((Widget)handle);
            ++columnIndex;
            if (this.security.isUserInRole("AssetListManagement_Modify")) {
                CheckBoxWidget dataRowChkbox = new CheckBoxWidget();
                dataRowChkbox.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        if (((CheckBoxWidget)table.getWidget(0, CHECKBOX_COLUMN)).getValue().booleanValue()) {
                            ((CheckBoxWidget)table.getWidget(0, CHECKBOX_COLUMN)).setValue(Boolean.valueOf(false));
                        }
                    }
                });
                table.setWidget(rowIndex, columnIndex, (Widget)dataRowChkbox);
                cellFormatter.addStyleName(rowIndex, columnIndex, "nwt-TableColumnPanel-dataCell");
                cellFormatter.addStyleName(rowIndex, columnIndex, "nwt-TableColumnPanel-dataCell-checkbox");
                ++columnIndex;
            }
            SimplePanel expandedPanel = new SimplePanel();
            if (!elementMetadataFieldsFromType.isEmpty()) {
                AssetMetadataForm assetMetadataForm = new AssetMetadataForm(uiTitleList.getKey().getId(), uiAssetMap, elementMetadataFieldsFromType);
                assetMetadataForm.initMetadataFields(uiAssetMap.getMetadataFields());
                this.assetMetadataFormList.add(assetMetadataForm);
                this.uiAssetMapFormMap.put(uiAssetMap, assetMetadataForm);
                expandedPanel.add((Widget)assetMetadataForm);
                expandedPanel.setVisible(false);
                final ExpandCollapseButton expandCollapseButton = new ExpandCollapseButton((Panel)expandedPanel);
                expandCollapseButton.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        int clickedRowIndex = table.getCellForEvent(event).getRowIndex();
                        TitleListDetailView.this.handleExpandCollapseClick(table, clickedRowIndex + 1, expandCollapseButton);
                    }
                });
                table.setWidget(rowIndex, columnIndex, (Widget)expandCollapseButton);
                table.getCellFormatter().addStyleName(rowIndex, columnIndex, "nwt-TableColumnPanel-dataCell");
                table.getCellFormatter().addStyleName(rowIndex, columnIndex, "nwt-TableColumnPanel-dataCell-checkbox");
                ++columnIndex;
            }
            String styleName = rowIndex / 2 % 2 == 0 ? "table-data-odd-row" : "table-data-even-row";
            table.getRowFormatter().setStyleName(rowIndex, styleName);
            for (UiColumn col : this.record.getTitleList().getTitleColumns()) {
                String fieldInternalColumnName = TableColumnNameHelper.getColumnName((String)col.getName(), (String)col.getSectionName());
                UiField field = this.getFieldForTitleColumn(uam.getTitle(), col);
                String fieldValue = field != null ? field.getValue() : "";
                LabelWidget label2 = new LabelWidget(fieldValue);
                if (fieldInternalColumnName.equalsIgnoreCase(ID_COLUMN_NAME) && this.security.isUserInRole("AssetManagement_View")) {
                    label2.setStyleName("table-data-link");
                    label2.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            History.newItem((String)("Content.Search.Id=" + uiAssetMap.getTitle().getTitleId()));
                        }
                    });
                } else {
                    label2.addStyleName("table-data-text");
                }
                table.setWidget(rowIndex, columnIndex, (Widget)label2);
                cellFormatter.addStyleName(rowIndex, columnIndex, "nwt-TableColumnPanel-dataCell");
                String cellStyle = this.getCellStyle(col);
                if (cellStyle != null) {
                    cellFormatter.addStyleName(rowIndex, columnIndex, cellStyle);
                }
                ++columnIndex;
            }
            for (UiColumn col : this.record.getTitleList().getAssetColumns()) {
                UiField field = this.getFieldForAssetColumn(uam.getAsset(), col);
                String fieldValue = field != null ? field.getValue() : "";
                LabelWidget label3 = new LabelWidget(fieldValue);
                label3.addStyleName("table-data-text");
                table.setWidget(rowIndex, columnIndex, (Widget)label3);
                cellFormatter.addStyleName(rowIndex, columnIndex, "nwt-TableColumnPanel-dataCell");
                String cellStyle = this.getCellStyle(col);
                if (cellStyle != null) {
                    cellFormatter.addStyleName(rowIndex, columnIndex, cellStyle);
                }
                ++columnIndex;
            }
            table.getRowFormatter().addStyleName(++rowIndex, "display-none");
            table.setWidget(rowIndex, 0, (Widget)new SimplePanel());
            table.setWidget(rowIndex, 1, (Widget)expandedPanel);
            ((FlexTable.FlexCellFormatter)table.getCellFormatter()).setColSpan(rowIndex, 1, columnIndex - 1);
        }
        return table;
    }

    private void handleExpandCollapseClick(FlexTableContainer table, int rowIndex, ExpandCollapseButton expandCollapseButton) {
        expandCollapseButton.changeState();
        if (expandCollapseButton.isExpanded()) {
            table.getRowFormatter().removeStyleName(rowIndex, "display-none");
        } else {
            table.getRowFormatter().addStyleName(rowIndex, "display-none");
        }
    }

    private UiField getFieldForTitleColumn(UiTitle title, UiColumn column) {
        UiField field = null;
        String columnName = TableColumnNameHelper.getColumnName((String)column.getName(), (String)column.getSectionName());
        for (UiField f : title.getFields()) {
            String fieldName = TableColumnNameHelper.getColumnName((String)f.getName(), (String)f.getParentAssetType());
            if (columnName == null || !columnName.equals(fieldName)) continue;
            field = f;
            break;
        }
        return field;
    }

    private UiField getFieldForAssetColumn(UiAsset asset, UiColumn column) {
        UiField field = null;
        String columnName = TableColumnNameHelper.getColumnName((String)column.getName(), null);
        if (columnName.equals("type")) {
            field = new UiField("type", column.getDisplayName(), asset.getType());
        } else {
            for (UiField f : asset.getFields()) {
                String fieldName = TableColumnNameHelper.getColumnName((String)f.getName(), (String)f.getParentAssetType());
                if (columnName == null || !columnName.equals(fieldName)) continue;
                field = f;
                break;
            }
        }
        return field;
    }

    private String getCellStyle(UiColumn column) {
        String cellStyle = "nwt-TableColumnPanel-dataCell-general";
        if (column.getDataType() != null) {
            switch (column.getDataType()) {
                case BOOLEAN: 
                case STRING: {
                    cellStyle = "nwt-TableColumnPanel-dataCell-text";
                    break;
                }
                case DATE: 
                case TIME: {
                    cellStyle = "nwt-TableColumnPanel-dataCell-date";
                    break;
                }
                case FLOAT: 
                case INTEGER: {
                    cellStyle = "nwt-TableColumnPanel-dataCell-numeric";
                }
            }
        }
        return cellStyle;
    }

    private void showBusyIndicator() {
        this.busyIndicator.center();
    }

    private void hideBusyIndicator() {
        this.busyIndicator.hide();
    }

    protected void onUnload() {
        this.hideBusyIndicator();
        super.onUnload();
    }
}

