/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.titlelist.client.tab;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.contentclass.model.UIContentClass;
import com.tandbergtv.cms.portal.content.client.contentclass.service.IContentClassViewService;
import com.tandbergtv.cms.portal.content.client.contentclass.service.IContentClassViewServiceAsync;
import com.tandbergtv.cms.portal.content.titlelist.client.i18n.TitleListConstants;
import com.tandbergtv.cms.portal.content.titlelist.client.imageeditor.TypedImageBoxWidget;
import com.tandbergtv.cms.portal.content.titlelist.client.model.SaveImageRequest;
import com.tandbergtv.cms.portal.content.titlelist.client.model.UiAssetListType;
import com.tandbergtv.cms.portal.content.titlelist.client.model.UiDataType;
import com.tandbergtv.cms.portal.content.titlelist.client.model.UiMetadataField;
import com.tandbergtv.cms.portal.content.titlelist.client.model.UiTitleList;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.ITitleListTypeService;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.ITitleListTypeServiceAsync;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.DateWidgetConfiguration;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.DefaultDataTypeWidgetFactory;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.StringWidgetConfiguration;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.TimeWidgetConfiguration;
import com.tandbergtv.cms.portal.ui.title.client.view.datatype.factory.WidgetConfiguration;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextAreaWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.DataTypeWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedTextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IValueConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.StringConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.ValueFormatException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TitleListForm
extends Composite {
    private static final String TIME_FORMAT = "HH:mm:ss";
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String OFFER = "Offer";
    private TitleListConstants constants = (TitleListConstants)GWT.create(TitleListConstants.class);
    private ITitleListTypeServiceAsync titleListTypeService = (ITitleListTypeServiceAsync)GWT.create(ITitleListTypeService.class);
    private IContentClassViewServiceAsync contentClassService = (IContentClassViewServiceAsync)GWT.create(IContentClassViewService.class);
    private VerticalContainer verticalContainer;
    private FormContainer form;
    private TypedTextBoxWidget<String> nameWidget;
    private TextAreaWidget descriptionWidget;
    private int DESCRIPTION_VISIBLE_COUNT = 5;
    private int DESCRIPTION_CHAR_WIDTH = 40;
    private ListBoxWidget<String> typeWidget;
    private ListBoxWidget<Long> contentClassWidget;
    private List<ButtonWidget> buttonsList;
    private UiTitleList uiTitleList;
    private Map<UiMetadataField, DataTypeWidget<?>> metadataFieldsMap;
    private NeptuneAsyncCallback<TitleListForm> callback;
    private UiAssetListType uiAssetListType;
    private BusyIndicator busyIndicator;

    public TitleListForm() {
        this(null, null);
    }

    public TitleListForm(UiTitleList uiTitleList, NeptuneAsyncCallback<TitleListForm> callback) {
        this.uiTitleList = uiTitleList;
        this.callback = callback;
        this.metadataFieldsMap = new HashMap();
        this.busyIndicator = new BusyIndicator();
        this.init();
    }

    private void init() {
        this.verticalContainer = new VerticalContainer();
        this.buttonsList = new ArrayList<ButtonWidget>();
        IValueConverter<String> converter = new IValueConverter<String>(){

            public String getStringValue(String typedValue) {
                return typedValue;
            }

            public String getTypedValue(String value) throws ValueFormatException {
                if ((value = value.trim()).equals("")) {
                    throw new ValueFormatException(TitleListForm.this.constants.requiredFieldToolTip());
                }
                return value;
            }
        };
        this.nameWidget = new TypedTextBoxWidget((IValueConverter)converter);
        this.nameWidget.setErrorToolTip(this.constants.requiredFieldToolTip());
        this.descriptionWidget = new TextAreaWidget();
        this.descriptionWidget.setCharacterWidth(this.DESCRIPTION_CHAR_WIDTH);
        this.descriptionWidget.setVisibleLines(this.DESCRIPTION_VISIBLE_COUNT);
        if (this.uiTitleList != null) {
            this.nameWidget.setValue((Object)this.uiTitleList.getName());
            this.descriptionWidget.setValue((Object)this.uiTitleList.getDescription());
        }
        this.typeWidget = this.getTitleListTypeListBox();
        this.contentClassWidget = this.getTitleListContentClassListBox();
        this.initBaseForm();
        this.verticalContainer.add((Widget)this.getForm());
        this.verticalContainer.setWidth("100%");
        this.initWidget((Widget)this.verticalContainer);
    }

    private void initBaseForm() {
        this.form = new FormContainer(HasHorizontalAlignment.ALIGN_LEFT);
        this.form.addRow(this.constants.titleListNameLabel(), this.nameWidget, true);
        this.form.addRow(this.constants.titleListTypeLabel(), this.typeWidget, true);
        this.form.addRow(this.constants.titleListDescriptionLabel(), (Widget)this.descriptionWidget);
        this.form.addRow(this.constants.titleListContentClassLabel(), this.contentClassWidget);
        for (ButtonWidget button : this.buttonsList) {
            this.form.addButton(button);
        }
    }

    private ListBoxWidget<String> getTitleListTypeListBox() {
        final ListBoxWidget lbTitleListTypes = new ListBoxWidget();
        lbTitleListTypes.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                TitleListForm.this.handleTypeChange();
            }
        });
        this.titleListTypeService.getTypesWithoutMetadata((AsyncCallback<List<UiAssetListType>>)new NeptuneAsyncCallback<List<UiAssetListType>>(){

            public void onNeptuneFailure(Throwable caught) {
                Window.alert((String)TitleListForm.this.constants.failureGettingTypes());
            }

            public void onNeptuneSuccess(List<UiAssetListType> result) {
                for (UiAssetListType uiAssetListType : result) {
                    lbTitleListTypes.addItem(uiAssetListType.getDisplayName(), (Object)uiAssetListType.getName());
                }
                if (TitleListForm.this.uiTitleList != null) {
                    TitleListForm.this.typeWidget.setSelectedItem((Object)TitleListForm.this.uiTitleList.getType());
                    TitleListForm.this.typeWidget.setEnabled(false);
                }
                TitleListForm.this.handleTypeChange();
            }
        });
        return lbTitleListTypes;
    }

    private ListBoxWidget<Long> getTitleListContentClassListBox() {
        final ListBoxWidget lbTitleListContentClass = new ListBoxWidget();
        this.contentClassService.getContentClassListWithoutMetadata((AsyncCallback)new NeptuneAsyncCallback<List<UIContentClass>>(){

            public void onNeptuneFailure(Throwable caught) {
                Window.alert((String)TitleListForm.this.constants.failureGettingContentClasses());
            }

            public void onNeptuneSuccess(List<UIContentClass> result) {
                lbTitleListContentClass.addItem("", null);
                for (UIContentClass uiContentClass : result) {
                    if (uiContentClass.getTypeId() == 1 || uiContentClass.getName().equalsIgnoreCase(TitleListForm.OFFER)) continue;
                    lbTitleListContentClass.addItem(uiContentClass.getName(), (Object)uiContentClass.getId());
                }
                if (TitleListForm.this.uiTitleList != null) {
                    TitleListForm.this.contentClassWidget.setSelectedItem((Object)TitleListForm.this.uiTitleList.getContentClass());
                    TitleListForm.this.contentClassWidget.setEnabled(false);
                }
            }
        });
        return lbTitleListContentClass;
    }

    private void handleTypeChange() {
        this.showBusyIndicator();
        this.titleListTypeService.getTypeByName((String)this.typeWidget.getSelectedItem(), (AsyncCallback<UiAssetListType>)new NeptuneAsyncCallback<UiAssetListType>(){

            public void onNeptuneFailure(Throwable caught) {
                Window.alert((String)TitleListForm.this.constants.failureGettingType());
                TitleListForm.this.hideBusyIndicator();
            }

            public void onNeptuneSuccess(UiAssetListType result) {
                TitleListForm.this.uiAssetListType = result;
                TitleListForm.this.verticalContainer.clear();
                TitleListForm.this.metadataFieldsMap.clear();
                TitleListForm.this.initBaseForm();
                TitleListForm.this.verticalContainer.add((Widget)TitleListForm.this.form);
                DefaultDataTypeWidgetFactory factory = new DefaultDataTypeWidgetFactory();
                factory.setInputDateFormat(TitleListForm.DATE_FORMAT);
                factory.setInputTimeFormat(TitleListForm.TIME_FORMAT);
                for (UiMetadataField metadataField : result.getListMetadata()) {
                    DataTypeWidget dataTypeWidget = TitleListForm.this.createDataTypeWidget(factory, metadataField);
                    if (dataTypeWidget == null) continue;
                    TitleListForm.this.metadataFieldsMap.put(metadataField, dataTypeWidget);
                    TitleListForm.this.form.addRow(metadataField.getDisplayName(), (Widget)dataTypeWidget, metadataField.isRequired());
                }
                if (TitleListForm.this.callback != null) {
                    TitleListForm.this.callback.onSuccess((Object)TitleListForm.this);
                }
                TitleListForm.this.hideBusyIndicator();
            }
        });
    }

    private DataTypeWidget<?> createDataTypeWidget(DefaultDataTypeWidgetFactory factory, UiMetadataField metadataField) {
        DataTypeWidget dataTypeWidget = null;
        if (UiDataType.BOOLEAN.equals((Object)metadataField.getDataType())) {
            dataTypeWidget = factory.createBooleanWidget(new WidgetConfiguration());
        } else if (UiDataType.DATE.equals((Object)metadataField.getDataType())) {
            DateWidgetConfiguration dateConfig = new DateWidgetConfiguration();
            dateConfig.setDateFormat(DATE_FORMAT);
            dataTypeWidget = factory.createDateWidget(dateConfig);
        } else if (UiDataType.FLOAT.equals((Object)metadataField.getDataType())) {
            dataTypeWidget = factory.createFloatWidget(new WidgetConfiguration());
        } else if (UiDataType.INTEGER.equals((Object)metadataField.getDataType())) {
            dataTypeWidget = factory.createIntegerWidget(new WidgetConfiguration());
        } else if (UiDataType.STRING.equals((Object)metadataField.getDataType())) {
            StringWidgetConfiguration swc = new StringWidgetConfiguration();
            List<UiMetadataField.Option> optionsList = metadataField.getOptions();
            if (optionsList != null && !optionsList.isEmpty()) {
                ArrayList<UIValueOption> options = new ArrayList<UIValueOption>();
                for (UiMetadataField.Option option : optionsList) {
                    UIValueOption uiso = new UIValueOption(option.getName(), option.getValue());
                    options.add(uiso);
                }
                swc.setAnyValueAllowed(false);
                swc.setOptions(options);
            }
            dataTypeWidget = factory.createStringWidget(swc);
        } else if (UiDataType.TIME.equals((Object)metadataField.getDataType())) {
            TimeWidgetConfiguration timeConfig = new TimeWidgetConfiguration();
            timeConfig.setTimeFormat(TIME_FORMAT);
            dataTypeWidget = factory.createTimeWidget(timeConfig);
        } else if (UiDataType.IMAGE.equals((Object)metadataField.getDataType())) {
            dataTypeWidget = this.createImageWidget(metadataField.getName());
        }
        return dataTypeWidget;
    }

    public FormContainer getForm() {
        return this.form;
    }

    public void addButton(ButtonWidget button) {
        this.buttonsList.add(button);
    }

    public void removeButton(ButtonWidget button) {
        this.buttonsList.remove(button);
    }

    public UiTitleList getCurrentUiTitleList() {
        UiTitleList uiTitleList = new UiTitleList();
        uiTitleList.setName((String)this.nameWidget.getValue());
        uiTitleList.setType((String)this.typeWidget.getSelectedItem());
        uiTitleList.setDescription(this.descriptionWidget.getValue());
        uiTitleList.setContentClass((Long)this.contentClassWidget.getSelectedItem());
        uiTitleList.setMetadataFields(new ArrayList<UiMetadataField>(this.metadataFieldsMap.keySet()));
        this.updateMetadataFields();
        return uiTitleList;
    }

    private void updateMetadataFields() {
        Set<Map.Entry<UiMetadataField, DataTypeWidget<?>>> listMetadataEntries = this.metadataFieldsMap.entrySet();
        for (Map.Entry<UiMetadataField, DataTypeWidget<?>> entry : listMetadataEntries) {
            entry.getKey().setValue(entry.getValue().getTextValue());
        }
    }

    public void setBorderWidth(int width) {
        this.verticalContainer.setBorderWidth(width);
    }

    public String getName() {
        return (String)this.nameWidget.getValue();
    }

    public String getDescription() {
        return this.descriptionWidget.getValue();
    }

    public String getType() {
        return (String)this.typeWidget.getSelectedItem();
    }

    public Long getContentClass() {
        return (Long)this.contentClassWidget.getSelectedItem();
    }

    public List<UiMetadataField> getMetadataFields() {
        this.updateMetadataFields();
        return new ArrayList<UiMetadataField>(this.metadataFieldsMap.keySet());
    }

    public void initMetadataFields(List<UiMetadataField> metadataFields) {
        block0: for (UiMetadataField uiMetadataField : metadataFields) {
            for (Map.Entry<UiMetadataField, DataTypeWidget<?>> entry : this.metadataFieldsMap.entrySet()) {
                if (!uiMetadataField.getName().equals(entry.getKey().getName())) continue;
                String value = uiMetadataField.getValue();
                entry.getValue().setTextValue(value);
                continue block0;
            }
        }
    }

    private TypedImageBoxWidget<String> createImageWidget(String metadataFieldName) {
        StringConverter converter = new StringConverter();
        SaveImageRequest saveImageRequest = new SaveImageRequest();
        if (this.uiTitleList != null) {
            saveImageRequest.setAssetListId(this.uiTitleList.getKey().getId());
            saveImageRequest.setMetadataFieldName(metadataFieldName);
        }
        TypedImageBoxWidget<String> widget = new TypedImageBoxWidget<String>((IValueConverter<String>)converter, saveImageRequest);
        return widget;
    }

    public UiAssetListType getUiAssetListType() {
        return this.uiAssetListType;
    }

    public boolean isValid() {
        return this.getInvalidFieldsMessages().size() == 0;
    }

    public List<String> getInvalidFieldsMessages() {
        ArrayList<String> invalidFields = new ArrayList<String>();
        if (!this.nameWidget.isValidValue()) {
            invalidFields.add(String.valueOf(this.constants.titleListNameLabel()) + " (" + this.nameWidget.getErrorToolTip() + ")");
        }
        Set<Map.Entry<UiMetadataField, DataTypeWidget<?>>> entries = this.metadataFieldsMap.entrySet();
        for (Map.Entry<UiMetadataField, DataTypeWidget<?>> entry : entries) {
            UiMetadataField field = entry.getKey();
            DataTypeWidget<?> widget = entry.getValue();
            if (field.isRequired() && (widget.getTextValue() == null || widget.getTextValue().trim().equals(""))) {
                invalidFields.add(String.valueOf(field.getDisplayName()) + " (" + this.constants.requiredFieldToolTip() + ")");
                widget.showValidationError(this.constants.requiredFieldToolTip());
            }
            if (widget.isValidValue()) continue;
            invalidFields.add(String.valueOf(field.getDisplayName()) + " (" + widget.getErrorToolTip() + ")");
        }
        return invalidFields;
    }

    private void showBusyIndicator() {
        this.busyIndicator.center();
    }

    private void hideBusyIndicator() {
        this.busyIndicator.hide();
    }

    protected void onUnload() {
        if (this.busyIndicator != null) {
            this.busyIndicator.hide();
        }
        super.onUnload();
    }
}

