/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.titlelist.client.tab;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.model.UiServiceItem;
import com.tandbergtv.cms.portal.content.client.tab.list.actionlist.ActionListDataProvider;
import com.tandbergtv.cms.portal.content.client.tab.list.actionlist.ServiceMap;
import com.tandbergtv.cms.portal.content.client.tab.list.goButton.ButtonClickListener;
import com.tandbergtv.cms.portal.content.titlelist.client.i18n.TitleListConstants;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.UiValidationException;
import com.tandbergtv.cms.portal.content.titlelist.client.tab.TitleListAnchorChangeListener;
import com.tandbergtv.cms.portal.content.titlelist.client.tab.TitleListCreatePanel;
import com.tandbergtv.cms.portal.content.titlelist.client.tab.TitleListDetailFeature;
import com.tandbergtv.cms.portal.content.titlelist.client.tab.TitleListsDataProvider;
import com.tandbergtv.cms.portal.content.titlelist.client.tab.UiTitleListKey;
import com.tandbergtv.cms.portal.content.titlelist.client.tab.UiTitleListRecord;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleActionService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleListService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.TitleListActionInput;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.ServiceLoader;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.ResizableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableDetailViewEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewChangeHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.BookmarkFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.BookmarkFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.CookieStoreBasedPageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.List;

public class TitleListsPanel
extends Composite
implements IView {
    private String spec;
    private ServiceLoader serviceLoader;
    private NeptuneSecurity security;
    private TitleListsDataProvider dataProvider;
    private PageFeature pageFeature;
    private SortFeatureImpl<UiTitleListKey, UiTitleListRecord> sortFeature;
    private BookmarkFeature bookmarkFeature;
    private TitleListDetailFeature detailFeature;
    private WidgetMenuItem.AnchorChangeListener anchorChangeListener;
    private VerticalContainer mainContainer;
    private Table<UiTitleListKey, UiTitleListRecord> table;
    private ListBoxWidget<String> actionsListBox;
    private ButtonWidget goButton;
    private Button createButton;
    private ListBoxWidget<String> parameterListBox;
    private HorizontalContainer actionListContainer;
    private BusyIndicator busyIndicator = new BusyIndicator();
    private ResizableContainer resizableContainer;
    private MessageArea messageArea;
    private HeaderPanel header;
    private TitleListConstants constants = (TitleListConstants)GWT.create(TitleListConstants.class);
    private static final int SPACING = 2;
    private static final String STYLE_NAME = "content-TitleListsPanel";

    public TitleListsPanel(String specification, NeptuneSecurity security, ServiceLoader serviceLoader) {
        this.spec = specification;
        this.serviceLoader = serviceLoader;
        this.security = security;
        this.dataProvider = new TitleListsDataProvider(this);
        this.messageArea = new MessageArea();
        this.dataProvider.setBusyNotifier(new TitleListsDataProvider.IBusyNotifier(){

            @Override
            public void startingToBeBusy() {
                TitleListsPanel.this.busyIndicator.center();
            }

            @Override
            public void doneBeingBusy() {
                TitleListsPanel.this.busyIndicator.hide();
            }
        });
        this.init();
    }

    private void init() {
        this.initWidgets();
        this.setContainers();
    }

    private void setContainers() {
        this.mainContainer.add((Widget)this.header);
        this.mainContainer.add((Widget)this.messageArea);
        this.mainContainer.add((Widget)this.resizableContainer);
    }

    private void initWidgets() {
        this.mainContainer = new VerticalContainer();
        this.createButton = new Button("Create");
        this.createButton.removeStyleName("gwt-Button");
        this.createButton.addStyleName("ebBtn");
        this.createButton.addStyleName("ebBtn_color_green");
        this.createButton.addStyleName("create_button_icon");
        this.mainContainer.setSpacing(2);
        this.mainContainer.setStylePrimaryName(STYLE_NAME);
        this.initWidget((Widget)this.mainContainer);
        this.header = new HeaderPanel("");
        this.header.setStyleName("content-header-style");
        this.buildActionsListWidget();
        this.table = new Table((DataProvider)this.dataProvider);
        this.resizableContainer = new ResizableContainer(this.table, "Title Lists", null);
        this.resizableContainer.addBottomWidget("Title Lists", (Widget)this.actionListContainer);
        this.table.addTableViewChangeHandler((TableViewChangeHandler)new TableViewChangeHandler<UiTitleListKey, UiTitleListRecord>(){

            public void onShowDetailView(TableDetailViewEvent<UiTitleListKey, UiTitleListRecord> event) {
                if (event.isCreateView()) {
                    TitleListsPanel.this.header.setLabel(TitleListsPanel.this.constants.titleListCreateHeading());
                } else {
                    TitleListsPanel.this.header.setLabel(String.valueOf(TitleListsPanel.this.constants.titleListViewEditHeading()) + " " + ((UiTitleListRecord)event.getRecord()).getTitleList().getName());
                }
            }

            public void onShowListView(TableViewEvent event) {
                TitleListsPanel.this.header.setLabel(TitleListsPanel.this.constants.titleListListHeading());
            }
        });
        this.pageFeature = new CookieStoreBasedPageFeatureImpl("cms-titlelists");
        this.dataProvider.setParentPageFeature(this.pageFeature);
        this.sortFeature = new SortFeatureImpl(this.dataProvider.getDefaultSortColumn(), SortOrder.ASCENDING);
        for (Column<?, UiTitleListRecord> col : this.dataProvider.getSortColumns()) {
            this.sortFeature.addSortableColumn(col);
        }
        this.dataProvider.setParentSortFeature(this.sortFeature);
        this.bookmarkFeature = new BookmarkFeatureImpl();
        this.detailFeature = new TitleListDetailFeature(this.spec, this.security, this);
        this.table.addSortFeature(this.sortFeature);
        this.table.addPageFeature(this.pageFeature);
        this.table.addDetailFeature((DetailFeature)this.detailFeature);
        this.table.addBookmarkFeature(this.bookmarkFeature);
        this.table.initialize((AsyncCallback)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
            }

            public void onNeptuneSuccess(Void result) {
            }
        });
        this.anchorChangeListener = new TitleListAnchorChangeListener(this);
        this.resizableContainer.addHeightOffsettingWidget((Widget)this.header);
        this.resizableContainer.addHeightOffsettingWidget((Widget)this.messageArea);
        this.resizableContainer.setOffsetHeight(10);
    }

    private void buildActionsListWidget() {
        this.actionListContainer = new HorizontalContainer();
        this.actionsListBox = new ListBoxWidget(false);
        this.parameterListBox = new ListBoxWidget(false);
        this.parameterListBox.setVisible(false);
        final ServiceMap serviceMap = new ServiceMap();
        ActionListDataProvider listItemProvider = new ActionListDataProvider(ITitleListService.class, this.serviceLoader, false);
        for (UiServiceItem item : listItemProvider.getItems(serviceMap)) {
            this.actionsListBox.addItem(item.getName(), (Object)item.getClassName());
        }
        this.goButton = new ButtonWidget(this.constants.titleListsGoButtonName());
        this.goButton.addClickHandler((ClickHandler)new ButtonClickListener(this.actionsListBox, this.parameterListBox, (IView)this, serviceMap));
        this.goButton.removeStyleName("gwt-Button");
        this.goButton.addStyleName("ebBtn");
        this.goButton.addStyleName("ebBtn_color_darkBlue");
        this.goButton.addStyleName("next_button_icon");
        this.createButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                History.newItem((String)"Content.TitleLists.Create");
            }
        });
        this.setWidgetsForNoAction();
        this.actionsListBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                TitleListsPanel.this.parameterListBox.setVisible(false);
                TitleListsPanel.this.goButton.setEnabled(false);
                int selectedIndex = TitleListsPanel.this.actionsListBox.getSelectedIndex();
                String displayName = TitleListsPanel.this.actionsListBox.getItemText(selectedIndex);
                if (displayName.trim().isEmpty()) {
                    TitleListsPanel.this.setWidgetsForNoAction();
                    return;
                }
                ITitleActionService selectedAction = serviceMap.getService(displayName);
                selectedAction.getServiceParameters((NeptuneAsyncCallback)new NeptuneAsyncCallback<List<String>>(){

                    public void onNeptuneFailure(Throwable caught) {
                        TitleListsPanel.this.parameterListBox.setVisible(false);
                        TitleListsPanel.this.reportFailure(caught);
                    }

                    public void onNeptuneSuccess(List<String> result) {
                        if (result != null) {
                            this.setParameterList(result);
                            TitleListsPanel.this.parameterListBox.setVisible(true);
                        }
                        TitleListsPanel.this.goButton.setEnabled(true);
                    }
                });
            }

            private void setParameterList(List<String> parameters) {
                TitleListsPanel.this.parameterListBox.clear();
                for (String p : parameters) {
                    TitleListsPanel.this.parameterListBox.addItem(p, (Object)p);
                }
            }
        });
        this.actionListContainer.addStyleName("cms_button_container");
        this.actionListContainer.add((Widget)this.createButton);
        if (!ClientAuthorizationManager.isAuthorized((String[])new String[]{"AssetListManagement_Create"})) {
            this.createButton.setVisible(false);
        }
        this.actionListContainer.add(this.actionsListBox);
        this.actionListContainer.add(this.parameterListBox);
        this.actionListContainer.add((Widget)this.goButton);
    }

    private void setWidgetsForNoAction() {
        this.actionsListBox.setSelectedItem((Object)"");
        this.parameterListBox.clear();
        this.parameterListBox.setVisible(false);
        this.goButton.setEnabled(false);
    }

    Table<UiTitleListKey, UiTitleListRecord> getTitleListsTable() {
        return this.table;
    }

    public void reportFailure(Throwable caught) {
        if (caught instanceof UiValidationException) {
            String messages = "";
            for (String message : ((UiValidationException)((Object)caught)).getErrorCodes()) {
                messages = String.valueOf(messages) + message + "\n";
            }
            this.messageArea.setErrorMessage(messages);
        } else {
            this.messageArea.setErrorMessage(caught.getMessage());
        }
        this.resizableContainer.updateSize();
    }

    public WidgetMenuItem.AnchorChangeListener getAnchorChangeListener() {
        return this.anchorChangeListener;
    }

    public void cleanup() {
        this.messageArea.reset();
    }

    public void removeResizableContainer() {
        this.mainContainer.remove((Widget)this.resizableContainer);
        this.mainContainer.clear();
    }

    public ResizableContainer getResizableContainer() {
        return this.resizableContainer;
    }

    public void setResizableContainer(ResizableContainer resizableContainer) {
        this.resizableContainer = resizableContainer;
    }

    public IActionInput getInputToExecution() {
        return new TitleListActionInput(this.spec);
    }

    public Widget getParentContainer() {
        return this.mainContainer;
    }

    public List<Long> getSeletedRecordIds() {
        List selectedIds = this.table.getSelectedRecords();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (UiTitleListRecord tr : selectedIds) {
            ids.add(tr.getKey().getId());
        }
        return ids;
    }

    public void refresh(String infoMessage) {
        this.mainContainer.clear();
        this.resizableContainer = new ResizableContainer(this.table, "Title Lists", null);
        this.resizableContainer.addBottomWidget("Title Lists", (Widget)this.actionListContainer);
        this.resizableContainer.addHeightOffsettingWidget((Widget)this.header);
        this.resizableContainer.addHeightOffsettingWidget((Widget)this.messageArea);
        this.resizableContainer.setOffsetHeight(10);
        this.resizableContainer.getTabContainer().getTabBar().setVisible(false);
        this.setContainers();
        this.table.getPageFeature().setPageNumber(1);
        this.table.showListView();
        this.table.refresh();
        this.table.updateAnchor();
        this.resizableContainer.updateSize();
        this.show(infoMessage);
        this.setWidgetsForNoAction();
    }

    public void show(String infoMessage) {
        if (infoMessage != null && !infoMessage.isEmpty()) {
            this.messageArea.setInfoMessage(infoMessage);
        }
        this.resizableContainer.updateSize();
    }

    public void show(boolean readOnly) {
        this.goButton.setEnabled(readOnly);
        this.actionsListBox.setEnabled(readOnly);
        this.parameterListBox.setEnabled(readOnly);
    }

    public void setReverseAnchorChangeListener(WidgetMenuItem.AnchorChangeListener reverseAnchorChangeListener) {
        this.table.setAnchorChangeNotifier(reverseAnchorChangeListener);
    }

    public boolean hasActions() {
        return this.actionsListBox.getItemCount() > 0;
    }

    public void addResizableContainer(ResizableContainer resizableContainer2) {
        this.mainContainer.add((Widget)this.header);
        this.mainContainer.add((Widget)this.messageArea);
        resizableContainer2.addHeightOffsettingWidget((Widget)this.header);
        resizableContainer2.addHeightOffsettingWidget((Widget)this.messageArea);
        resizableContainer2.setOffsetHeight(10);
        this.resizableContainer = resizableContainer2;
        this.mainContainer.add((Widget)resizableContainer2);
    }

    public MessageArea getMessageArea() {
        return this.messageArea;
    }

    public void setMessageArea(MessageArea messageArea) {
        this.messageArea = messageArea;
    }

    public void create() {
        this.mainContainer.clear();
        TitleListCreatePanel createPanel = new TitleListCreatePanel(this.spec);
        this.mainContainer.add((Widget)createPanel);
    }

    public void setTabSize() {
        if (this.resizableContainer != null & this.resizableContainer.getTabContainer().getTabBar().getTabCount() > 1) {
            this.resizableContainer.selectTab("Items");
        }
    }
}

