/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.titlelist.server;

import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.ericsson.cms.criteria.SearchColumn;
import com.ericsson.cms.criteria.info.PagingInfo;
import com.ericsson.cms.search.TitleSearchResult;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetList;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetListAssetMap;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetListElementMetadata;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetListMetadata;
import com.tandbergtv.cms.contentmgmt.titlelist.model.AssetListElementDataType;
import com.tandbergtv.cms.contentmgmt.titlelist.model.DataType;
import com.tandbergtv.cms.contentmgmt.titlelist.service.IAssetListManager;
import com.tandbergtv.cms.portal.content.client.model.UiAsset;
import com.tandbergtv.cms.portal.content.client.model.UiField;
import com.tandbergtv.cms.portal.content.client.model.UiTable;
import com.tandbergtv.cms.portal.content.client.model.UiTitle;
import com.tandbergtv.cms.portal.content.server.SpecificationServiceImpl;
import com.tandbergtv.cms.portal.content.titlelist.client.model.UiAssetMap;
import com.tandbergtv.cms.portal.content.titlelist.client.model.UiDataType;
import com.tandbergtv.cms.portal.content.titlelist.client.model.UiMetadataField;
import com.tandbergtv.cms.portal.content.titlelist.client.model.UiTitleList;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.TitleListSearchService;
import com.tandbergtv.cms.portal.content.titlelist.client.tab.UiTitleListKey;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.cms.title.search.IAssetInfoProvider;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.cms.title.search.entities.AssetSearchInfo;
import com.tandbergtv.cms.titlefilter.TitleFilter;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.NeptuneAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerUserManager;
import java.lang.annotation.Annotation;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.commons.codec.binary.Base64;
import org.aspectj.runtime.internal.AroundClosure;

public class TitleListSearchServiceImpl
implements TitleListSearchService,
NeptuneRemoteService {
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String TITLELIST_TABLE_NAME = "titleListColumns";
    private static final String TITLE_TABLE_NAME = "titleListTitleColumns";
    private static final String ASSET_TABLE_NAME = "titleListAssetColumns";
    private static final int PAGESIZE = 1000;
    private static IAssetInfoProvider assetInfoProvider = (IAssetInfoProvider)InjectionUtil.injectInstance((String)"cms/AssetInfoProviderProxy/local", IAssetInfoProvider.class);
    private static ITitleSearchService searchService = (ITitleSearchService)InjectionUtil.injectInstance((String)"cms/TitleSearchServiceProxy/local", ITitleSearchService.class);
    private IAssetListManager assetListManager = (IAssetListManager)InjectionUtil.injectInstance((String)"cms/AssetListManager/local", IAssetListManager.class);
    private IPartnerUserManager partnerUserManager = (IPartnerUserManager)InjectionUtil.injectInstance((String)"PartnerServices/PartnerUserManager", IPartnerUserManager.class);
    private static final String THUMBNAIL_COLUMN_NAME = "Thumbnail";
    private static /* synthetic */ Annotation ajc$anno$0;

    public String getRelativePath() {
        return "service/content/titleListSearchService";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    @Override
    @Transactional
    public UiTitleList getAssets(Long assetListId, List<UiColumn> titleColumns, List<UiColumn> assetColumns) throws NeptuneException {
        Long l = assetListId;
        List<UiColumn> list = titleColumns;
        List<UiColumn> list2 = assetColumns;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = TitleListSearchServiceImpl.class.getDeclaredMethod("getAssets", Long.class, List.class, List.class).getAnnotation(Transactional.class);
        }
        return (UiTitleList)TitleListSearchServiceImpl.getAssets_aroundBody1$advice(this, l, list, list2, transactionEnforcer, (Transactional)annotation, null);
    }

    public static List<SearchColumn> convertSearchColumns(List<UiColumn> uiColumns) {
        ArrayList<SearchColumn> result = new ArrayList<SearchColumn>();
        for (UiColumn uiCol : uiColumns) {
            FieldType fieldType = FieldType.PMM_TITLE;
            if (uiCol.getFieldType().equals((Object)UIFieldType.ASSET)) {
                fieldType = FieldType.ASSET;
            }
            result.add(new SearchColumn(uiCol.getSectionName(), uiCol.getName(), fieldType, uiCol.getDataType().name(), false));
        }
        return result;
    }

    @Override
    public UiTitleList getFullAssetList(Long assetListId) throws NeptuneException {
        SpecificationServiceImpl specService = new SpecificationServiceImpl();
        UiTable titleListTable = specService.getTable(TITLELIST_TABLE_NAME);
        UiTable titleTable = specService.getTable(TITLE_TABLE_NAME);
        UiTable assetTable = specService.getTable(ASSET_TABLE_NAME);
        AssetList assetList = this.assetListManager.get(assetListId.longValue());
        List titleColumns = titleTable.getColumns();
        this.filterThumbnailColumn(titleColumns);
        UiTitleList uiTitleList = this.getAssets(assetListId, titleColumns, assetTable.getColumns());
        if (this.userHasPermission(uiTitleList)) {
            uiTitleList.setKey(new UiTitleListKey(assetListId));
            uiTitleList.setTitleListColumns(titleListTable.getColumns());
            uiTitleList.setTitleColumns(titleTable.getColumns());
            uiTitleList.setAssetColumns(assetTable.getColumns());
            uiTitleList.setMetadataFields(this.convertToUiMetadataFields(assetList.getListMetadata()));
            this.createMetadataFieldsForUiAssetMaps(uiTitleList, assetList.getAssetsMap());
        } else {
            uiTitleList.setAssets(new ArrayList<UiAssetMap>());
            uiTitleList.setHasViewPermission(false);
        }
        return uiTitleList;
    }

    private boolean userHasPermission(UiTitleList uiTitleList) {
        boolean hasPermission = true;
        if (!this.partnerUserManager.isSelfPartnerUser()) {
            for (UiAssetMap uiAssetMap : uiTitleList.getAssets()) {
                boolean foundPartner = false;
                for (Partner partner : this.partnerUserManager.getPartnersByCurrentUser()) {
                    if (uiAssetMap.getTitle().getPartnerId() != null && !uiAssetMap.getTitle().getPartnerId().equals(partner.getId())) continue;
                    foundPartner = true;
                    break;
                }
                if (foundPartner) continue;
                hasPermission = false;
                break;
            }
        }
        return hasPermission;
    }

    private void createMetadataFieldsForUiAssetMaps(UiTitleList uiTitleList, List<AssetListAssetMap> assetsMap) {
        for (AssetListAssetMap assetListAssetMap : assetsMap) {
            UiAssetMap uiAssetMap = this.findUiAssetMap(uiTitleList.getAssets(), assetListAssetMap);
            if (uiAssetMap == null) continue;
            for (AssetListElementMetadata alem : assetListAssetMap.getListElementMetadata()) {
                UiMetadataField metadataField = new UiMetadataField();
                metadataField.setName(alem.getName());
                this.setUiMetadataTypeAndValueFromElementMetadata(metadataField, alem);
                uiAssetMap.getMetadataFields().add(metadataField);
            }
        }
    }

    private UiAssetMap findUiAssetMap(List<UiAssetMap> assets, AssetListAssetMap assetListAssetMap) {
        UiAssetMap uiAssetMap = null;
        for (UiAssetMap assetMapTemp : assets) {
            if (assetListAssetMap.getId() != assetMapTemp.getId()) continue;
            uiAssetMap = assetMapTemp;
            break;
        }
        return uiAssetMap;
    }

    private List<UiMetadataField> convertToUiMetadataFields(List<AssetListMetadata> listMetadata) {
        ArrayList<UiMetadataField> metadataFieldsList = new ArrayList<UiMetadataField>();
        for (AssetListMetadata metadata : listMetadata) {
            UiMetadataField metadataField = new UiMetadataField();
            metadataField.setName(metadata.getName());
            this.setUiMetadataTypeAndValueFromMetadata(metadataField, metadata);
            metadataFieldsList.add(metadataField);
        }
        return metadataFieldsList;
    }

    private void setUiMetadataTypeAndValueFromMetadata(UiMetadataField metadataField, AssetListMetadata alMetadata) {
        if (alMetadata.getDataType().equals((Object)DataType.BOOLEAN)) {
            metadataField.setDataType(UiDataType.BOOLEAN);
            metadataField.setValue(this.convertToString(alMetadata.getBooleanValue()));
        } else if (alMetadata.getDataType().equals((Object)DataType.DATE)) {
            metadataField.setDataType(UiDataType.DATE);
            metadataField.setValue(this.convertToString(alMetadata.getDateValue()));
        } else if (alMetadata.getDataType().equals((Object)DataType.FLOAT)) {
            metadataField.setDataType(UiDataType.FLOAT);
            metadataField.setValue(this.convertToString(alMetadata.getFloatValue()));
        } else if (alMetadata.getDataType().equals((Object)DataType.IMAGE)) {
            metadataField.setDataType(UiDataType.IMAGE);
            byte[] data = alMetadata.getImageValue();
            if (data != null) {
                metadataField.setValue(new String(new Base64().encode(data)));
            }
        } else if (alMetadata.getDataType().equals((Object)DataType.INTEGER)) {
            metadataField.setDataType(UiDataType.INTEGER);
            metadataField.setValue(this.convertToString(alMetadata.getIntegerValue()));
        } else if (alMetadata.getDataType().equals((Object)DataType.STRING)) {
            metadataField.setDataType(UiDataType.STRING);
            metadataField.setValue(alMetadata.getStringValue());
        } else if (alMetadata.getDataType().equals((Object)DataType.TIME)) {
            metadataField.setDataType(UiDataType.TIME);
            metadataField.setValue(alMetadata.getTimeValue());
        }
    }

    private void setUiMetadataTypeAndValueFromElementMetadata(UiMetadataField metadataField, AssetListElementMetadata alem) {
        if (alem.getDataType().equals((Object)AssetListElementDataType.IMAGE)) {
            metadataField.setDataType(UiDataType.IMAGE);
            byte[] data = alem.getImageValue();
            if (data != null) {
                metadataField.setValue(new String(new Base64().encode(data)));
            }
        } else if (alem.getDataType().equals((Object)AssetListElementDataType.STRING)) {
            metadataField.setDataType(UiDataType.STRING);
            metadataField.setValue(alem.getStringValue());
        } else if (alem.getDataType().equals((Object)AssetListElementDataType.INTEGER)) {
            metadataField.setDataType(UiDataType.INTEGER);
            metadataField.setValue(this.convertToString(alem.getIntegerValue()));
        }
    }

    private String convertToString(Long integerValue) {
        String value = null;
        if (integerValue != null) {
            value = integerValue.toString();
        }
        return value;
    }

    private String convertToString(Float floatValue) {
        String value = null;
        if (floatValue != null) {
            value = floatValue.toString();
        }
        return value;
    }

    private String convertToString(Date dateValue) {
        String format = DATE_FORMAT;
        String value = null;
        if (dateValue != null) {
            SimpleDateFormat formatter = new SimpleDateFormat(format);
            value = formatter.format(dateValue);
        }
        return value;
    }

    private String convertToString(Boolean booleanValue) {
        String value = null;
        if (booleanValue != null) {
            value = booleanValue.toString();
        }
        return value;
    }

    private void filterThumbnailColumn(List<UiColumn> columns) {
        int i = 0;
        while (i < columns.size()) {
            UiColumn column = columns.get(i);
            if (column.getName().equalsIgnoreCase(THUMBNAIL_COLUMN_NAME)) {
                columns.remove(column);
                break;
            }
            ++i;
        }
    }

    private static final /* synthetic */ UiTitleList getAssets_aroundBody0(TitleListSearchServiceImpl ajc$this, Long assetListId, List titleColumns, List assetColumns) {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetListManagement_View"});
        ArrayList<UiAssetMap> uiAssetMaps = new ArrayList<UiAssetMap>();
        List<SearchColumn> assetSearchCol = TitleListSearchServiceImpl.convertSearchColumns(assetColumns);
        List<SearchColumn> titleSearchCol = TitleListSearchServiceImpl.convertSearchColumns(titleColumns);
        List assetSearchResults = assetInfoProvider.getTitleAssetInfo(assetListId, assetSearchCol);
        ArrayList<String> titleIds = new ArrayList<String>();
        for (AssetSearchInfo asi : assetSearchResults) {
            ArrayList<UiField> fields = new ArrayList<UiField>();
            for (UiColumn col : assetColumns) {
                if (!col.getFieldType().equals((Object)UIFieldType.ASSET)) continue;
                String xpath = col.getName();
                String displayName = col.getDisplayName();
                String value = (String)asi.getMetaDataFields().get(col.getName());
                fields.add(new UiField(xpath, displayName, value));
            }
            uiAssetMaps.add(new UiAssetMap(asi.getAssetMapId(), asi.getTitleId(), asi.getTitlePartnerId(), new UiAsset(asi.getAssetId(), asi.getAssetType(), fields)));
            titleIds.add(String.valueOf(asi.getTitleId()));
        }
        if (titleIds.isEmpty()) {
            return new UiTitleList(uiAssetMaps.size(), uiAssetMaps);
        }
        PredicateRightValue prv = new PredicateRightValue("id", "", FieldType.PMM_TITLE, titleIds, LogicalOperator.IN, "integer", Boolean.valueOf(false));
        ExpValue ev = new ExpValue((Predicate)prv);
        PagingInfo pagingInfo = new PagingInfo();
        int pageStart = 0;
        pagingInfo.setStartIndex(pageStart);
        pagingInfo.setMaxRecordCount(1000);
        TitleFilter titleFilter = new TitleFilter((ExpNode)ev);
        titleFilter.setPageInfo(pagingInfo);
        TitleSearchResult result = searchService.getSearchResults(titleFilter, new ArrayList(), titleSearchCol);
        List titleSearchResults = result.getRows();
        while (result.hasMoreResults()) {
            pagingInfo.setStartIndex(pageStart += 1000);
            titleFilter.setPageInfo(pagingInfo);
            result = searchService.getSearchResults(titleFilter, new ArrayList(), titleSearchCol);
            titleSearchResults.addAll(result.getRows());
        }
        HashMap<Long, UiTitle> uiTitles = new HashMap<Long, UiTitle>();
        for (TitleSearchResult.SearchRow row : titleSearchResults) {
            ArrayList<UiField> fields = new ArrayList<UiField>();
            int i = 0;
            while (i < titleColumns.size()) {
                UiColumn uiCol = (UiColumn)titleColumns.get(i);
                String value = row.getFirstValueAsString(i);
                if (uiCol.getFieldType().equals((Object)UIFieldType.ASSET)) {
                    fields.add(new UiField(uiCol.getName(), uiCol.getSectionName(), uiCol.getDisplayName(), value));
                } else {
                    fields.add(new UiField(uiCol.getName(), uiCol.getDisplayName(), value));
                }
                ++i;
            }
            uiTitles.put(row.getId(), new UiTitle(row.getId(), fields));
        }
        for (UiAssetMap am : uiAssetMaps) {
            if (uiTitles.get(am.getTitleId()) == null) continue;
            am.getTitle().getFields().clear();
            am.getTitle().getFields().addAll(((UiTitle)uiTitles.get(am.getTitleId())).getFields());
        }
        return new UiTitleList(uiAssetMaps.size(), uiAssetMaps);
    }

    private static final /* synthetic */ Object getAssets_aroundBody1$advice(TitleListSearchServiceImpl ajc$this, Long assetListId, List titleColumns, List assetColumns, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleListSearchServiceImpl.getAssets_aroundBody0(ajc$this, assetListId, titleColumns, assetColumns);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            UiTitleList object = TitleListSearchServiceImpl.getAssets_aroundBody0(ajc$this, assetListId, titleColumns, assetColumns);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

