/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.titlelist.server;

import com.tandbergtv.cms.contentmgmt.service.template.IWorkOrderRequestSender;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetList;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetListAssetMap;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetListElementMetadata;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.AssetListMetadata;
import com.tandbergtv.cms.contentmgmt.titlelist.entities.TitleAssetId;
import com.tandbergtv.cms.contentmgmt.titlelist.model.AssetListElementDataType;
import com.tandbergtv.cms.contentmgmt.titlelist.model.DataType;
import com.tandbergtv.cms.contentmgmt.titlelist.service.AssetListDeleteException;
import com.tandbergtv.cms.contentmgmt.titlelist.service.AssetListErrorCode;
import com.tandbergtv.cms.contentmgmt.titlelist.service.AssetListValidationException;
import com.tandbergtv.cms.contentmgmt.titlelist.service.IAssetListManager;
import com.tandbergtv.cms.contentmgmt.titlelist.service.IAssetListTypeManager;
import com.tandbergtv.cms.contentmgmt.titlelist.service.ITitleListSearch;
import com.tandbergtv.cms.contentmgmt.titlelist.service.TitleListSearchResult;
import com.tandbergtv.cms.portal.content.client.model.UiAsset;
import com.tandbergtv.cms.portal.content.client.model.UiTitle;
import com.tandbergtv.cms.portal.content.client.rpc.WorkOrderCreateResponse;
import com.tandbergtv.cms.portal.content.titlelist.client.model.UiAssetMap;
import com.tandbergtv.cms.portal.content.titlelist.client.model.UiMetadataField;
import com.tandbergtv.cms.portal.content.titlelist.client.model.UiTitleList;
import com.tandbergtv.cms.portal.content.titlelist.client.model.UiTitleLists;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.ITitleListService;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.UiValidationException;
import com.tandbergtv.cms.portal.content.titlelist.client.services.TitleListException;
import com.tandbergtv.cms.portal.content.titlelist.client.services.TitleListExportResponse;
import com.tandbergtv.cms.portal.content.titlelist.client.tab.UiTitleListKey;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.NeptuneAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.pmm.assetlist.AssetListRuntimeException;
import com.tandbergtv.watchpoint.pmm.core.TitlePersistenceException;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.template.ITitleTemplateProvider;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.lang.annotation.Annotation;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.servlet.http.HttpSession;
import javax.transaction.TransactionManager;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;

public class TitleListServiceImpl
implements ITitleListService,
NeptuneRemoteService {
    private static final String INVALID_ASSETS = "invalidAssets";
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private Logger logger = Logger.getLogger(TitleListServiceImpl.class);
    private IAssetListManager assetListManager = (IAssetListManager)InjectionUtil.injectInstance((String)"cms/AssetListManager/local", IAssetListManager.class);
    private IAssetListTypeManager assetListTypeManager = (IAssetListTypeManager)InjectionUtil.injectInstance((String)"cms/AssetListTypeManager/local", IAssetListTypeManager.class);
    private ITitleListSearch listSearchService = (ITitleListSearch)InjectionUtil.injectInstance((String)"cms/TitleListSearch/local", ITitleListSearch.class);
    private IWorkOrderRequestSender requestSender = (IWorkOrderRequestSender)InjectionUtil.injectInstance((String)"cms/TitleListWorkOrderRequestSender/local", IWorkOrderRequestSender.class);
    private HttpSession httpSession;
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ Annotation ajc$anno$1;

    public String getRelativePath() {
        return "service/content/titlelistService";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    @Override
    public UiTitleList get(long id) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetListManagement_View"});
        AssetList al = this.assetListManager.get(id);
        return this.createUiObject(al);
    }

    @Override
    public UiTitleLists getTitlelists(int start, int length, String sortProperty, boolean isAscending) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetListManagement_View"});
        ArrayList<UiTitleList> lists = new ArrayList<UiTitleList>();
        TitleListSearchResult result = this.listSearchService.getTitleLists(start, length, sortProperty, isAscending);
        for (AssetList al : result.getLists()) {
            UiTitleList titleList = new UiTitleList(al.getId(), al.getName(), al.getDescription());
            titleList.setContentClass(al.getContentClass());
            titleList.setType(al.getType());
            for (AssetListAssetMap t : al.getAssetsMap()) {
                if (t == null) continue;
                titleList.addAsset(new UiAssetMap(t.getId(), new UiTitle(t.getTitle().getId().longValue())));
            }
            lists.add(titleList);
        }
        return new UiTitleLists(lists, result.getTotalCount());
    }

    @Override
    @Transactional
    public void addAssetsToTitleList(long assetListId, Map<Long, List<Long>> titleAssetIdsMap) throws NeptuneException {
        long l = assetListId;
        Map<Long, List<Long>> map = titleAssetIdsMap;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = TitleListServiceImpl.class.getDeclaredMethod("addAssetsToTitleList", Long.TYPE, Map.class).getAnnotation(Transactional.class);
        }
        TitleListServiceImpl.addAssetsToTitleList_aroundBody1$advice(this, l, map, transactionEnforcer, (Transactional)annotation, null);
    }

    private ITitleManager getTitleManager() {
        return (ITitleManager)ServiceRegistry.getDefault().lookup(ITitleManager.class);
    }

    @Override
    public void removeAssetsFromTitleList(long titleListId, List<Long> elementIds) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetListManagement_Modify"});
        this.assetListManager.removeAssetsWithElementId(titleListId, elementIds);
    }

    @Override
    @Transactional
    public UiTitleList save(UiTitleList uiTitleList) throws NeptuneException {
        UiTitleList uiTitleList2 = uiTitleList;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = TitleListServiceImpl.class.getDeclaredMethod("save", UiTitleList.class).getAnnotation(Transactional.class);
        }
        return (UiTitleList)TitleListServiceImpl.save_aroundBody3$advice(this, uiTitleList2, transactionEnforcer, (Transactional)annotation, null);
    }

    private void setMetadataTypeAndValueFromUiMetadata(AssetListElementMetadata elementMetadata, UiMetadataField metadataField) {
        String dataTypeValue = metadataField.getDataType().toString();
        if (dataTypeValue.equals(AssetListElementDataType.IMAGE.toString())) {
            elementMetadata.setDataType(AssetListElementDataType.IMAGE);
            elementMetadata.setImageValue(this.convertToImage(metadataField.getValue()));
        } else if (dataTypeValue.equals(AssetListElementDataType.STRING.toString())) {
            elementMetadata.setDataType(AssetListElementDataType.STRING);
            elementMetadata.setStringValue(metadataField.getValue());
        } else if (dataTypeValue.equals(AssetListElementDataType.INTEGER.toString())) {
            elementMetadata.setDataType(AssetListElementDataType.INTEGER);
            elementMetadata.setIntegerValue(this.convertToLong(metadataField.getValue()));
        }
    }

    private void setMetadataTypeAndValueFromUiMetadata(AssetListMetadata alMetadata, UiMetadataField metadataField) {
        String dataTypeValue = metadataField.getDataType().toString();
        if (dataTypeValue.equals(DataType.BOOLEAN.toString())) {
            alMetadata.setDataType(DataType.BOOLEAN);
            alMetadata.setBooleanValue(this.convertToBoolean(metadataField.getValue()));
        } else if (dataTypeValue.equals(DataType.DATE.toString())) {
            alMetadata.setDataType(DataType.DATE);
            alMetadata.setDateValue(this.convertToDate(metadataField.getValue()));
        } else if (dataTypeValue.equals(DataType.FLOAT.toString())) {
            alMetadata.setDataType(DataType.FLOAT);
            alMetadata.setFloatValue(this.convertToFloat(metadataField.getValue()));
        } else if (dataTypeValue.equals(DataType.IMAGE.toString())) {
            alMetadata.setDataType(DataType.IMAGE);
            alMetadata.setImageValue(this.convertToImage(metadataField.getValue()));
        } else if (dataTypeValue.equals(DataType.INTEGER.toString())) {
            alMetadata.setDataType(DataType.INTEGER);
            alMetadata.setIntegerValue(this.convertToLong(metadataField.getValue()));
        } else if (dataTypeValue.equals(DataType.STRING.toString())) {
            alMetadata.setDataType(DataType.STRING);
            alMetadata.setStringValue(metadataField.getValue());
        } else if (dataTypeValue.equals(DataType.TIME.toString())) {
            alMetadata.setDataType(DataType.TIME);
            alMetadata.setTimeValue(metadataField.getValue());
        }
    }

    private byte[] convertToImage(String value) {
        byte[] image = null;
        if (value != null) {
            image = new Base64().decode(value.getBytes());
        }
        return image;
    }

    private Boolean convertToBoolean(String value) {
        Boolean result = null;
        if (value != null && !"".equals(value.trim())) {
            result = Boolean.parseBoolean(value);
        }
        return result;
    }

    private Float convertToFloat(String value) {
        Float number = null;
        if (value != null && !"".equals(value.trim())) {
            try {
                number = Float.valueOf(Float.parseFloat(value));
            }
            catch (NumberFormatException nfe) {
                this.logger.error((Object)nfe);
            }
        }
        return number;
    }

    private Long convertToLong(String value) {
        Long number = null;
        if (value != null && !"".equals(value.trim())) {
            try {
                number = Long.parseLong(value);
            }
            catch (NumberFormatException nfe) {
                this.logger.error((Object)nfe);
            }
        }
        return number;
    }

    private Date convertToDate(String value) {
        String inputFormat = DATE_FORMAT;
        Date date = null;
        if (value != null && !"".equals(value.trim())) {
            try {
                SimpleDateFormat formatter = new SimpleDateFormat(inputFormat);
                date = formatter.parse(value);
            }
            catch (ParseException pe) {
                this.logger.error((Object)pe);
            }
        }
        return date;
    }

    private AssetListAssetMap get(Collection<AssetListAssetMap> assetMaps, long id) {
        for (AssetListAssetMap alam : assetMaps) {
            if (alam.getId() != id) continue;
            return alam;
        }
        return null;
    }

    @Override
    public void delete(List<Long> ids) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetListManagement_Delete"});
        ArrayList<String> errorCodes = new ArrayList<String>();
        for (long id : ids) {
            try {
                this.assetListManager.delete(id);
            }
            catch (AssetListDeleteException e) {
                errorCodes.add(e.getMessage());
            }
        }
        if (!errorCodes.isEmpty()) {
            throw new UiValidationException(errorCodes);
        }
    }

    @Override
    public TitleListExportResponse export(List<Long> ids) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetListManagement_View", "AssetListManagement_Modify"});
        TitleListExportResponse response = new TitleListExportResponse();
        for (long id : ids) {
            try {
                String exportFilePath = this.assetListManager.export(Long.valueOf(id));
                response.getSucessfulExportTitleList().put(id, exportFilePath);
            }
            catch (Exception e) {
                this.logger.error((Object)("Error while exporting title[" + id + "]"), (Throwable)e);
                String message = e.getLocalizedMessage();
                if (message == null && e.getCause() != null) {
                    message = e.getCause().getLocalizedMessage();
                }
                response.getFailedExportTitleList().put(id, message);
            }
        }
        return response;
    }

    private UiTitleList createUiObject(AssetList titleList) {
        UiTitleList uiList = new UiTitleList();
        uiList.setName(titleList.getName());
        uiList.setKey(new UiTitleListKey(titleList.getId()));
        uiList.setDescription(titleList.getDescription());
        uiList.setType(titleList.getType());
        uiList.setContentClass(titleList.getContentClass());
        ArrayList<UiAssetMap> assets = new ArrayList<UiAssetMap>();
        for (AssetListAssetMap alam : titleList.getAssetsMap()) {
            UiTitle uiTitle = new UiTitle(alam.getTitle().getId().longValue());
            UiAsset uiAsset = new UiAsset(alam.getAssetId());
            assets.add(new UiAssetMap(alam.getId(), uiTitle, uiAsset));
        }
        uiList.setAssets(assets);
        uiList.setTotalCount(assets.size());
        return uiList;
    }

    @Override
    public List<String> getTemplates() throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"WorkOrderManagement_Create"});
        ArrayList<String> templates = new ArrayList();
        try {
            ITitleTemplateProvider service = (ITitleTemplateProvider)ServiceRegistry.getDefault().lookup(ITitleTemplateProvider.class);
            templates = service.getTemplateNamesByCategory("TitleListProcessing");
            return templates;
        }
        catch (Exception e) {
            throw new NeptuneException(e.getMessage());
        }
    }

    @Override
    public WorkOrderCreateResponse sendWorkOrderCreateMessage(List<Long> ids, String templateName) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"WorkOrderManagement_Create"});
        WorkOrderCreateResponse response = new WorkOrderCreateResponse();
        for (long id : ids) {
            try {
                this.requestSender.sendWorkOrderCreateMessage(id, templateName);
                response.getQueuedWorkOrders().add(id);
            }
            catch (Exception e) {
                this.logger.error((Object)e);
                response.getFailedIds().put(id, e.getLocalizedMessage());
            }
        }
        return response;
    }

    @Override
    public Map<String, Integer> getErrorsFromHttpSession(long assetListId) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetListManagement_View"});
        HashMap<String, Integer> errorsMap = new HashMap<String, Integer>();
        Integer invalidAssets = this.getValueFromSession(assetListId, INVALID_ASSETS + assetListId);
        errorsMap.put(INVALID_ASSETS + assetListId, invalidAssets);
        return errorsMap;
    }

    private Integer getValueFromSession(long assetListId, String attributeName) {
        Integer value = (Integer)this.httpSession.getAttribute(attributeName);
        this.httpSession.removeAttribute(attributeName);
        return value;
    }

    public void setHttpSession(HttpSession httpSession) {
        this.httpSession = httpSession;
    }

    /*
     * Unable to fully structure code
     */
    private static final /* synthetic */ void addAssetsToTitleList_aroundBody0(TitleListServiceImpl ajc$this, long assetListId, Map titleAssetIdsMap) {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"AssetListManagement_Modify"});
        invalid = 0;
        try {
            titleAssetsToAdd = new ArrayList<TitleAssetId>();
            assetList = ajc$this.assetListManager.get(assetListId);
            if (assetList != null) {
                alContentClass = assetList.getContentClass();
                validator = ajc$this.assetListTypeManager.getValidatorByTypeName(assetList.getType());
                entries = titleAssetIdsMap.entrySet();
                for (Map.Entry<K, V> entry : entries) {
                    titleId = (Long)entry.getKey();
                    title = ajc$this.getTitleManager().get(titleId);
                    for (Long assetId : (List)entry.getValue()) {
                        if (validator != null) {
                            validator.validateAssetToAdd(title, assetId.longValue(), assetList);
                        }
                        if (alContentClass == null || alContentClass.equals(title.getContentClassId())) {
                            titleAssetsToAdd.add(new TitleAssetId(titleId, assetId));
                            continue;
                        }
                        ++invalid;
                    }
                }
            }
            ajc$this.httpSession.setAttribute("invalidAssets" + assetListId, (Object)invalid);
            ajc$this.assetListManager.addAssets(assetListId, titleAssetsToAdd);
        }
        catch (AssetListValidationException e) {
            errorCodesList = new ArrayList<String>();
            errorCodes = e.getCodes();
            i = 0;
            ** while (i < errorCodes.size())
        }
lbl-1000:
        // 1 sources

        {
            code = (AssetListErrorCode)errorCodes.get(i);
            errorMessage = "";
            errorMessage = code.equals((Object)AssetListErrorCode.CUSTOM_ERROR) != false ? e.getMessage() : code.toString();
            errorCodesList.add(errorMessage);
            ++i;
            continue;
        }
lbl39:
        // 1 sources

        uiValidationException = new UiValidationException(errorCodesList);
        throw uiValidationException;
        catch (Exception e) {
            if (e.getCause() instanceof AssetListRuntimeException) {
                throw new TitleListException(((AssetListRuntimeException)e.getCause()).getMessage(), ((AssetListRuntimeException)e.getCause()).getCode().name());
            }
            if (e.getCause() instanceof TitlePersistenceException) {
                errorCode = ((TitlePersistenceException)e.getCause()).getErrorCode();
                errorCode = errorCode.replace("-", "_");
                throw new TitleListException(((TitlePersistenceException)e.getCause()).getMessage(), errorCode);
            }
            throw new TitleListException(((TitlePersistenceException)e.getCause()).getMessage(), "UNEXPECTED_ERROR");
        }
    }

    private static final /* synthetic */ Object addAssetsToTitleList_aroundBody1$advice(TitleListServiceImpl ajc$this, long assetListId, Map titleAssetIdsMap, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            TitleListServiceImpl.addAssetsToTitleList_aroundBody0(ajc$this, assetListId, titleAssetIdsMap);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            TitleListServiceImpl.addAssetsToTitleList_aroundBody0(ajc$this, assetListId, titleAssetIdsMap);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static final /* synthetic */ UiTitleList save_aroundBody2(TitleListServiceImpl ajc$this, UiTitleList uiTitleList) {
        block9: {
            titleListId = uiTitleList.getKey().getId();
            isEdit = titleListId != 0L;
            permission = isEdit != false ? "AssetListManagement_Modify" : "AssetListManagement_Create";
            NeptuneAuthorizationManager.isAuthorized((String[])new String[]{permission});
            bAssetList = isEdit != false ? ajc$this.assetListManager.get(titleListId) : new AssetList();
            bAssetList.setDescription(uiTitleList.getDescription());
            bAssetList.setName(uiTitleList.getName());
            bAssetList.setContentClass(uiTitleList.getContentClass());
            bAssetList.setType(uiTitleList.getType());
            oldOrderAssetMaps = bAssetList.getAssetsMap();
            newOrderAssetMaps = new ArrayList<AssetListAssetMap>();
            for (UiAssetMap uiAssetMap : uiTitleList.getAssets()) {
                elementId = uiAssetMap.getId();
                alam = ajc$this.get(oldOrderAssetMaps, elementId);
                newOrderAssetMaps.add(alam);
            }
            bAssetList.reOrderAssetMaps(newOrderAssetMaps);
            for (UiMetadataField listMetadataField : uiTitleList.getMetadataFields()) {
                alMetadata = bAssetList.getAssetListMetadata(listMetadataField.getName());
                if (alMetadata == null) {
                    alMetadata = new AssetListMetadata();
                    alMetadata.setAssetList(bAssetList);
                    alMetadata.setName(listMetadataField.getName());
                    bAssetList.getListMetadata().add(alMetadata);
                }
                ajc$this.setMetadataTypeAndValueFromUiMetadata(alMetadata, listMetadataField);
            }
            for (UiAssetMap uiAssetMap : uiTitleList.getAssets()) {
                elementId = uiAssetMap.getId();
                alam = ajc$this.get(bAssetList.getAssetsMap(), elementId);
                for (UiMetadataField elementMetadataField : uiAssetMap.getMetadataFields()) {
                    elementMetadata = alam.getAssetListElementMetadata(elementMetadataField.getName());
                    if (elementMetadata == null) {
                        elementMetadata = new AssetListElementMetadata();
                        elementMetadata.setAssetListAssetMap(alam);
                        elementMetadata.setName(elementMetadataField.getName());
                        alam.getListElementMetadata().add(elementMetadata);
                    }
                    ajc$this.setMetadataTypeAndValueFromUiMetadata(elementMetadata, elementMetadataField);
                }
            }
            try {
                bAssetList = isEdit != false ? ajc$this.assetListManager.update(bAssetList) : ajc$this.assetListManager.create(bAssetList);
                break block9;
            }
            catch (AssetListValidationException e) {
                errorCodesList = new ArrayList<String>();
                errorCodes = e.getCodes();
                i = 0;
                ** while (i < errorCodes.size())
            }
lbl-1000:
            // 1 sources

            {
                code = (AssetListErrorCode)errorCodes.get(i);
                errorMessage = "";
                errorMessage = code.equals((Object)AssetListErrorCode.CUSTOM_ERROR) != false ? e.getMessage() : code.name();
                errorCodesList.add(errorMessage);
                ++i;
                continue;
            }
lbl58:
            // 1 sources

            throw new UiValidationException(errorCodesList);
        }
        return ajc$this.createUiObject(bAssetList);
    }

    private static final /* synthetic */ Object save_aroundBody3$advice(TitleListServiceImpl ajc$this, UiTitleList uiTitleList, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return TitleListServiceImpl.save_aroundBody2(ajc$this, uiTitleList);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            UiTitleList object = TitleListServiceImpl.save_aroundBody2(ajc$this, uiTitleList);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

