/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.titlelist.server;

import com.tandbergtv.cms.contentmgmt.titlelist.model.AssetListType;
import com.tandbergtv.cms.contentmgmt.titlelist.model.Field;
import com.tandbergtv.cms.contentmgmt.titlelist.model.Option;
import com.tandbergtv.cms.contentmgmt.titlelist.service.IAssetListTypeManager;
import com.tandbergtv.cms.portal.content.titlelist.client.model.UiAssetListType;
import com.tandbergtv.cms.portal.content.titlelist.client.model.UiDataType;
import com.tandbergtv.cms.portal.content.titlelist.client.model.UiMetadataField;
import com.tandbergtv.cms.portal.content.titlelist.client.rpc.ITitleListTypeService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import java.util.ArrayList;
import java.util.List;

public class TitleListTypeServiceImpl
implements ITitleListTypeService,
NeptuneRemoteService {
    private static final long serialVersionUID = 1L;
    private IAssetListTypeManager assetListTypeManager = (IAssetListTypeManager)InjectionUtil.injectInstance((String)"cms/AssetListTypeManager/local", IAssetListTypeManager.class);

    public String getRelativePath() {
        return "service/content/titlelistTypeService";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    @Override
    public List<UiAssetListType> getTypesWithoutMetadata() throws NeptuneException {
        ArrayList<UiAssetListType> uiTypes = new ArrayList<UiAssetListType>();
        List types = this.assetListTypeManager.getTypes();
        for (AssetListType assetListType : types) {
            uiTypes.add(this.convertTypeToUiType(assetListType));
        }
        return uiTypes;
    }

    @Override
    public UiAssetListType getTypeByName(String name) throws NeptuneException {
        UiAssetListType uiType = new UiAssetListType();
        List types = this.assetListTypeManager.getTypes();
        for (AssetListType assetListType : types) {
            if (!assetListType.getName().equals(name)) continue;
            uiType = this.convertTypeToUiType(assetListType);
            break;
        }
        return uiType;
    }

    private UiAssetListType convertTypeToUiType(AssetListType assetListType) {
        UiAssetListType uiAssetListType = new UiAssetListType(assetListType.getName(), assetListType.getDisplayName());
        ArrayList<UiMetadataField> uiListMetadataFields = new ArrayList<UiMetadataField>();
        for (Field field : assetListType.getListMetadata()) {
            UiMetadataField uiField = new UiMetadataField(field.getName(), field.getDisplayName(), UiDataType.valueOf(field.getDataType().toString()));
            uiField.setRequired(field.isRequired());
            ArrayList<UiMetadataField.Option> options = new ArrayList<UiMetadataField.Option>();
            for (Option option : field.getOptions()) {
                options.add(new UiMetadataField.Option(option.getKey(), option.getValue()));
            }
            uiField.setOptions(options);
            uiListMetadataFields.add(uiField);
        }
        uiAssetListType.setListMetadata(uiListMetadataFields);
        ArrayList<UiMetadataField> uiElementMetadataFields = new ArrayList<UiMetadataField>();
        for (Field field : assetListType.getAssetMetadata()) {
            UiMetadataField uiField = new UiMetadataField(field.getName(), field.getDisplayName(), UiDataType.valueOf(field.getDataType().toString()));
            uiField.setRequired(field.isRequired());
            ArrayList<UiMetadataField.Option> options = new ArrayList<UiMetadataField.Option>();
            for (Option option : field.getOptions()) {
                options.add(new UiMetadataField.Option(option.getKey(), option.getValue()));
            }
            uiField.setOptions(options);
            uiElementMetadataFields.add(uiField);
        }
        uiAssetListType.setElementMetadata(uiElementMetadataFields);
        return uiAssetListType;
    }
}

